
// Copyright 1992, David Perelman-Hall & Jamshid Afshar

#include <fstream.h>
#include <strstream.h>
#include <string.h>
#include "rules.h"


ostream& operator << ( ostream& os, const Rule& rule )
{
   os << rule._lhs << " -> " << rule._rhs;
   return os;
}

RuleList::RuleList()
   : _num(0)
{
}

const MAX_LINE = 260;
void RuleList::read(const char *file_name)
{
   ifstream infile(file_name);
   char buff[MAX_LINE];

   while (infile.good()) {
      infile.getline(buff, MAX_LINE);
      if (infile.eof()) break;
      add(buff);
   }
}

void RuleList::add(const char *rule_str)
{
   assert(_num < MAX_RULES);

   char temp_rule_str[MAX_LINE];
   strcpy(temp_rule_str, rule_str);
   istrstream rule_stream(temp_rule_str, strlen(rule_str)+1);

   char cat_str[MAX_STRING_LEN];
   rule_stream >> cat_str;
   _arr[_num]._lhs = Category(cat_str);

   _arr[_num]._rhs.clear();
   while (rule_stream.good()) {
      rule_stream >> cat_str;
      _arr[_num]._rhs += Category(cat_str);
   }

   cout << "Adding rule: " << _arr[_num] << "\n";

   _num++;
}
