//**************************************************************************
//	This is a demo program to show how to use some of the features of
//	the GUI libraries of the ObjectEase package. To compile and run this
//	demo create a project file including the files GUI.LIB and GUIDEMO.CPP.
//	Make sure that the files are located where the project says they are.
//	You may also need to change to path to the GUI.H file in the #includes
//	portion of this file.
//
//	Also note that the following files MUST be in the same directory as
//	The executable for this program to operate properly:
//
//		B1.BTN
//		B2.BTN
//		I1.ICN
//		I2.ICN
//		I3.ICN
//
//	BE SURE YOU ARE COMPILING FOR THE LARGE MEMORY MODEL!!!
//**************************************************************************

#include "gui.h"
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <graphics.h>

#define BKG     3

//*************************  FUNCTION PROTOTYPES  **************************

void initgraphicdemo();
void gbuttondemo();
void graphbuttondemo();
void paneldemo();
void icondemo();
void acticondemo();
void gmenudemo();
void inputdemo();
void mcursordemo();

void write3d(int,char *);
void early_exit();
void norm_exit();
void do_siren();
void do_tele();

//***************************  GLOBAL VARIABLES  ***************************

extern Mcursor the_mouse;
Screen screen;
int mouse_present=0;
char ch;

//**************************************************************************
//              MAIN
 //**************************************************************************

void main()
{
	initgraphicdemo();
	closegraph();
	puts("Thank you for previewing the ObjectEase library from");
	puts("David S. Reinhart Associates");
	exit(0);
}

//**************************************************************************
//**************************************************************************
//**************************************************************************

void initgraphicdemo()
{
	screen.VGA_480_16();
	delay(1000);

	if(!the_mouse.init()) {
		puts("Unable to detect mouse driver. Graphic portion of this demo");
		puts("requires a mouse.");
		closegraph();
		exit(1);
		}

	setfillstyle(SOLID_FILL,BKG);
	bar(0,0,getmaxx(),getmaxy());

	Bevel mainpanel;

	mainpanel.init(50,75,540,125,THICK);
	mainpanel.show();

	settextjustify(CENTER_TEXT,TOP_TEXT);
	write3d(100,"ObjectEase graphics demonstration for Borland C++ and");
	write3d(115,"Turbo C++. This demo and the included graphics library file(s)");
	write3d(130,"(c) Copyright 1992, David S. Reinhart Associates");

	write3d(160,"Press the <ENTER> key or the right mouse key to progress through");
	write3d(175,"the demo.");

	Panel copyrightpanel;
	copyrightpanel.init(3,455,634,21,OUT,THIN);
	copyrightpanel.show();
	setcolor(0);
	write3d(465,"(c) Copyright 1992 - David S. Reinhart Associates");

	the_mouse.arm();

	int selected=0;
	while(!selected) {
		while(!kbhit() && !the_mouse.RBP());
		if(kbhit()) {
			if((ch=getch())==27)
				early_exit();
			while(kbhit())getch();
			selected=1;
			}
		if(the_mouse.RBP())
			selected=1;
		}

	gbuttondemo();
	graphbuttondemo();
	icondemo();
	acticondemo();
	paneldemo();
	gmenudemo();
	inputdemo();
	mcursordemo();
}

//**************************************************************************

void mcursordemo()
{
	int cur=1;

	the_mouse.hide();
	setfillstyle(SOLID_FILL,3);
	bar(0,0,getmaxx(),getmaxy()-30);

	write3d(20,"Press the left mouse key to cycle through cursors.");
	write3d(35,"Press right mouse key to end.");

	the_mouse.show();
	while(!the_mouse.RBP()) {
		if(the_mouse.LBP()) {
			cur++;
			if(cur>16)cur=1;
			the_mouse.changeto(cur);
			while(the_mouse.LBP());
			}
		}
}

//**************************************************************************

void gbuttondemo()
{
	setfillstyle(SOLID_FILL,BKG);
	the_mouse.hide();
	bar(0,0,getmaxx(),getmaxy()-40);

	Bevel mainpanel;
	mainpanel.init(30,70,580,230,THICK);
	mainpanel.show();

	write3d(85,"Buttons are one of the most fundamental graphic objects.");
	write3d(100,"They are very popular within graphics environments");
	write3d(115,"for getting user input. You, the programmer, have complete");
	write3d(130,"control over how these button objects function. That is");
	write3d(145,"to say, whether the resulting action takes place when the");
	write3d(160,"button is pressed or released; how long the button remains");
	write3d(175,"depressed; etc...  Experiment with the buttons below.");

	Button lowbutton;
	Button medbutton;
	Button hibutton;
	Panel buttonpanel;

	lowbutton.init(150,230," LOW ",TEXT);
	medbutton.init(300,230," MED ",TEXT);
	hibutton.init(450,230," HI  ",TEXT);
	buttonpanel.init(130,220,390,45,IN,THICK);
	buttonpanel.show();

	lowbutton.show();
	medbutton.show();
	hibutton.show();

	the_mouse.show();
	int selected=0;

	flushkeys();
	while(!selected) {
		if(the_mouse.LBP()) {
			if(lowbutton.hit()) {
				lowbutton.press();
				while(the_mouse.LBP() && lowbutton.hit());
				lowbutton.show();
				if(lowbutton.hit()) {
					sound(220);
					delay(500);
					nosound();
					continue;
					}
				}
			if(medbutton.hit()) {
				medbutton.press();
				while(the_mouse.LBP() && medbutton.hit());
				medbutton.show();
				if(medbutton.hit()) {
					sound(440);
					delay(500);
					nosound();
					continue;
					}
				}
			if(hibutton.hit()) {
				hibutton.press();
				while(the_mouse.LBP() && hibutton.hit());
				hibutton.show();
				if(hibutton.hit()) {
					sound(880);
					delay(500);
					nosound();
					continue;
					}
				}
			}// end if the_mouse.LBP
		if(the_mouse.RBP()) {
			selected=1;
			}
		if(kbhit()) {
			if((ch=getch())==27)
				early_exit();
			while(kbhit())getch();
			selected=1;
			}
		}// end while !selected
}

//**************************************************************************

void graphbuttondemo()
{
	the_mouse.hide();
	setfillstyle(SOLID_FILL,BKG);
	bar(0,0,getmaxx(),getmaxy()-40);

	Bevel mainpanel;
	mainpanel.init(50,50,getmaxx()-100,250,THICK);
	mainpanel.show();

	write3d(75,"Buttons can have not only text labels, but graphics as well!");
	write3d(90,"Graphics not only make the interface look nicer, but can");
	write3d(105,"also make the button's function more intuitive for the end user.");
	write3d(120,"Try to guess what the outcome will be before trying out each of");
	write3d(135,"the buttons below.");
	write3d(165,"By the way, these graphic buttons are easy to create using the");
	write3d(180,"ICONEDIT program supplied in this package.");

	Panel buttonpanel;
	Button sirenbutton;
	Button telebutton;

	buttonpanel.init(270,220,100,50,IN,THICK);
	buttonpanel.show();
	sirenbutton.init(285,235,"b1",1);
	telebutton.init(330,235,"b2",1);
	sirenbutton.show();
	telebutton.show();
	the_mouse.show();

	flushkeys();
	int selected=0;
	while(!selected) {
		if(the_mouse.RBP())
			selected=1;
		if(kbhit()) {
			if((ch=getch())==27)
				early_exit();
			while(kbhit())getch();
			selected=1;
			}
		if(the_mouse.LBP()) {
			if(sirenbutton.hit()) {
				sirenbutton.press();
				while(the_mouse.LBP() && sirenbutton.hit());
				sirenbutton.show();
				if(sirenbutton.hit()) {
					do_siren();
					continue;
					}
				}
			if(telebutton.hit()) {
				telebutton.press();
				while(the_mouse.LBP() && telebutton.hit());
				telebutton.show();
				if(telebutton.hit()) {
					do_tele();
					continue;
					}
				}
			}
		}
}

//**************************************************************************

void paneldemo()
{
	the_mouse.hide();
	setfillstyle(SOLID_FILL,BKG);
	bar(0,0,getmaxx(),getmaxy()-40);

	Bevel mainpanel;
	mainpanel.init(10,10,getmaxx()-20,70,THICK);
	mainpanel.show();

	write3d(25,"Panels offer an attractive way to partition the graphics screen.");
	write3d(40,"Here are some of the different types of panels that can easily");
	write3d(55,"be implemented using the ObjectEase library.");

	Panel inthick;
	Panel inthin;
	Panel outthick;
	Panel outthin;
	Bevel thin;
	Bevel thick;

	delay(2000);
	write3d(90,"THICK STYLES                               THIN STYLES");
	inthick.init(50,105,200,100,IN,THICK);
	inthick.show();
	inthin.init(390,105,200,100,IN,THIN);
	inthin.show();
	delay(1000);
	outthick.init(50,220,200,100,OUT,THICK);
	outthick.show();
	outthin.init(390,220,200,100,OUT,THIN);
	outthin.show();
	delay(1000);
	thick.init(50,335,200,100,THICK);
	thick.show();
	thin.init(390,335,200,100,THIN);
	thin.show();

	the_mouse.show();
	flushkeys();
	while(!kbhit() && !the_mouse.RBP());
	if(kbhit()) {
		if((ch=getch())==27)
			early_exit();
		while(kbhit())getch();
		}
}

//**************************************************************************

void icondemo()
{
	the_mouse.hide();
	setfillstyle(SOLID_FILL,BKG);
	bar(0,0,getmaxx(),getmaxy()-40);

	Bevel mainpanel;
	mainpanel.init(50,50,getmaxx()-100,200,THICK);
	mainpanel.show();

	write3d(75,"What paint program would be complete without icons? Icons are");
	write3d(90,"as intuitive to use as buttons, and once again, using the");
	write3d(105,"ICONEDIT program, they are easy for you, the programmer, to");
	write3d(120,"create. Check out the action of the icons below...");

	Panel iconpanel;
	Icon drawicon;
	Icon painticon;

	iconpanel.init(250,160,getmaxx()-500,50,IN,THICK);
	iconpanel.show();
	drawicon.init(280,170,"i1");
	painticon.init(330,170,"i2");
	drawicon.show();
	painticon.show();
	the_mouse.show();

	flushkeys();
	int selected=0;
	while(!selected) {
		if(the_mouse.RBP())
			selected=1;
		if(kbhit()) {
			if((ch=getch())==27)
				early_exit();
			while(kbhit())getch();
			selected=1;
			}
		if(the_mouse.LBP()) {
			if(painticon.hit()) {
				if(!painticon.ispressed()) {
					painticon.choose();
					drawicon.show();
					while(the_mouse.LBP());
					continue;
					}
				}
			if(drawicon.hit()) {
				if(!drawicon.ispressed()) {
					drawicon.choose();
					painticon.show();
					while(the_mouse.LBP());
					continue;
					}
				}
			}
		}
}

//**************************************************************************

void acticondemo()
{
	the_mouse.hide();
	setfillstyle(SOLID_FILL,BKG);
	bar(0,0,getmaxx(),getmaxy()-40);

	Bevel mainpanel;
	mainpanel.init(50,50,getmaxx()-100,300,THICK);
	mainpanel.show();

	write3d(75,"Here's a neat graphic feature that you don't see everyday.");
	write3d(90,"Want to really jazz up your interface? Want to make it stand");
	write3d(105,"out in a crowd?! Instead of reversing the image of your icons");
	write3d(120,"when they are selected, make them come to life! Click the icon");
	write3d(135,"below to see what I mean.");
	write3d(165,"And guess what... Right! These icons are also easy to create");
	write3d(180,"using the ICONEDIT program");

	Panel iconpanel;
	iconpanel.init(270,230,getmaxx()-(270*2),70,IN,THICK);
	iconpanel.show();
	Acticon aicon;
	aicon.init(305,250,"i3");
	aicon.show(1);
	the_mouse.show();

	int selected=0;
	while(!selected) {
		if(the_mouse.RBP())
			selected=1;
		if(kbhit()) {
			if((ch=getch())==27)
				early_exit();
			while(kbhit())getch();
			selected=1;
			}
		if(the_mouse.LBP()) {
			if(aicon.hit()) {
				while(!the_mouse.RBP() && !kbhit())
					aicon.backforth(2);
				if(kbhit()) {
					flushkeys();
					selected=1;
					}
				if(the_mouse.RBP())
					selected=1;
				}
			}
		}
}

//**************************************************************************

void gmenudemo()
{
	the_mouse.hide();
	setfillstyle(SOLID_FILL,BKG);
	bar(0,0,getmaxx(),getmaxy()-40);

	Bevel mainpanel;
	mainpanel.init(30,50,getmaxx()-60,130,THICK);
	mainpanel.show();

	write3d(75,"Do you need to include point and shoot type menu bars in your");
	write3d(90,"applications? No problem! Using the ObjectEase library makes it a snap");
	write3d(105,"for you to include graphic pulldown menus! See for yourself below.");
	write3d(120,"You may want to note that the way these menus are implemented");
	write3d(135,"requires you to keep the left mouse key pressed until you have made");
	write3d(150,"your selection.");

	setfillstyle(SOLID_FILL,15);
	bar(0,200,getmaxx(),210);
	setfillstyle(SOLID_FILL,1);
	bar(0,211,getmaxx(),350);

	Gmenubutton menubutton1;
	Gmenubutton menubutton2;
	gitemarray  itemarray1;
	gitemarray  itemarray2;
	Gmenu       gmenu1;
	Gmenu       gmenu2;

	strcpy(itemarray1[1],"Item 1");
	strcpy(itemarray1[2],"Item 2");
	strcpy(itemarray1[3],"Item 3");
	strcpy(itemarray1[4],"Item 4");

	strcpy(itemarray2[1],"Item 1");
	strcpy(itemarray2[2],"Item 2");
	strcpy(itemarray2[3],"Item 3");
	strcpy(itemarray2[4],"Item 4");

	gmenu1.init(0,211,4,itemarray1);
	gmenu2.init(100,211,4,itemarray2);

	menubutton1.init(0,200,0,15,15,0,"Menu 1");
	menubutton2.init(100,200,0,15,15,0,"Menu 2");
	menubutton1.show();
	menubutton2.show();
	the_mouse.show();

	int selected=0;
	while(!selected) {
		if(kbhit()) {
			if((ch=getch())==27)
				early_exit();
			flushkeys();
			selected=1;
			}
		if(the_mouse.RBP())
			selected=1;
		if(the_mouse.LBP()) {
			if(menubutton1.hit()) {
				menubutton1.press();
				gmenu1.show();
				gmenu1.hide();
				menubutton1.show();
				}
			if(menubutton2.hit()) {
				menubutton2.press();
				gmenu2.show();
				gmenu2.hide();
				menubutton2.show();
				}
			}
		}
}

//**************************************************************************

void inputdemo()
{
	the_mouse.hide();
	setfillstyle(SOLID_FILL,BKG);
	bar(0,0,getmaxx(),getmaxy()-40);

	Bevel mainpanel;
	mainpanel.init(30,50,getmaxx()-60,150,THICK);
	mainpanel.show();

	write3d(75,"Getting text input from a graphic based application used to be");
	write3d(90,"a real hassle... NO MORE! The ObjectEase includes functions for");
	write3d(105,"laying out text input fields, simulating the text cursor, and");
	write3d(120,"handling the text strings input by the user. Now you can");
	write3d(135,"capture graphic text input as easily as in text mode.");
	write3d(150,"Try out the sample dialog below.");

	Panel dialogpanel;
	dialogpanel.init(150,250,getmaxx()-300,85,IN,THICK);
	dialogpanel.show();

	setcolor(15);
	settextjustify(LEFT_TEXT,TOP_TEXT);
	gprintxy(170,275,"First Name: ");
	gprintxy(170,305,"Last Name:  ");

	Gstring fname;
	Gstring lname;
	fname.init(270,279,20,0);
	lname.init(270,309,20,0);
	fname.show();
	lname.show();

	fname.get_input();
	lname.get_input();

	write3d(400,"Press <ENTER> to continue...");

	flushkeys();
	while(!the_mouse.RBP() && !kbhit());
	if(kbhit()) {
		if((ch=getch())==27)
			early_exit();
		flushkeys();
		}
}

//**************************************************************************

void write3d(int y,char *text)
{
	settextjustify(CENTER_TEXT,TOP_TEXT);
	setcolor(0);
	outtextxy(getmaxx()/2,y,text);
	setcolor(15);
	outtextxy((getmaxx()/2)-1,y-1,text);
}

//**************************************************************************

void do_siren()
{
	int i;

	for(i=500;i<1000;i+=7) {
		sound(i);
		delay(12);
		}
	for(i=1000;i>500;i-=7) {
		sound(i);
		delay(12);
		}
	nosound();
}

//**************************************************************************

void do_tele()
{
	int i;

	for(i=0;i<14;i++) {
		sound(440);
		delay(30);
		sound(880);
		delay(30);
		}
	nosound();
}

//**************************************************************************

void early_exit()
{
	closegraph();
	puts("You have not seen the entire demonstration.");
	exit(0);
}
