/* -------------------------------------------------------------------- */
/* String++ Version 3.00                                       04/10/93 */
/*                                                                      */
/* Enhanced string class for Turbo C++/Borland C++.                     */
/* Copyright 1991-1993 by Carl W. Moreland                              */
/*                                                                      */
/* parsestr.cpp                                                         */
/* -------------------------------------------------------------------- */

#include "parsestr.h"

/* ----- Constructors/Destructors ------------------------------------- */

ParseString::ParseString(): String()
{
  offset = 0;
}

ParseString::ParseString(const char* p): String(p)
{
  offset = 0;
}

ParseString::ParseString(const string& s): String(s)
{
  offset = 0;
}

ParseString::~ParseString(void)
{
  Reset();
}

/* ----- SetStr/AddStr ------------------------------------------------ */

void ParseString::SetStr(const char* p)
{
  Reset();				// reset the string
  String::SetStr(p);
}

void ParseString::SetStr(const string& s)
{
  Reset();				// reset the string
  String::SetStr(s);
}

void ParseString::AddStr(const char c)
{
  unsigned n = offset;			// save the offset
  Reset();				// reset the string
  String::AddStr(c);			// add new contents

  operator+=(n);			// reapply the offset
}

void ParseString::AddStr(const char* p)
{
  unsigned n = offset;			// save the offset
  Reset();				// reset the string
  String::AddStr(p);			// add new contents

  operator+=(n);			// reapply the offset
}

void ParseString::AddStr(const string& s)
{
  unsigned n = offset;			// save the offset
  Reset();				// reset the string
  String::AddStr(s);			// add new contents

  operator+=(n);			// reapply the offset
}

void ParseString::Reset(void)
{
  strPtr -= offset;			// reset strPtr to zero position
  strLen += offset;			// reset strLen
  offset = 0;
}

const char* ParseString::Offset(unsigned n)
{
  if(strLen >= n-offset)
  {
    strPtr -= offset;			// reset strPtr to zero position
    strLen += offset;			// reset strLen
    offset  = n;			// new absolute offset
    strPtr += n;			// increment strPtr
    strLen -= n;			// set strLen
  }
  return strPtr;
}

/* ----- Operators ---------------------------------------------------- */

String& ParseString::operator=(const char* p)
{
  SetStr(p);
  return *this;
}

String& ParseString::operator=(const String& s)
{
  SetStr(s);
  return *this;
}

const char* ParseString::operator++()
{
  if(strLen > 0)
  {
    ++offset;
    ++strPtr;
    --strLen;
  }
  return strPtr;
}

const char* ParseString::operator++(int)
{
  if(strLen > 0)
  {
    offset++;
    strPtr++;
    strLen--;
  }
  return strPtr;
}

const char* ParseString::operator--()
{
  if(offset > 0)
  {
    --offset;
    --strPtr;
    ++strLen;
  }
  return strPtr;
}

const char* ParseString::operator--(int)
{
  if(offset > 0)
  {
    offset--;
    strPtr--;
    strLen++;
  }
  return strPtr;
}

const char* ParseString::operator+=(const unsigned n)
{
  if(strLen >= n)
  {
    offset += n;
    strPtr += n;
    strLen -= n;
  }
  return strPtr;
}

const char* ParseString::operator-=(const unsigned n)
{
  if(offset >= n)
  {
    offset -= n;
    strPtr -= n;
    strLen += n;
  }
  return strPtr;
}
