/*****************************************************************
*  AddID.C
*  written by Kathy Cea, Platinum Software Int'l
*
*  Allows a supervisor to assign an application-specific
*  user id for a given network user.  Stores the id in the bindery as a
*  property which can later be verified using the VerID program.
*  AddID can also be used to change the application-specific user id.
*
*  Calling Syntax:
*   AddID <user-network-id> <appl-id> <user-id>
*     where <user-network-id> is the user's network (login) id
*           <appl-id> is a name assigned to the application (max 12 chars)
*           <user-id> is the user's id for the application (acts like a
*                     password)
*
*   Compiled in Turbo C 2.0 with NetWare C function calls
*****************************************************************/

#include <stdio.h>
#include <nit.h>
#include <niterror.h>

char objectName[48];
char propertyName[16];
char applName[13];
BYTE propertyFlags= 0; /* Static, Item */
BYTE propertySecurity = 0x32; /* Supervisor write, Object read */
BYTE propertyValue[128];
BYTE moreSegments = 0;
int retcode;

main(int argc, char *argv[])
{
   if(argc < 4) {
        printf("Too few parameters supplied\n");
        exit(1);
    }
    strcpy(objectName, strupr(argv[1]));
    strcpy(applName,strupr(argv[2]));
    strcpy(propertyValue,strupr(argv[3]));
    /* To enforce conformity, we'll append "ID" to the end of the
       application name stored in the bindery */
    strcpy(propertyName,applName);
    strcat(propertyName,"ID");

/* Add the property (application name) for the user */
    retcode = CreateProperty(objectName,OT_USER,propertyName,
                propertyFlags,propertySecurity);
/* Assign the property value (application-specific userid) */
    if (retcode == SUCCESSFUL || retcode == PROPERTY_ALREADY_EXISTS) {
        retcode = WritePropertyValue(objectName,OT_USER,propertyName,
                    1,propertyValue,moreSegments);
        if (retcode == SUCCESSFUL)
            printf("Successful\n");
        else
            printf("Unable to assign value\n");
    }
    else
        printf("Unable to assign property\n");
}

