/*****************************************************************
*  IsEquiv.C
*  written by Kathy Cea, Platinum Software Int'l
*
*  IsEquiv is a utility to check whether the user has a security
*  equivalence to the specified user/group.  Designed to be used from a
*  DOS batch file.
*
*  Calling Syntax:
*     IsEquiv <user/group>
*       <user/group> - The name of the user or group to be checked
*
*  Returns the following:
*      0 - User has the security equivalence
*      1 - No user/group name was supplied on the command line
*      2 - User does not have the security equivalence
*      3 - User/Group does not exist
*      4 - Other error
*
*   Compiled in Turbo C 2.0 with NetWare C function calls
*****************************************************************/

#include <stdio.h>
#include <nit.h>
#include <niterror.h>

WORD ConnectNumber;
char objectName[48],secequiv[48];
WORD objectType;
long objectID;
BYTE loginTime[7];


main(int argc, char *argv[])
{
       if(argc < 2) {
            printf("No Security Equivalence supplied\n");
            exit(1);
    }
    strcpy(secequiv, argv[1]);

    /* Get the user's object name */
    ConnectNumber =  GetConnectionNumber();
    GetConnectionInformation(ConnectNumber, objectName,
            &objectType, &objectID,loginTime);

    /* Check for a user equivalence */
    if (IsBinderyObjectInSet(objectName, OT_USER,"SECURITY_EQUALS",
            secequiv, OT_USER) == SUCCESSFUL) {
            exit(0);
        }
    else
    /* Check for a group equivalence */
    switch (IsBinderyObjectInSet(objectName, OT_USER,"SECURITY_EQUALS",
            secequiv, OT_USER_GROUP)){
        case SUCCESSFUL:
            exit(0);
        case NO_SUCH_MEMBER:
            exit(2);
        case NO_SUCH_OBJECT:
            exit(3);
        default:
            exit(4);
        }
}

