/*****************************************************************
*  LastLog.C
*  written by Kathy Cea, Platinum Software Int'l
*
*  LastLog is a utility to list the last login date and time of
*  all network users.
*
*  Calling Syntax:
*     LastLog [N]
*       Include the optional N parameter to suppress
*       page breaks (useful if redirecting output to a file)
*
*   Compiled in Turbo C 2.0 with NetWare C function calls
*
*   Note: This is the complete version of the program included in the
*         Bindery API article in the March 1991 issue of DBMS.  It
*         includes code to format the output.
*
*         Only a Supervisor (or equivalent) can run this program
*         successfully.
*****************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <dos.h>
#include <nit.h>
#include <niterror.h>
#define MAXNAME 48

void getlastlog (char *);
double today();
int year(), day(), month();
void moremsg();
void newpage();

int i,j;
int linecnt = 0;
int maxline = 17;
int pagecnt = 0;
int pagebrk = 1;
double todaycal;
char todaystr[9];
int pagesw;

main(int argc, char *argv[]){

    WORD objectType;
    char objectName[MAXNAME];
    long objectId;
    int retcode;
    BYTE propertyValue[128];
    BYTE moreSegs,
         propertyFlags;
    int segNum;
    BYTE temp[3];
    BYTE holdobjId[9];
    char *endptr;
    segNum = 1;
    moreSegs = 255;


/* Check for the [N] switch to indicate "No page breaks" */
    if (argc > 1) {
        pagesw = toupper(argv[1][0]);
        if (pagesw == 'N')
            pagebrk = 0;
        }

/* Get today's date and format for printing */
    todaycal = today();
    sprintf(todaystr,"%02d/%02d/%02d",
                    month(todaycal),
                    day(todaycal),
                    year(todaycal));

/* Display page header */
    newpage();

/* Get all users of group EVERYONE
   Object ID of users are passed back in the propertyValue field
   Up to 32 Object Ids can be returned on each pass.  Continue
   calling ReadPropertyValue until moreSegs is No (0) */

    while (moreSegs) {
    retcode = ReadPropertyValue("EVERYONE", OT_USER_GROUP,
                            "GROUP_MEMBERS", segNum,
                            propertyValue, &moreSegs, &propertyFlags);
    segNum++;

    /* parse the propertyValue for 4-byte Object IDs,
       then convert each ID to a long integer */
    i = 0;
    temp[2] = '\0';
    holdobjId[0] = '\0';
    while (i < 128) {
        for (j=0; j < 4; j++) {
            /* Build a hex string for each Object ID */
            sprintf(temp, "%02x", propertyValue[i]);
            temp[2] = '\0';
            strcat(holdobjId, temp);
            i++;
        } /* for (j=0; j < 4; j++) */

        objectId = strtoul(holdobjId, &endptr, 16);

        /* Pass user's Object ID and receive User Name */
        retcode = GetBinderyObjectName(objectId, objectName, &objectType);
        if (!retcode)
            getlastlog(objectName);
        holdobjId[0] = '\0';
    }  /* while (i < 128) */
    } /* while (moreSegs) */
} /* main() */

void getlastlog (char objectName[MAXNAME])
/* Gets the last login date & time and the full name for the
    user passed in objectName */

{
    WORD objectType;
    int retcode;
    BYTE propertyValue[128];
    BYTE moreSegs,
         propertyFlag;
    char lastlogdt[9];
    char lastlogtm[9];

    objectType = OT_USER;

/* Read the user's LOGIN_CONTROL property value to obtain the last
   login date & time */

    retcode = ReadPropertyValue(objectName, objectType, "LOGIN_CONTROL", 1,
        propertyValue, &moreSegs, &propertyFlag);
    if (!retcode){
        sprintf(lastlogdt,"%02d/%02d/%02d",
                            propertyValue[57],
                            propertyValue[58],
                            propertyValue[56]);
        sprintf(lastlogtm,"%02d:%02d:%02d",
                            propertyValue[59],
                            propertyValue[60],
                            propertyValue[61]);
        lastlogdt[8] = '\0';
        lastlogtm[8] = '\0';
        /* Read the user's IDENTIFICATION property value to obtain the
           full name - Assumes full names no longer than 35 characters */
           retcode = ReadPropertyValue(objectName, objectType, "IDENTIFICATION", 1,
                     propertyValue, &moreSegs, &propertyFlag);
            printf("%-20s",objectName);
            printf("%-35s",propertyValue);
            if (!strcmp(lastlogdt,"00/00/00"))
                printf("No Logins\n");
            else
                printf("%-8s\t%-8s\n",lastlogdt, lastlogtm);
            linecnt++;
    } /* if (!retcode) */
    else {
        printf("%-20s",objectName);
        printf("%44s\n","No Logins");
        linecnt++;
    }
    if ((linecnt > maxline) && pagebrk)
        newpage();
    return;
}

void newpage()
/* Handle page headers and breaks */
{
    if (pagecnt++ > 0)
        moremsg();
    clrscr();
    printf("                  Last Login Date for All Users\n\n");
    printf("Report Date:  %s                                              Page: %d\n\n",todaystr,pagecnt);
    printf("UserId              Full Name                              Last Login\n");
    printf("------------------------------------------------------------------------------\n");
    linecnt = 0;
}

void moremsg()
/* Pause after each screen, and display message */
{
    fprintf(stderr,"Press any key to continue...");
    getch();
}

int year(double cal)
/* Return the year portion of a date */
{
        return floor(cal / 10000.0);
}

int day(double cal)
/* Return the day portion of a date */
{
        return floor(cal - (floor(cal / 100.0) * 100.0));
}

int month(double cal)
/* Return the month portion of a date */
{
    return floor((cal - (year(cal) * 10000.0) - day(cal)) / 100.0);
}

double today()
/* Get today's date */
{
    struct date d;

    getdate(&d);
    return (d.da_year - 1900) * 10000.0 + d.da_mon * 100.0 + d.da_day;
}

