// == field.cpp === Constructor for field objects ===================
//                  Copyright 1991 Wes Peterson

#include "eb_edit.h"

field::field(table& tabl, char *field_name)
{
    tbl = &tabl;

	DbGetNamedFieldInfo(tbl->id, field_name, &fldarg);

    switch(fldarg.fldtype)	{
    	case DTYPINT:
        	data = (void *) new int;
            if(fldarg.fldpict[0] == '\0') 
            	strcpy(fldarg.fldpict, "5");
            break;    
        case DTYPLOG:
        	data = (void *) new int;
            if(fldarg.fldflag[0] == '\0')
                strcpy(fldarg.fldflag, "t'Yes'f'No'");
            break;
        case DTYPLNG:
        	data = (void *) new long;
            if(fldarg.fldpict[0] == '\0')
            	strcpy(fldarg.fldpict, "10");
            break;
        case DTYPDAT:
        	data = (void *) new long;
            if(fldarg.fldpict[0] == '\0')
            	strcpy(fldarg.fldpict, "0m/0d/yy");
            break;
        case DTYPTIM:
        	data = (void *) new long;
            if(fldarg.fldpict[0] == '\0')
            	strcpy(fldarg.fldpict, "0h:mm pm");
            break;
        case DTYPSTR:
        case DTYPPAK:
        	data = (void *) new char[fldarg.fldlen + 1];
            if(fldarg.fldpict[0] == '\0')	{
            	itoa(fldarg.fldlen, fldarg.fldpict, 10);
                fldarg.fldpict[strlen(fldarg.fldpict)] = 'x';
                fldarg.fldpict[strlen(fldarg.fldpict) + 1] = '\0';
                }
            break;
        case DTYPDBL:
        	data = (void *) new double;
            if(fldarg.fldpict[0] == '\0')
            	strcpy(fldarg.fldpict, "11.2");
            break;
        case DTYPBCD:
        	data = (void *) new BCD;
            if(fldarg.fldpict[0] == '\0')
            	strcpy(fldarg.fldpict, "11.2");
            break;
        }
    tbl->fields.add_node(this);
}
