/*----------------------------------------------------------------
	main.c
	Program skeleton for testing the contour map algorithm
	
	This program reads in a MacPaint document, unpacks
	it, and calls the contour analysis algorithms.
	
	Once the analysis is complete the program writes out a
	file called grid.dat that can be read by hidlinpix and
	displayed in 3D perspective with hidden lines removed.
	
	hidlinpix is a program published in "Programming
	Principles in Computer Graphics" by Leendert
	Ammeraal (John Wiley & Sons, 1986)
	
	Other notes:
	
	Data structure libraries are derived from Alan Holub's
	column in Doctor Dobb's Journal.  These include the AVL
	tree and the queue.
	
	I modified the Lightspeed C stdio library so that the stdio
	console window occupies only the lower 1/3 of the screen.
	I then use the upper 2/3 for a window to display the source
	contour map and a second window to display the progress of the
	algorithm.
	
	William May
	303A Ridgefield Circle
	Clinton, MA 01510
	
	Jan 25, 1986	created
  ----------------------------------------------------------------*/

#include <stdio.h>
#include <WindowMgr.h>
#include "contour.h"

TREE 		*root = 0L;
WindowPtr 	left_wind;
WindowPtr 	right_wind;
BitMap		bmap;
curve_data 	curves[100];		/* array of curve data */

main()
{
	char c;
	Rect r;
	int width;
	
	/* force the LSC stdio window to open by doing a printf */
	printf("Program Starting\n\n");
	
	/* suppress the LSC dialog window when the program ends */
	Click_On(false);

	/* open some windows... */	
	init_windows();
	
	init_mem();

	/* read in the MacPaint document, named "test" */
	if (read_MP("\ptest", &bmap)) {
		r.top    = 0;
		r.bottom = VBITMAX;
		r.left   = 0;
		r.right  = HBITMAX;
		show_bmap(left_wind, &bmap, &r);
						
		find_all_contours();
	}

	make_hidlin();	/* make the input file for hidlinpix */

	/*
	   A "real" program should return allocated memory to the
	   system here, etc.  I will just return and let the heap
	   reinitialization take care of everything.
	*/
	
	printf("Program complete. <cr> to continue: ");
	c = getchar();
}

/*--------------------------------------------------------------------
	init_windows opens the two windows used for testing graphics
	algorithms.  The console window is opened automatically
	by stdio when a printf is called.  No window template resources
	are used.  The two window records are kept in application global
	space.
  --------------------------------------------------------------------*/
init_windows()
{
	static WindowRecord left_wrec, right_wrec;
	int height, width;
	Rect r;
	
	height = 180;
	width  = 144;
	
	r.top    = 22;
	r.left   = 20;
	r.bottom = r.top + height;
	r.right  = r.left + width;
	
	left_wind = NewWindow(&left_wrec, &r, "\p", true, altDBoxProc,
		FrontWindow(), false, 0L);
	
	r.left = 184;
	r.right = r.left + width;
	
	right_wind = NewWindow(&right_wrec, &r, "\p", true, altDBoxProc,
		FrontWindow(), false, 0L);
}

