/* cache header */

typedef struct CACHE {
  int	recl;		/* record length */
  int	maxr;		/* number of records in cache */
  long	hits;		/* number of true finds for cacfind() */
  long	miss;		/* number of misses for cacfind() */
  long	adds;		/* number of calls to cacnew() */
  int	(*proc)();	/* pointer to function for processing */
  long	idnt;		/* identifier passed to proc() */
  long	*nums;		/* numbers of records */
  char	*recs;		/* pointer to first record */
  short	*next;		/* array of next pointers */
  short *prio;		/* array of prior pointers */
  char	*mark;		/* array of process-record markers */
  short	lru;		/* oldest index */
  short mru;		/* newest index */
  } CACDS;

long	cacamem;	/* amount of memory allocated */

CACDS	*cacallo(int, int, int ( *)(), long);
char  	*cacmem (int);
char  	*cacnum (struct CACHE  *, long);
char  	*cacold (struct CACHE  *);
int 	 cacflsh(struct CACHE  *);
int 	 cacnew (struct CACHE  *, short);
char  	*cacfind(struct CACHE  *, long);
int 	 cacproc(struct CACHE  *, long);
int	 cacunpc(struct CACHE  *, long);
int 	 cacstat(struct CACHE  *, long  *, long  *, long  *);
int 	 cacfree(struct CACHE  *);

