#include <stdio.h>                                                                           
#include <io.h>                                                                              
#include <stdlib.h>                                                                          
#include <string.h>                                                                          
#include <malloc.h>                                                                          
                                                                                             
#include "loc.h"                                                                             
#include "externs.h"                                                                         
                                                                                             
                                                                                             
void  create_bootstrap(seg_list, entry)                                                      
SEG_DESCRIPTOR *seg_list ;                                                                   
unsigned char  *entry ;                                                                      
{                                                                                            
   unsigned int   count ;                                                                    
   unsigned char  *ptr ;                                                                     
                                                                                             
   SEG_DESCRIPTOR *p, *q ;                                                                   
                                                                                             
   /*                                                                                        
      This function sets up a new class which contains the bootstrap                         
      code to the program entry point.  The bootstrap segment is                             
      always located at physical address FFFF0H is ROMable.                                  
                                                                                             
      The bootstrap record is appended to the load module for the                            
      purpose of locate processing.                                                          
   */                                                                                        
                                                                                             
   /* Traverse the linked list to the end */                                                 
   p = seg_list ;                                                                            
   while (p->next != NULL)                                                                   
      p = p->next ;                                                                          
                                                                                             
   /* Allocate the memory for the bootstrap record */                                        
   if ((q = (SEG_DESCRIPTOR *) malloc(sizeof (*p))) == NULL)  {                              
      perror(__FILE__) ;                                                                     
      exit(1) ;                                                                              
   }                                                                                         
                                                                                             
   /* Append the bootstrap record to the end of the list */                                  
   p->next = q ;                                                                             
                                                                                             
   /* Initialize the bootstrap segment descriptor */                                         
   strcpy(q->name, "??BOOT") ;                                                               
   strcpy(q->class, "(ABSOLUTE)") ;                                                          
   q->vseg = 0xffff ;                                                                        
   q->pseg = 0xffff ;                                                                        
   q->offset = 0x0000 ;                                                                      
   q->len = 5 ;                                                                              
   q->inited = TRUE ;                                                                        
   q->romable = TRUE;                                                                        
   q->symbols = 0 ;                                                                          
   q->symbol_list = NULL ;                                                                   
   q->next = NULL ;                                                                          
                                                                                             
   /* Allocate RAM and build the reset vector code using a far jump */                       
   ptr = malloc(q->len) ;                                                                    
   *ptr = 0xEA ;                                                                             
   *((unsigned char **)(ptr + 1)) = entry ;                                                  
                                                                                             
   /* Append the bootstrap code on tail of the load module */                                
   q->position = lseek(tmp_file, 0L, SEEK_END) ;                                             
   count = write(tmp_file, ptr, q->len) ;                                                    
   if (count != q->len)   {                                                                  
      perror(__FILE__) ;                                                                     
      exit(1) ;                                                                              
   }                                                                                         
                                                                                             
   free(ptr) ;                                                                               
   return ;                                                                                  
}                                                                                            