#define  MAX_TOKEN      80                                                                   
#define  MAX_LINE       80                                                                   
#define  FILENAME       80                                                                   
#define  COMMAND_LINE   256                                                                  
                                                                                             
#define  PAGE_SIZE      512                                                                  
                                                                                             
#define  ERROR    0     /* Error condition exists */                                         
#define  OK       1     /* No error(s) detected */                                           
                                                                                             
#define  T_EOL    -2    /* Reached the end of a line */                                      
#define  T_ERROR  -1    /* Detected an error condition */                                    
#define  T_OK     0     /* Everything fine */                                                
#define  T_OCT    1     /* Octal format integer */                                           
#define  T_DEC    2     /* Decimal format integer */                                         
#define  T_HEX    3     /* Hexidecimal format integer */                                     
#define  T_WORD   4     /* Symbol character string */                                        
#define  T_OP     5     /* Operator character string */                                      
                                                                                             
typedef  enum  { FALSE = 0, TRUE }  BOOLEAN ;                                                
                                                                                             
#define  low_byte(x)    ((x) & 0xff)                                                         
#define  high_byte(x)   (low_byte((x) >> 8))                                                 
#define  dim(x)         (sizeof(x)/sizeof(x[0]))                                             
                                                                                             
typedef  struct {                                                                            
      unsigned int   signature ;                                                             
      unsigned int   length ;                                                                
      unsigned int   pages ;                                                                 
      unsigned int   reloc_items ;                                                           
      unsigned int   header_size ;                                                           
      unsigned int   min_para ;                                                              
      unsigned int   max_para ;                                                              
      unsigned int   stack_seg_disp ;                                                        
      unsigned int   initial_sp ;                                                            
      unsigned int   checksum ;                                                              
      unsigned int   initial_pc ;                                                            
      unsigned int   code_seg_disp ;                                                         
      unsigned int   first_reloc_item ;                                                      
      unsigned int   overlay_num ;                                                           
   } EXE_HEADER ;                                                                            
                                                                                             
                                                                                             
typedef  struct sym_list  {                                                                  
            struct sym_list *next ;                                                          
            char  name[32] ;                                                                 
            unsigned int   value ;                                                           
            unsigned char  type ;                                                            
         } SYMBOL_LIST ;                                                                     
                                                                                             
typedef  struct  seg_descriptor  {                                                           
            struct seg_descriptor   *next ;                                                  
            long  position ;                                                                 
            char  name[32] ;                                                                 
            char  class[32] ;                                                                
            unsigned int   vseg ;                                                            
            unsigned int   pseg ;                                                            
            unsigned int   offset ;                                                          
            unsigned int   len ;                                                             
            int   inited ;                                                                   
            int   romable ;                                                                  
            unsigned int   symbols ;                                                         
            SYMBOL_LIST *symbol_list ;                                                       
         } SEG_DESCRIPTOR ;                                                                  
                                                                                             
char  *load_exe_file() ;                                                                     
SEG_DESCRIPTOR *build_seg_list() ;                                                           
                                                                                             
int   get_ch() ;                                                                             
int   unget_ch() ;                                                                           
char  *get_cmd() ;                                                                           
char  *get_line() ;                                                                          
                                                                                             
int get_token() ;                                                                            
                                                                                             
char  *get_mem(unsigned long) ;                                                              
void  free_mem(char *) ;                                                                     
                                                                                             
char  *process_command_line() ;                                                              
void  read_symbol_table(SEG_DESCRIPTOR *) ;                                                  
                                                                                             
void  output_hex_OMF(int, SEG_DESCRIPTOR *, unsigned char *) ;                               
void  open_file_system() ;                                                                   
void  close_file_system() ;                                                                  
void  break_handler() ;                                                                      
                                                                                             
#define  DATA_RECORD    0                                                                    
#define  EOF_RECORD     1                                                                    
#define  ADDR_RECORD    2                                                                    
#define  START_RECORD   3                                                                    
                                                                                             
void  write_START_record(int, unsigned char *) ;                                             
void  write_ADDR_record(int, unsigned int ) ;                                                
void  write_DATA_record(int, unsigned int, unsigned char *,                                  
                           unsigned int ) ;                                                  
void  write_EOF_record(int) ;                                                                
void  output_hex_record(int, unsigned char, unsigned int,                                    
                           unsigned char *, unsigned char) ;;                                