#include <stdio.h>                                                                           
#include <stdlib.h>                                                                          
#include <string.h>                                                                          
#include <time.h>                                                                            
                                                                                             
#include "loc.h"                                                                             
#include "externs.h"                                                                         
                                                                                             
                                                                                             
int   print_statistics(map_filename, stat_filename, command_line, \                          
      exename, output_file, configname, entry_point)                                         
char  *map_filename ;                                                                        
char  *stat_filename ;                                                                       
char  *command_line ;                                                                        
char  *exename ;                                                                             
char  *output_file ;                                                                         
char  *configname ;                                                                          
unsigned char  *entry_point ;                                                                
{                                                                                            
   unsigned long  temp ;                                                                     
   long  ltime ;                                                                             
   int   i ;                                                                                 
   SEG_DESCRIPTOR *p ;                                                                       
   SYMBOL_LIST *q ;                                                                          
                                                                                             
   /*                                                                                        
      This function generates the locate map file.  The locate map                           
      file contains the segment information with the physical                                
      segment addresses.                                                                     
   */                                                                                        
                                                                                             
   fprintf(print_file, "MS-DOS Locate Utility Version 1.0\n\n") ;                            
   fprintf(print_file, "Input File: %s\n", exename) ;                                        
   fprintf(print_file, "Output File: %s\n", output_file) ;                                   
   fprintf(print_file, "Configuration File: %s\n", configname) ;                             
   fprintf(print_file, "Invoked by: %s\n", command_line) ;                                   
                                                                                             
   time(&ltime) ;                                                                            
   fprintf(print_file, "Date/Time: %s\n", ctime(&ltime)) ;                                   
                                                                                             
   /* Display the located segment information */                                             
   fprintf(print_file, "Segment Information\n");                                             
   fprintf(print_file, "%-16s%-16s%-12s%-12s\n", "Name", "Class",                            
               "Address", "Length");                                                         
                                                                                             
   p = seg_list ;                                                                            
   while (p != NULL)   {                                                                     
      temp = (unsigned long) p->pseg ;                                                       
      temp = temp * 16 + p->offset ;                                                         
      fprintf(print_file, "%-16s%-16s%05lXH%10.04XH\n", p->name,                             
                  p->class, temp, p->len) ;                                                  
      p = p->next ;                                                                          
   }                                                                                         
                                                                                             
   /* Display the symbol information */                                                      
   fprintf(print_file, "\n\nPublic Symbols\n");                                              
   i = 0 ;                                                                                   
   p = seg_list ;                                                                            
   while (p != NULL)   {                                                                     
      q = p->symbol_list ;                                                                   
      while (q != NULL)   {                                                                  
         fprintf(print_file, "%04X:%04X  %-16s%s", p->pseg,                                  
                     q->value, q->name, i++ ? "\n" : "\t\t") ;                               
         i %= 2 ;                                                                            
         q = q->next ;                                                                       
      }                                                                                      
      p = p->next ;                                                                          
   }                                                                                         
                                                                                             
   fprintf(print_file, "%sEntry Point - %p\n", (i == 1) ? "\n\n" : "\n",                     
               entry_point) ;                                                                
                                                                                             
   return ;                                                                                  
}                                                                                            