;         RALL16 - square roots of 1 to 65535 
;         By Ray Mariella, Nov 1986   
           page    ,96
;
crlf      macro
          mov    dl,13
          call   char_out
          mov    dl,10
          call   char_out
          endm
;
time_print macro byte_var, byte_string
          local plenty
          mov    dl,byte_string             ;output a colon or period
          call   char_out
          cmp    byte_var,9
          ja     plenty
          mov    dl,'0'                     ;space holder if var<10
          call   char_out
plenty:   mov    al,byte_var                ;minutes, secs, or hnds
          xor    ah,ah
          call   dec_out
          endm
;
;
data      segment  word public 'DATA'
          even                          
base             dw  10                       ;base to print the numbers in
uper             db  ?
secs             db  ?
hnds             db  ?
announc          db  'square roots of 1 - 65535 ',13,10,'$'
data      ends
;
;
stack     segment   stack
                 dw  64  dup(?)       
stack     ends
;
;
code      segment  word public 'CODE'
          assume cs:code, ds:data, ss:stack
          even                     
;
sqrt:     mov    ax,data
          mov    ds,ax
crlf
          mov    dx,offset announc
          mov    ah,9                    ;print string function
          int    21h                     ;DOS interrrupt
          mov    dl,13
          call   char_out
;
          call  update
          mov    cx,65535
;
;      square root procedure via 8086, integer in CX
;
boundit:  mov    ax,1                   ;infimum - will be lower bound
          mov    dx,cx                   ;supremum - will be upper bound
;
; the next section gets the max lower bound and the min upper bound
          REPT   8
          shl    ax,1                   ;mpy infimum by 2
          cmp    ax,dx                  ;above supremum ?
          ja     root                   ; then done
          shr    dx,1                   ;if not, div supremum by 2
          mov    bx,dx                  ;store supr.
          mov    si,ax                  ;store infim.
          ENDM
;
root:     add    bx,si                  ;get avg. of bounds for
          shr    bx,1                   ;first guess of root
          mov    ax,cx
;
;      Newton's Method =>  X = (Xo + N/Xo)/2
;
Newton:   
          xor    dx,dx           ;prepare for division
          div    bx              ;ax still has target
          add    bx,ax           ;newton
          shr    bx,1
;
; we now have a square root in bx
;
;to print, remove the next 8 semicolons
;         mov   ax,cx
;         call  dec_out
;         mov   dl,' '
;         call  char_out
;         mov   ax,bx
;         call  dec_out
;         crlf
didit:   loop boundit
;
done:     call update
          crlf
          xor    al,al
          mov    ah,4Ch
          int    21h
;
;
;         output a hex word in decimal
;
;         CX,AX,DX destroyed
;
dec_out   proc   near
          xor    cx,cx
another:  inc    cx
          xor    dx,dx
          div    base                   ;base is 10 decimal!
          push   dx                     ;remainder is less sig digits
          or     ax,ax                  ;is the quotient zero?
          jnz    another                ;if not, more number to convert
print_dig:
          pop    dx                     ;retrive digit from stack
          add    dl,'0'                 ;ascii offset
          call   char_out
          loop   print_dig              ;do all of the digits
          ret
dec_out   endp
;
;         output a single character
;
char_out  proc   near
          mov    ah,2                   ;output char function
          int    21h                    ;do it
          ret
char_out  endp
;
;
update    proc  near
          mov    ah,2ch                 ;get dos time
          int    21h                    ;hour in ch, mins in cl,secs in dh
          mov    uper,cl
          mov    secs,dh
          mov    hnds,dl
          mov    al,ch
          xor    ah,ah
          call   dec_out
;
          time_print uper,':'
;
          time_print secs,':'
;
          time_print hnds,'.'
;
          crlf
          ret
update    endp
;
code      ends
          end    sqrt   


