/* MENUDEMO.C: Demonstrates principles of menu bars and pop-down   */
/*             menus in Turbo C                                    */
/* --------------------------------------------------------------- */
/* INCLUDES */
#include <dos.h>
#include <video.i>
#include <colors.h>
#include <menubar.i>
#include <popwin.i>
 
/* LOCAL FUNCTION PROTOTYPES */
void popFileMenu (POPDESCR *mfile, char *text);
void popEditMenu (POPDESCR *medit, char *text);
 
/* STATICS FOR PROGRAM */
char entries[] = {"File\0Edit\0Browse\0Reports\0Exit\0"};
MENUBARSPEC menuspec = {{BLUE}, {WHITE}, {5}, {&entries}};
char fileMenu[] = {"Open\nSave\nNew file\nAbandon"};
char editMenu[] = {"Select record\nRemove field\nAdd field"};
/* --------------------------*/
main ()
{
static POPDESCR filePop = {{1}, {2}, {8}, {5}, {0}, {2}};
POPDESCR   editPop;
char       *prevScrn;
int        n, oldx, oldy, cols;
 
/* SET UP POP-DOWN MENU FOR FILE SELECTION */
  filePop.textAttr = chattr (YELLOW, BLUE);
 
/* SET UP POP-DOWN MENU FOR EDIT SELECTION */
  editPop = filePop;
  editPop.left = 80 / menuspec.nsels + 1;
  editPop.right = editPop.left + 12;
  editPop.bottom = editPop.top + 2;
 
/* NOW SHOW THE TWO MENUS IN SUCCESSION */
  setmode (3);
  cls ();
  menubar (&menuspec);                               /* write menu */
  printf ("\nActive page is %d", activepage()); /* show video info */
  printf ("\nVideo mode is %d", videomode (&cols));
  printf ("\nNumber of columns on screen is %d", cols);
  oldx = wherex (activepage());
  oldy = wherey (activepage());
  printf ("\nCursor is at x = %d, y = %d", oldx, oldy);
  gotoxy (oldx, oldy, activepage());
  getch ();                                   /* wait for keypress */
  cursoff ();
  popFileMenu (&filePop, fileMenu);          /* pop down file menu */
  popEditMenu (&editPop, editMenu);
  setcursor (0, cursend());                 /* make a block cursor */
  gotoxy (oldx, oldy, activepage());
  puts ("\nPress any key to end demo...");
  getch ();
  setcursor (cursend()-1, cursend());  /* restore underline cursor */
  cls ();
} /* ------------------------ */
void popFileMenu (POPDESCR *mfile, char *text)
{
char   *prevScrn;
  prevScrn = saveScrn ();
  popMake (mfile);
  popPuts (0, 0, text, mfile);
  getch ();
  restScrn (prevScrn);
} /* ------------------------ */
void popEditMenu (POPDESCR *medit, char *text)
{
char   *prevScrn;
 
  prevScrn = saveScrn ();
  popMake (medit);
  popPuts (0, 0, text, medit);
  getch ();
  restScrn (prevScrn);
} /* ------------------------ */
