/*------------------------------ file information -----------------------------*/
																											
/* 		
	custom controls demo.c	

 		c source code file for a minimal Mac program that demonstrates 
 			controls drawn with a custom CDEF resource

 		the custom CDEF resource that's demonstrated provides 16 button variations
 		the buttons 
 				  live in a rectangular space
 				  can be outlined, shadowed, or bare
 				  can contain text in any font-style-size, an icon, or a picture
 				  can indicate highlighting via inversion or a change of content
 	
	edited and compiled with Lightspeed C 2.13
	
	written and 1987 by Stan Krute. all rights reserved. no part of this file, 
	or the object code it leads to, may be reproduced, in any form or by any means, 
	without	the express written permission of the author and copyright holder. 
	
	timestamp:		3:49 pm PST     			November 16, 1987 
	spacestamp:		18617 Camp Creek Road	Hornbrook, California   96044
	
 	this file looks good in 9 point Courier, LSC tabs set to 3
*/


/*--------------------------------- include files -----------------------------*/

/* definitions for Mac OS managers used herein */
#include	"ControlMgr.h"
#include	"DialogMgr.h"		
#include	"EventMgr.h"	
#include	"FontMgr.h"	
#include	"MenuMgr.h"	
#include	"Quickdraw.h"					
#include	"StdFilePkg.h"

/* our stuff */
#include	"custom controls demo.h"		/*   private definitions for this file  */ 


/*----------------------------- main program block ----------------------------*/

void	main()

		{
		/* local variable */
		int		theItem ;
		
		/* initialize Mac OS managers  */
		initializeManagers() ; 			
		
		/* see what the world is like */
		studyAndSetEnvironment () ;
		
		/* set up and draw a (dummy) title menu */
		InsertMenu( GetMenu(titleMenuID), append ) ;
		DrawMenuBar() ;

		/* set up and draw a modal dialog window */
		getThatDialogCookin () ;
		
		/* initalize our doneness indicator */
		finished = false ;
		
		/*  run the main event loop   */
		do													
			{
			ModalDialog (noFilterProcedure, &theItem) ;
			dealWithDialogItem (theItem) ;
			}
		while											
			( ! finished ) ;

		/*  leave neatly when done */
		DisposDialog (ourDialog) ;			/* bye bye to dialog */
		ExitToShell() ;						/* bye bye to program */
		}


/*---------------------------- initializeManagers -----------------------------*/

/*   initialize the heap, cursor, and Mac Operating System managers    */

void	initializeManagers()
		
		{
		/* local variable */
		Handle		someDay ;
		
		/* get some space */
		MoreMasters() ;									/* get some master pointers */
		if (someDay = NewHandle(humungousBlock))	/* grow a maximal heap by */ 
			DisposHandle (someDay) ; 					/* asking for the future */ 
			  
		/* get those managers going */
		InitGraf(&thePort) ;						/* set up Quickdraw */
		InitFonts();								/* set up the Font Manager */
		InitWindows();								/* set up the Window Manager */
		InitMenus();								/* set up the Menu Manager */
		TEInit();									/* set up Text Edit */
		InitDialogs (noResumeProcedure) ;	/* set up the Dialog Manager */

		/* final adjustments */
		FlushEvents (everyEvent, dontStop ) ;	/* clear the event queue */
		InitCursor();									/* turn the cursor on */
		}


/*---------------------------- studyAndSetEnvironment -------------------------*/

/*   check out screens, machines, ROMs, et al */

void	studyAndSetEnvironment () 
		
		{
		/* check out the screen */
		screenRect = screenBits.bounds ;
		screenHeight = screenRect.bottom - screenRect.top ;
		screenWidth = screenRect.right - screenRect.left ; 
		
		/* determine height of the menu bar */
		if 	( ROM85 & 0x8000 )
			menuBarHeight = stdMBarHeight ;  	/* for 64K ROMs	*/
		else
			menuBarHeight = MBarHeight ;			/* for newer ROMs	*/
		}


/*------------------------------- getThatDialogCookin -------------------------*/

/* set up and draw our main modal dialog window */

void	getThatDialogCookin ()

		{
		/* local variables */
		Point				tempPoint ;
		Rect				scratch ;
		ControlHandle	theButton ;
		
		/* get the dialog window */
		ourDialog = GetNewDialog (ourDialogID, storeInHeap, inFront) ;
		
		/* adjust its position  */
		MoveWindow ( ourDialog, 
					   (tempPoint = figureCenteredRectTLC (&(*ourDialog).portRect)).h,
				 	       tempPoint.v, inFront ) ;
		
		/* make dialog window the current grafPort so we can change its font */
		SetPort (ourDialog) ;
		
		/* change its font to Geneva 12 */
		TextFont (geneva) ;
		TextSize (12) ;
		
		/* show the dialog */
		ShowWindow (ourDialog ) ;
		}


/*-------------------------------- dealWithDialogItem -------------------------*/

 /* deal with the hit item */  
 
void	dealWithDialogItem (theItem) 
		int		theItem ;
		
		{
		/* local constants */
		#define		oolSize		6
		
		/* local variables */
		static	short	onOffList[oolSize] = { 	orwellItem, hupCoupleItem, 
															ronItem, saveAsItem, 
															pinheadItem, duplicateItem} ; 
		/* case out on the item */
		switch (theItem)
			{
			case quitItem:
				finished = true ;
				break ;
			case orwellItem:
				doOrwellItem () ;
				break ;
			case snapshotItem:
				doSnapshotItem () ;
				break ;
			case mushroomItem:
				doMushroomItem () ;
				break ;
			case openItem:
				doOpenItem () ;
	 			break ;
			case saveAsItem:
				doSaveAsItem () ;
				break ;
			case flipItem:
				doFlipItem () ;
				break ;
			case someOffItem:
				doSomeOffItem (onOffList, oolSize) ;
				break ;
			case someOnItem:
				doSomeOnItem (onOffList, oolSize) ;
				break ;
			case copyrightItem:
				doCopyrightItem () ;
				break ;
			default:
				break ;
			}
		
		/* remove local constants */
		#undef		oolSize
		}


/*--------------------------------- doOrwellItem ------------------------------*/

/* deal with a click of the orwellItem  button */

void	doOrwellItem () 
		
		{
		/* local constants */
		#define			cyclesDesired		4
		#define			delayTicksOne		20
		#define			delayTicksTwo		10
		
		/* local variables */
		Rect				scratch ;
		ControlHandle	theItemHandle ;
		short				cycleCounter ;
		ControlHandle	ronItemHandle ;
		
		/* get a handle to the button */
		GetDItem ( ourDialog, orwellItem, &scratch, &theItemHandle, &scratch) ;
		
		/* hilite the button */
		HiliteControl (theItemHandle, hilitedHS ) ;
		
		/* get a handle to the ronItem button */
		GetDItem ( ourDialog, ronItem, &scratch, &ronItemHandle, &scratch) ;

		/* run several fade cycles on the ronItem button  */
		for ( cycleCounter = 0; cycleCounter < cyclesDesired; cycleCounter++)
			{
			/* fade out */
			HiliteControl (ronItemHandle, inactiveHS ) ;

			/* wait a while */
			Delay (delayTicksOne, &scratch) ;
			
			/* back into view */
			HiliteControl (ronItemHandle, activeHS ) ;

			/* wait a while */
			Delay (delayTicksTwo, &scratch) ;
			}

		/* unhilite the button */
		HiliteControl (theItemHandle, activeHS ) ;

		/* remove local constants */
		#undef		cyclesDesired
		#undef		delayTicksOne
		#undef		delayTicksTwo	
		}

		
/*--------------------------------- doSnapshotItem ----------------------------*/

/* deal with a click of the snapshotItem button */

void	doSnapshotItem () 
		
		{
		/* local variables */
		ControlHandle	theItemHandle ;
		Rect				scratch ;
		GrafPtr			entryGrafPort ;
		
		/* get a handle to the button */
		GetDItem ( ourDialog, snapshotItem, &scratch, &theItemHandle, &scratch) ;
		
		/* hilite the button */
		HiliteControl (theItemHandle, hilitedHS ) ;
	
		/* save a pointer to the grafPort */
		GetPort(&entryGrafPort) ;			

		/* this lets me take some snapshots */
		/* has no effect unless you have a desk accessory named Camera */
		OpenDeskAcc ("\007\000Camera") ;
		
		/* restore the grafPort */
		SetPort(entryGrafPort) ;
		
		/* unhilite the button */
		HiliteControl (theItemHandle, activeHS ) ;
		}
		
		
/*--------------------------------- doMushroomItem ----------------------------*/

/* deal with a click of the mushroomItem  button */

void	doMushroomItem () 
		
		{
		/* local constants */
		#define			cyclesDesired		4
		#define			delayTicks			30
		
		/* local variables */
		Rect				scratch ;
		short				cycleCounter ;
		ControlHandle	itemHandleOne ;
		ControlHandle	itemHandleTwo ;
		
		/* get a handle to the button */
		GetDItem ( ourDialog, mushroomItem, &scratch, &itemHandleOne, &scratch) ;
		
		/* hilite the button */
		HiliteControl (itemHandleOne, hilitedHS ) ;
		
		/* get a handle to the bumperStickersItem button */
		GetDItem ( ourDialog, bumperStickersItem, &scratch, 
						&itemHandleTwo, &scratch) ;

		/* run several fade cycles on the bumperStickersItem button  */
		for ( cycleCounter = 0; cycleCounter < cyclesDesired; cycleCounter++)
			{
			/* fade out */
			HiliteControl (itemHandleTwo, hilitedHS ) ;

			/* wait a while */
			Delay (delayTicks, &scratch) ;
			
			/* back into view */
			HiliteControl (itemHandleTwo, activeHS ) ;

			/* wait a while */
			Delay (delayTicks, &scratch) ;
			}

		/* unhilite the button */
		HiliteControl (itemHandleOne, activeHS ) ;

		/* remove local constants */
		#undef		cyclesDesired
		#undef		delayTicks
		}

		
/*----------------------------------- doOpenItem ------------------------------*/

/* deal with a click of the openItem button */

void	doOpenItem () 

		{
		/* local variables */
		Rect				scratch ;
		ControlHandle	theItemHandle ;
		DialogTHndl		theDLOGHandle ;
		SFReply			dummyReply ;
		
		/* get a handle to the button */
		GetDItem ( ourDialog, openItem, &scratch, &theItemHandle, &scratch) ;
		
		/* hilite the button */
		HiliteControl (theItemHandle, hilitedHS ) ;
		
		/* run the standard file open dialog */
		theDLOGHandle = (DialogTHndl) GetResource ('DLOG', getDlgID) ;
		SFGetFile (figureCenteredRectTLC (&(**theDLOGHandle).boundsRect),
		 				nil, nil, allTypes, nil, nil, &dummyReply ) ;
		
		/* unhilite the button */
		HiliteControl (theItemHandle, activeHS ) ;
		}
		

/*-------------------------------- doSaveAsItem -------------------------------*/

/* deal with a click of the saveAsItem button */

void	doSaveAsItem () 

		{
		/* local variables */
		Rect				scratch ;
		ControlHandle	theItemHandle ;
		DialogTHndl		theDLOGHandle ;
		SFReply			dummyReply ;

		/* get a handle to the button */
		GetDItem ( ourDialog, saveAsItem, &scratch, &theItemHandle, &scratch) ;
		
		/* hilite the button */
		HiliteControl (theItemHandle, hilitedHS ) ;
		
		/* run the standard file open dialog */
		theDLOGHandle = (DialogTHndl) GetResource ('DLOG', putDlgID) ;
		SFPutFile (figureCenteredRectTLC (&(**theDLOGHandle).boundsRect),
						"\015Save file as:", "\021Current File Name", 
						nil, &dummyReply ) ;

		/* unhilite the button */
		HiliteControl (theItemHandle, activeHS ) ;
		}


/*--------------------------------- doFlipItem --------------------------------*/

/* deal with a click of the flipItem button */

void	doFlipItem () 

		{
		/* local constants */
		#define		numButtons		9
		#define		cyclesDesired	4
		#define		delayTicks		15
		
		/* local variables */
		static	short	flipList [numButtons] =	{ 	hupCoupleItem, 	mouthOpensItem, 
																trashItem, 			melancholyItem, 
																eeekShrinkItem, 	mushroomItem, 
																duplicateItem, 	orwellItem, 
																bumperStickersItem  						} ; 
		Rect				scratch ;
		ControlHandle	theItemHandle ;
		short				cycleCounter ;
		short				index ;
		ControlHandle	tempItemHandle ;
		
		/* get a handle to the button */
		GetDItem ( ourDialog, flipItem, &scratch, &theItemHandle, &scratch) ;
		
		/* hilite the button */
		HiliteControl (theItemHandle, hilitedHS ) ;
		
		/* run several animation cycles on a group of content-changing buttons  */
		for ( cycleCounter = 0; cycleCounter < cyclesDesired; cycleCounter++)
			{
			/* hilite all the buttons in the group  */
			for (index = 0 ; index < numButtons ; index++)
				{
				GetDItem ( ourDialog, flipList[index], &scratch, 
							&tempItemHandle, &scratch) ;
				HiliteControl (tempItemHandle, hilitedHS ) ;
				}
			
			/* wait a while */
			Delay (delayTicks, &scratch) ;
			
			/* unhilite all the buttons in the group */
			for (index = 0 ; index < numButtons ; index++)
				{
				GetDItem ( ourDialog, flipList[index], &scratch, 
							&tempItemHandle, &scratch) ;
				HiliteControl (tempItemHandle, activeHS ) ;
				}

			/* wait a while */
			Delay (delayTicks, &scratch) ;
			}

		/* unhilite the button */
		HiliteControl (theItemHandle, activeHS ) ;

		/* remove local constants */
		#undef		numButtons
		#undef		cyclesDesired
		#undef		delayTicks	
		}
	
	
/*------------------------------- doSomeOffItem -------------------------------*/

/* deal with a click of the someOffItem button  */

void	doSomeOffItem (theOffList, listSize) 
		short		theOffList[] ;
		short		listSize ;
		
		{
		/* local variables */
		short				index ;
		Rect				scratch ;
		ControlHandle	theItemHandle ;
		ControlHandle	tempItemHandle ;
		
		/* get a handle to the button  */
		GetDItem ( ourDialog, someOffItem, &scratch, &theItemHandle, &scratch) ;
		
		/* hilite the button */
		HiliteControl (theItemHandle, hilitedHS ) ;

		/* for each item in the list */
		for (index = 0 ; index < listSize ; index++)
			{
			/* get a handle to the item */
			GetDItem ( ourDialog, theOffList[index], &scratch, 
						&tempItemHandle, &scratch) ;
			
			/* inactivate the item */
			HiliteControl (tempItemHandle, inactiveHS ) ;
			}
		
		/* unhilite the someOffItem button  */
		HiliteControl (theItemHandle, activeHS ) ;
		}


/*-------------------------------- doSomeOnItem -------------------------------*/

/* deal with a hit of the someOnItem button  */

void	doSomeOnItem (theOnList, listSize) 
		short		theOnList[] ;
		short		listSize ;
		
		{
		/* local variables */
		short				index ;
		Rect				scratch ;
		ControlHandle	theItemHandle ;
		ControlHandle	tempItemHandle ;
		
		/* get a handle to the button  */
		GetDItem ( ourDialog, someOnItem, &scratch, &theItemHandle, &scratch) ;
		
		/* hilite the button */
		HiliteControl (theItemHandle, hilitedHS ) ;

		/* for each item in the list */
		for (index = 0 ; index < listSize ; index++)
			{
			/* get a handle to the item */
			GetDItem ( ourDialog, theOnList[index], &scratch, 
						&tempItemHandle, &scratch) ;
			
			/* activate the item */
			HiliteControl (tempItemHandle, activeHS ) ;
			}

		/* unhilite the someOnItem button  */
		HiliteControl (theItemHandle, activeHS ) ;
		}


/*--------------------------------doCopyrightItem -----------------------------*/

/* deal with a hit on the copyrightItem button */

void	doCopyrightItem ()

		{
		/* local variables */
		Rect				scratch ;
		ControlHandle	theItemHandle ;
		DialogPtr		copyrightDlog ;
		Point				tempPoint ;
		
		/* get a handle to the button */
		GetDItem ( ourDialog, copyrightItem, &scratch, &theItemHandle, &scratch) ;
		
		/* hilite the button */
		HiliteControl (theItemHandle, hilitedHS ) ;
		
		/* pull in the copyright notice modal dialog */
		copyrightDlog = GetNewDialog (copyrightDlogID, storeInHeap, inFront) ;

		/* center it on the screen */
		MoveWindow ( copyrightDlog, 
			     (tempPoint = figureCenteredRectTLC (&(*copyrightDlog).portRect)).h,
		 	       tempPoint.v, inFront ) ;
		
		/* show the copyright notice */
		ShowWindow (copyrightDlog ) ;
	
		/* wait until the user clicks the mouse in the dialog */
		ModalDialog (noFilterProcedure, &scratch) ;
		
		/* get rid of the dialog */
		DisposDialog (copyrightDlog) ;

		/* unhilite the button */
		HiliteControl (theItemHandle, activeHS ) ;
		}
		
		
/*--------------------------- figureCenteredRectTLC ---------------------------*/

/* given a rectangle, returns the top left corner  position that will 
	center the rectangle inside screen area that's below the menu bar */

Point	figureCenteredRectTLC (theRect)
		Rect	*theRect ;

		{
		 /* local variable */
		Point	theResult ;
		 
		 /* figure the vertical position */
		 theResult.v = menuBarHeight + ((screenHeight - menuBarHeight) - 
		 								(theRect->bottom - theRect->top) )  /  2 ;
		 	
		 /* figure the horizontal position */
		 theResult.h = ( screenWidth - (theRect->right - theRect->left) )   /   2 ;
		 
		 /* done, so return the point */
		 return (theResult) ;
		}
