/*
	Copyright (C) 1987 Paradigm Systems Inc.  All rights reserved.
*/

#include <stdio.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>
#include <string.h>

#include "loc.h"
#include "externs.h"

#define	F_OPEN		O_RDONLY | O_BINARY
#define	F_CREATE		O_CREAT | O_TRUNC | O_RDWR | O_BINARY


void	open_file_system(input_file)
char	*input_file ;
{
	char	*create_str = "Can't create %s" ;
	char	*open_str = "Can't open %s" ;
	char	errmsg[MAX_LINE] ;
	char	*filename_ext ;

	/*
		This module is responsible for openning or creating all of the
		files used by this utility.
	*/

	/* Perform all the filename processing */
	strcpy(module_name, strupr(input_file)) ;
	strcpy(exe_fname, module_name) ;
	strcat(strcpy(map_fname, exe_fname), ".MAP") ;

	if ((config == FALSE) || (strlen(config_fname) == 0))
		strcat(strcpy(config_fname, exe_fname), ".CFG") ;
	else
		strupr(config_fname) ;
	
	if ((hex_name == FALSE) || (strlen(abs_fname) == 0))
		strcat(strcpy(abs_fname, exe_fname), ".HEX") ;
	else
		strupr(abs_fname) ;

	strcat(strcpy(print_fname, exe_fname), ".LOC") ;
	strcat(exe_fname, ".EXE") ;

	/* Create the temporary file used for segment fixups and location */
	strcpy(tmp_fname, "LOCATE.$$$") ;
	tmp_file = open(tmp_fname, F_CREATE, S_IWRITE) ;
	if (tmp_file == -1)   {
		sprintf(errmsg, create_str, tmp_fname) ;
		perror(errmsg) ;
		exit(1) ;
	}

	/* Create the absolute output file */
	abs_file = open(abs_fname, F_CREATE, S_IWRITE) ;
	if (abs_file == -1)   {
		sprintf(errmsg, create_str, abs_fname) ;
		perror(errmsg) ;
		exit(1) ;
	}

	/* Open the .EXE file */
   exe_file = open(exe_fname, F_OPEN) ;
	if (exe_file == -1)   {
		sprintf(errmsg, open_str, exe_fname) ;
		perror(errmsg) ;
		exit(1) ;
	}

	/* Create the locate map output file */
	print_file = fopen(print_fname, "wt") ;
	if (print_file == NULL)   {
		sprintf(errmsg, open_str, print_fname) ;
		perror(errmsg) ;
		exit(1) ;
	}

	/* Open the configuration file for reading */
	config_file = fopen(config_fname, "rt") ;
	if (config_file == NULL)   {
		sprintf(errmsg, open_str, config_fname) ;
		perror(errmsg) ;
		exit(1) ;
	}

	/* Open the linker map file for reading */
	map_file = fopen(map_fname, "rt") ;
	if (map_file == NULL)   {
		sprintf(errmsg, open_str, map_fname) ;
		perror(errmsg) ;
		exit(1) ;
	}

  	return ;
}


void	 close_file_system()
{
	char	errmsg[MAX_LINE] ;
	char	*close_str = "Unable to close %s" ;
	char	*delete_str = "Unable to delete %s" ;

	/*
		This function is responsible for shutting down the file system
		and cleaning up the temporary files.  All files opened for
		reading are closed and all files open for writing are closed
		(normal exit) and possibly deleted (control-C abort event).
	*/

	/* Close the link map */
	if (fclose(map_file) != 0)   {
		sprintf(errmsg, close_str, map_fname) ;
		perror(errmsg) ;
	}

	/* Close the locate configuration file */
	if (fclose(config_file) != 0)   {
		sprintf(errmsg, close_str, config_fname) ;
		perror(errmsg) ;
	}	

	/* Close the .EXE file */
	if (close(exe_file) == -1)   {
		sprintf(errmsg, close_str, exe_fname) ;
		perror(errmsg) ;
	}

	/* Close the locate map */
	if (fclose(print_file) != 0)   {
		sprintf(errmsg, close_str, print_fname) ;
		perror(errmsg) ;
	}

	/* Close the absolute or hex object module */
	if (close(abs_file) == -1)   {
		sprintf(errmsg, close_str, abs_fname) ;
		perror(errmsg) ;
	}

	if (user_abort == TRUE)   {
		/* Delete the locate map */
		if (remove(print_fname) == -1)   {
			sprintf(errmsg, delete_str, print_fname) ;
			perror(errmsg) ;
		}

		/* Delete the object file */
		if (remove(abs_fname) == -1)   {
			sprintf(errmsg, delete_str, abs_fname) ;
			perror(errmsg) ;
		}
	}

	/* Close and then delete the temporary file */
	if (close(tmp_file) == -1)   {
		sprintf(errmsg, close_str, tmp_fname) ;
		perror(errmsg) ;
	}

	if (remove(tmp_fname) == -1)   {
		sprintf(errmsg, delete_str, tmp_fname) ;
		perror(errmsg) ;
	}

	return ;
}
