;
;  This is a test assembly source file for the
;  generic assembler. It demonstrates the
;  assembler's handling of global and external
;  symbols.
;
;  Note: The assembler only knows the following
;     MOVE  source-address, destination-address
;     JMP   destination-address
;
;     ORG	sets the origin.
;     EVEN	sets the location counter even.
;     END	marks the end of assembly file.
;     EQU	equates a symbol to a value
;     ABS_SHORT forces absolute addresses to short
;     ABS_LONG	forces absolute addresses to long
;     GLB	designates symbol(s) as global
;     EXTERN	designates symbol(s) as external
;
	       glb     start, my_value
	       extern  your_value

start	       equ     1000h
data_start     equ     start+1000h
; Code start.
;	Note: my_value is forward referenced.
;	      your_value is an external reference.

	       org     start

; This instruction will not complete assembly
; until link time.

loop	       move.l  my_value,your_value
	       jmp     loop

; place data at data_start location
my_value       equ   data_start
	       end





Listing 1 - Test.asm source code.
