/* ------------- menu.c ------------- */

#include <stdio.h>
#include "dflat.h"

extern MENU *ActiveMenu;

struct PopDown *FindCmd(int cmd)
{
	MENU *mn = ActiveMenu;
	while (mn->Title != NULL)	{
		struct PopDown *pd = mn->Selections;
		while (pd->SelectionTitle != NULL)	{
			if (pd->ActionId == cmd)
				return pd;
			pd++;
		}
		mn++;
	}
	return NULL;
}

void ActivateCommand(int cmd)
{
	struct PopDown *pd = FindCmd(cmd);
	if (pd != NULL)
		pd->Attrib &= ~INACTIVE;
}

void DeactivateCommand(int cmd)
{
	struct PopDown *pd = FindCmd(cmd);
	if (pd != NULL)
		pd->Attrib |= INACTIVE;
}

int isActive(int cmd)
{
	struct PopDown *pd = FindCmd(cmd);
	if (pd != NULL)
		return !(pd->Attrib & INACTIVE);
	return FALSE;
}

int GetCommandToggle(int cmd)
{
	struct PopDown *pd = FindCmd(cmd);
	if (pd != NULL)
		return pd->Attrib & CHECKED;
	return FALSE;
}

void SetCommandToggle(int cmd)
{
	struct PopDown *pd = FindCmd(cmd);
	if (pd != NULL)
		pd->Attrib |= CHECKED;
}

void ClearCommandToggle(int cmd)
{
	struct PopDown *pd = FindCmd(cmd);
	if (pd != NULL)
		pd->Attrib &= ~CHECKED;
}

void InvertCommandToggle(int cmd)
{
	struct PopDown *pd = FindCmd(cmd);
	if (pd != NULL)
		pd->Attrib ^= CHECKED;
}
