/* ------------ menu.h ------------- */

#ifndef MENU_H
#define MENU_H

struct PopDown {
    char *SelectionTitle;
    int ActionId;
    int Accelerator;
    int Attrib;
};

typedef struct Menu {
    char *Title;
	void (*PrepMenu)(void *, struct Menu *);
    struct PopDown Selections[23];
	int Selection;
} MENU;

#define SEPCHAR "\xc4"
#define DEFMENU(m) MENU m[]= {
#define POPDOWN(ttl,func)      {ttl,func,{
#define SELECTION(stxt,acc,id,attr) 	{stxt,acc,id,attr},
#define SEPARATOR              			{SEPCHAR},
#define ENDPOPDOWN             			{NULL},0}},
#define ENDMENU                {NULL} };

#define INACTIVE	1
#define CHECKED		2
#define TOGGLE		4

int MenuHeight(struct PopDown *);
int MenuWidth(struct PopDown *);

struct PopDown *FindCmd(int);
int isActive(int);
void ActivateCommand(int);
void DeactivateCommand(int);
int GetCommandToggle(int);
void SetCommandToggle(int);
void ClearCommandToggle(int);
void InvertCommandToggle(int);

extern MENU *ActiveMenu;

#endif

