/* ------------- normal.c ------------ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include "dflat.h"

int WindowMoving = FALSE;
int WindowSizing = FALSE;
static int dragcount = -1;
static int diff;
static struct window dwnd = {DUMMY, NULL, NULL, NormalProc,
								{-1,-1,-1,-1}};

struct LinkedList Focus = {NULLWND, NULLWND};
struct LinkedList Built = {NULLWND, NULLWND};
static WINDOW NextWindow;

static void TerminateMoveSize(void);
static void near PaintOverLappers(WINDOW wnd);
static void near dragborder(WINDOW, int, int);
static void near sizeborder(WINDOW, int, int);
static void SaveBorder(RECT);
static void RestoreBorder(RECT);
static void RemoveWindow(WINDOW, int);
static void AddWindow(WINDOW, int);
static int InsideWindow(WINDOW, int, int);

static int px = -1, py = -1;
static int CloseDepth = 0;

int NormalProc(WINDOW wnd, MESSAGE msg, PARAM p1, PARAM p2)
{
	int	mx = (int) p1 - GetLeft(wnd);
	int	my = (int) p2 - GetTop(wnd);
	switch (msg)	{
		case CREATE_WINDOW:
			AddWindow(wnd, TRUE);
			if (!SendMessage(NULLWND, MOUSE_INSTALLED, 0, 0))
				ClearAttribute(wnd, VSCROLLBAR | HSCROLLBAR);
			if (TestAttribute(wnd, SAVESELF) && isVisible(wnd))
				GetVideoBuffer(wnd);
			break;
		case SHOW_WINDOW:
			if (GetParent(wnd) == NULLWND ||
						isVisible(GetParent(wnd)))	{
				WINDOW cwnd = Focus.FirstWindow;
				if (TestAttribute(wnd, SAVESELF) && wnd->videosave == NULL)
					GetVideoBuffer(wnd);
				SetVisible(wnd);
				SendMessage(wnd, PAINT, 0, 0);
				SendMessage(wnd, BORDER, 0, 0);
				while (cwnd != NULLWND)	{
					if (GetParent(cwnd) == wnd)
						SendMessage(cwnd, msg, p1, p2);
					cwnd = NextWindow(cwnd);
				}
			}
			break;
		case HIDE_WINDOW:
			if (isVisible(wnd))	{
				WINDOW cwnd = Focus.LastWindow;
				while (cwnd != NULLWND)	{
					if (GetParent(cwnd) == wnd)
						ClearVisible(cwnd);
					cwnd = PrevWindow(cwnd);
				}
				if (wnd->videosave != NULL)
					RestoreVideoBuffer(wnd);
				else
					PaintOverLappers(wnd);
				ClearVisible(wnd);
			}
			break;
		case INSIDE_WINDOW:
			return InsideWindow(wnd, (int) p1, (int) p2);
		case KEYBOARD:
			if (WindowMoving || WindowSizing)	{
				int x, y;
				x = WindowMoving ? GetLeft(&dwnd) : GetRight(&dwnd);
				y = WindowMoving ? GetTop(&dwnd) : GetBottom(&dwnd);
				switch ((int)p1)	{
					case ESC:
						TerminateMoveSize();
						return TRUE;
					case UP:
						if (y)
							--y;
						break;
					case DN:
						if (y < SCREENHEIGHT-1)
							y++;
						break;
					case FWD:
						if (x < SCREENWIDTH-1)
							x++;
						break;
					case BS:
						if (x)
							--x;
						break;
					case '\r':
						SendMessage(wnd, BUTTON_RELEASED, x, y);
					default:
						return TRUE;
				}
				SendMessage(wnd, MOUSE_CURSOR, x, y);
				SendMessage(wnd, MOUSE_MOVED, x, y);
				break;
			}
			PostMessage(GetParent(wnd), msg, p1, p2);
			break;
		case PAINT:
			if (isVisible(wnd))	
				ClearWindow(wnd, (RECT *)p1, ' ');
			break;
		case BORDER:
			if (isVisible(wnd))
				RepaintBorder(wnd, (RECT *)p1);
			break;
		case COMMAND:
			switch ((int)p1)	{
				case ID_SYSRESTORE:
					SendMessage(wnd, RESTORE, 0, 0);
					break;
				case ID_SYSMOVE:
					SendMessage(wnd, CAPTURE_MOUSE, TRUE, (PARAM) &dwnd);
					SendMessage(wnd, CAPTURE_KEYBOARD, TRUE, (PARAM) &dwnd);
					SendMessage(wnd, MOUSE_CURSOR, GetLeft(wnd), GetTop(wnd));
					WindowMoving = TRUE;
					dragborder(wnd, GetLeft(wnd), GetTop(wnd));
					break;
				case ID_SYSSIZE:
					SendMessage(wnd, CAPTURE_MOUSE, TRUE, (PARAM) &dwnd);
					SendMessage(wnd, CAPTURE_KEYBOARD, TRUE, (PARAM) &dwnd);
					SendMessage(wnd, MOUSE_CURSOR, GetRight(wnd), GetBottom(wnd));
					WindowSizing = TRUE;
					dragborder(wnd, GetLeft(wnd), GetTop(wnd));
					break;
				case ID_SYSMINIMIZE:
					SendMessage(wnd, MINIMIZE, 0, 0);
					break;
				case ID_SYSMAXIMIZE:
					SendMessage(wnd, MAXIMIZE, 0, 0);
					break;
				case ID_SYSCLOSE:
					SendMessage(wnd, CLOSE_WINDOW, 0, 0);
					break;
				default:
					break;
			}
			break;
		case SETFOCUS:
			if (p1 && inFocus != wnd)	{
				SendMessage(inFocus, SETFOCUS, FALSE, 0);
				/* remove from list */
				RemoveWindow(wnd, FALSE);
				/* move window to end of list */
				AddWindow(wnd, FALSE);
				inFocus = wnd;
				SendMessage(wnd, SHOW_WINDOW, 0, 0);
			}
			else if (!p1 && inFocus == wnd)	{
				inFocus = NULL;
				SendMessage(wnd, BORDER, 0, 0);
			}
			break;
		case DOUBLE_CLICK:
			if (!SendMessage(wnd, INSIDE_WINDOW, p1, p2) &&
						CaptureMouse == NULLWND)	{
				PostMessage(GetParent(wnd), msg, p1, p2);
				break;
			}
			if (!WindowSizing && !WindowMoving)
				if (HitControlBox(wnd, mx, my))
					PostMessage(wnd, CLOSE_WINDOW, 0, 0);
			break;
		case LEFT_BUTTON:
			if (WindowSizing || WindowMoving)
				return FALSE;
			if ((!SendMessage(wnd, INSIDE_WINDOW, p1, p2) &&
					CaptureMouse == NULLWND) ||
						HitControlBox(wnd, mx, my))	{
				PostMessage(GetParent(wnd), msg, p1, p2);
				break;
			}
			if (my == 0 && TestAttribute(wnd, TITLEBAR))	{
				/* ---------- hit the title bar -------- */
				if (TestAttribute(wnd, MINMAXBOX))		{
					if (mx == WindowWidth(wnd)-2)	{
						if (wnd->condition == ISRESTORED)	{
							SendMessage(wnd, MAXIMIZE, 0, 0);
							break;
						}
						else	{
							SendMessage(wnd, RESTORE, 0, 0);
							break;
						}
					}
					else if (mx == WindowWidth(wnd)-3)	{
						if (wnd->condition != ISMINIMIZED)	{
							SendMessage(wnd, MINIMIZE, 0, 0);
							break;
						}
					}
				}
			}
			if ((TestAttribute(wnd, MOVEABLE) && my == 0) ||
				TestAttribute(wnd, SIZEABLE) &&
						mx == WindowWidth(wnd)-1 && my == WindowHeight(wnd)-1)	{
				if (wnd->condition == ISMAXIMIZED)
					break;
				if (my != 0 && wnd->condition == ISMINIMIZED)
					break;
				if (dragcount == -1)
					dragcount = 2;
				if (--dragcount == 0)	{
					if (px != (int)p1 || py != (int)p2)	{
						px = py = -1;
						break;
					}
					SendMessage(wnd, CAPTURE_MOUSE, TRUE, (PARAM) &dwnd);
					if (my == 0)	{
						WindowMoving = TRUE;
						px = mx;
						py = my;
						diff = (int) mx;
					}
					else
						WindowSizing = TRUE;
					dragcount = -1;
					dragborder(wnd, GetLeft(wnd), GetTop(wnd));
					return FALSE;
				}
				else {
					px = (int)p1;
					py = (int)p2;
				}
			}
			break;
		case MOUSE_MOVED:
			if (WindowMoving)	{
				int leftmost = 0, topmost = 0,
					bottommost = 23, rightmost = 78;
				int x = (int) p1 - diff;
				int y = (int) p2;
				if (GetParent(wnd) != NULLWND)	{
					WINDOW wnd1 = GetParent(wnd);
					topmost    = GetClientTop(wnd1);
					leftmost   = GetClientLeft(wnd1);
					bottommost = GetClientBottom(wnd1);
					rightmost  = GetClientRight(wnd1)-1;
					if (TestAttribute(wnd1, HASMENUBAR))
						topmost++;
				}
				if (x < leftmost || x > rightmost ||
						y < topmost || y > bottommost)	{
					x = max(x, leftmost);
					x = min(x, rightmost);
					y = max(y, topmost);
					y = min(y, bottommost);
					SendMessage(NULLWND, MOUSE_CURSOR, x+diff, y);
				}
				if (x != px || y != py)	{
					px = x;
					py = y;
					dragborder(wnd, x, y);
				}
				return TRUE;
			}
			if (WindowSizing)	{
				sizeborder(wnd, (int) p1, (int) p2);
				return TRUE;
			}
			break;
		case BUTTON_RELEASED:
			if (WindowMoving || WindowSizing)	{
				if (WindowMoving)
					PostMessage(wnd, MOVE, dwnd.rc.lf, dwnd.rc.tp);
				else
					PostMessage(wnd, SIZE, dwnd.rc.rt, dwnd.rc.bt);
				TerminateMoveSize();
			}
			break;
		case MAXIMIZE:
			if (wnd->condition != ISMAXIMIZED)	{
				RECT rc = {0, 0, SCREENWIDTH-1, SCREENHEIGHT-1};
				RECT holdrc = wnd->RestoredRC;
				if (GetParent(wnd))
					rc = ClientRect(GetParent(wnd));
				wnd->condition = ISMAXIMIZED;
				SendMessage(wnd, HIDE_WINDOW, 0, 0);
				SendMessage(wnd, MOVE, RectLeft(rc), RectTop(rc));
				SendMessage(wnd, SIZE, RectRight(rc), RectBottom(rc));
				SendMessage(wnd, SHOW_WINDOW, 0, 0);
				wnd->RestoredRC = holdrc;
			}
			break;
		case MINIMIZE:
			if (wnd->condition != ISMINIMIZED)	{
				RECT rc = {74, 22, SCREENWIDTH-1, SCREENHEIGHT-1};
				RECT holdrc = wnd->RestoredRC;
				if (GetParent(wnd))	{
					RECT prc = WindowRect(GetParent(wnd));
					RectLeft(rc) = RectRight(prc) - 10;
					RectTop(rc) = RectBottom(prc) - 4;
					RectRight(rc) = RectLeft(rc)+9;
					RectBottom(rc) = RectTop(rc)+2;
				}
				wnd->condition = ISMINIMIZED;
				SendMessage(wnd, HIDE_WINDOW, 0, 0);
				SendMessage(wnd, MOVE, RectLeft(rc), RectTop(rc));
				SendMessage(wnd, SIZE, RectRight(rc), RectBottom(rc));
				SetNextFocus(wnd, FALSE);
				SendMessage(wnd, SHOW_WINDOW, 0, 0);
				wnd->RestoredRC = holdrc;
			}
			break;
		case RESTORE:
			if (wnd->condition != ISRESTORED)	{
				RECT holdrc = wnd->RestoredRC;
				wnd->condition = ISRESTORED;
				SendMessage(wnd, HIDE_WINDOW, 0, 0);
				SendMessage(wnd, MOVE, wnd->RestoredRC.lf,
					wnd->RestoredRC.tp);
				wnd->RestoredRC = holdrc;
				SendMessage(wnd, SIZE, wnd->RestoredRC.rt,
					wnd->RestoredRC.bt);
				SendMessage(wnd, SETFOCUS, TRUE, 0);
				SendMessage(wnd, SHOW_WINDOW, 0, 0);
			}
			break;
		case MOVE:	{
			int xdif = (int) p1 - wnd->rc.lf;
			int ydif = (int) p2 - wnd->rc.tp;
			WINDOW wnd1 = Focus.FirstWindow;

			SendMessage(wnd, HIDE_WINDOW, 0, 0);
			wnd->rc.lf = (int) p1;
			wnd->rc.tp = (int) p2;
			wnd->rc.rt = GetLeft(wnd)+WindowWidth(wnd)-1;
			wnd->rc.bt = GetTop(wnd)+WindowHeight(wnd)-1;
			if (wnd->condition == ISRESTORED)
				wnd->RestoredRC = wnd->rc;
			while (wnd1 != NULLWND)	{
				if (GetParent(wnd1) == wnd)
					SendMessage(wnd1, MOVE,
						wnd1->rc.lf+xdif, wnd1->rc.tp+ydif);
				wnd1 = NextWindow(wnd1);
			}
			SendMessage(wnd, SHOW_WINDOW, 0, 0);
			break;
		}
		case SIZE:
			SendMessage(wnd, HIDE_WINDOW, 0, 0);
			wnd->rc.rt = (int) p1;
			wnd->rc.bt = (int) p2;
			wnd->ht = GetBottom(wnd)-GetTop(wnd)+1;
			wnd->wd = GetRight(wnd)-GetLeft(wnd)+1;
			wnd->RestoredRC = WindowRect(wnd);
			SendMessage(wnd, SHOW_WINDOW, 0, 0);
			break;
		case CLOSE_WINDOW:
			if (isWindow(wnd))	{
			 	int DoneClosing = FALSE;

				/* ----------- hide this window ------------ */
				SendMessage(wnd, HIDE_WINDOW, 0, 0);

				/* ------- close the children of this window ------- */
				CloseDepth++;
				while (!DoneClosing)	{
					WINDOW wnd1 = Focus.LastWindow;
					DoneClosing = TRUE;
					while (wnd1 != NULLWND)	{
						WINDOW prwnd = PrevWindow(wnd1);
						if (GetParent(wnd1) == wnd)	{
							SendMessage(wnd1, CLOSE_WINDOW, 0, 0);
							DoneClosing = FALSE;
							break;
						}
						wnd1 = prwnd;
					}
				}
				--CloseDepth;

				/* ------- remove this window from the
						list of open windows ------------- */

				RemoveWindow(wnd, TRUE);

				/* --- change focus if this window had it --- */
				if (CloseDepth == 0)
					SetNextFocus(wnd, TRUE);
				else if (wnd == inFocus)
					inFocus = NULL;

				/* ----- free memory allocated to this window ----- */
				if (wnd->title != NULL)
					free(wnd->title);
				if (wnd->videosave != NULL)
					free(wnd->videosave);
				free(wnd);
			}
			break;
		default:
			break;
	}
	return TRUE;
}

static void TerminateMoveSize(void)
{
	px = py = -1;
	diff = 0;
	SendMessage(&dwnd, RELEASE_MOUSE, 0, 0);
	SendMessage(&dwnd, RELEASE_KEYBOARD, 0, 0);
	RestoreBorder(dwnd.rc);
	WindowMoving = WindowSizing = FALSE;
}

static void near dragborder(WINDOW wnd, int x, int y)
{
	RestoreBorder(dwnd.rc);
	/* ------- build the dummy window -------- */
	dwnd.rc.lf = x;
	dwnd.rc.tp = y;
	dwnd.rc.rt = dwnd.rc.lf+WindowWidth(wnd)-1;
	dwnd.rc.bt = dwnd.rc.tp+WindowHeight(wnd)-1;
	dwnd.ht = WindowHeight(wnd);
	dwnd.wd = WindowWidth(wnd);
	dwnd.parent = GetParent(wnd);
	dwnd.attrib = VISIBLE | HASBORDER;
	SaveBorder(dwnd.rc);
	DisplayBorder(&dwnd);
}

static void near sizeborder(WINDOW wnd, int rt, int bt)
{
	int leftmost = GetLeft(wnd)+10;
	int topmost = GetTop(wnd)+3;
	int bottommost = SCREENHEIGHT-1;
	int rightmost  = SCREENWIDTH-1;
	if (GetParent(wnd))	{
		bottommost = min(bottommost, GetBottom(GetParent(wnd))-1);
		rightmost  = min(rightmost, GetRight(GetParent(wnd))-1);
	}
	rt = min(rt, rightmost);
	bt = min(bt, bottommost);
	rt = max(rt, leftmost);
	bt = max(bt, topmost);
	SendMessage(NULLWND, MOUSE_CURSOR, rt, bt);

	if (rt != px || bt != py)
		RestoreBorder(dwnd.rc);

	/* ------- change the dummy window -------- */
	dwnd.ht = bt-dwnd.rc.tp+1;
	dwnd.wd = rt-dwnd.rc.lf+1;
	dwnd.rc.rt = rt;
	dwnd.rc.bt = bt;
	if (rt != px || bt != py)	{
		px = rt;
		py = bt;
		SaveBorder(dwnd.rc);
		DisplayBorder(&dwnd);
	}
}

void SetNextFocus(WINDOW wnd, int PassParam)
{
	if (NextWindow(Focus.FirstWindow) == NULLWND)
		inFocus = NULLWND;
	else if (wnd == inFocus)	{
		int loopctr = 0;
		WINDOW wnd1 = wnd;
		while (wnd1 != NULLWND)	{
			if (NextWindow(wnd1) == NULLWND)	{
				wnd1 = Focus.FirstWindow;
				if (loopctr++)	{
					if (PassParam)
						inFocus = NULLWND;
					break;
				}
			}
			else
				wnd1 = NextWindow(wnd1);
			if (wnd1 == wnd)
				continue;
			if (GetParent(wnd1) != GetParent(wnd))
				continue;
			if (SendMessage(wnd1, SETFOCUS, TRUE, PassParam))
				break;
		}
	}
}

static void near PaintOverLap(WINDOW wnd, RECT rc)
{
	RECT src = rc;

	int isLF = RectLeft(rc) == GetLeft(wnd);
	int isBT = RectBottom(rc) == GetBottom(wnd);
	int isRT = RectRight(rc) == GetRight(wnd);
	int isTP = RectTop(rc) == GetTop(wnd);
	int isRSH = TestAttribute(wnd, SHADOW) && RectRight(rc) == GetRight(wnd)+1;
	int isBSH = TestAttribute(wnd, SHADOW) && RectBottom(rc) == GetBottom(wnd)+1;
	int isSH = isRSH | isBSH;

	/* ---- adjust rect to remove border intersections --- */
	if (isLF)
		RectLeft(rc)++;
	if (isRT)
		--RectRight(rc);
	if (isTP)
		RectTop(rc)++;
	if (isBT)
		--RectBottom(rc);
	if (isRSH)
		RectRight(rc) -= 2;
	if (isBSH)
		RectBottom(rc) -= 2;

	/* ---- adjust rectangle to be relative to window's client area ---- */
	RectLeft(rc) -= GetClientLeft(wnd);
	RectTop(rc) -= GetClientTop(wnd);
	RectRight(rc) -= GetClientLeft(wnd);
	RectBottom(rc) -= GetClientTop(wnd);

	SendMessage(wnd, PAINT, (PARAM) &rc, 0);

	/* -- adjust border rectangle to be relative to window's area -- */
	RectLeft(src) -= GetLeft(wnd);
	RectTop(src) -= GetTop(wnd);
	RectRight(src) -= GetLeft(wnd);
	RectBottom(src) -= GetTop(wnd);

	if (isRT || isTP || isLF || isBT || isSH)
		SendMessage(wnd, BORDER, (PARAM) &src, 0);
}

static RECT adjShadow(WINDOW wnd)
{
	RECT rc = wnd->rc;
	if (TestAttribute(wnd, SHADOW))	{
		if (RectRight(rc) < SCREENWIDTH-1)
			RectRight(rc)++;	   	
		if (RectBottom(rc) < SCREENHEIGHT-1)
			RectBottom(rc)++;
	}
	return rc;
}

static void near PaintOverLappers(WINDOW wnd)
{
	if (isVisible(wnd))	{
		WINDOW lownd = Focus.FirstWindow;
		RECT wrc = adjShadow(wnd);
		while (lownd != NULL)	{
			if (lownd != wnd && isVisible(lownd))	{
				RECT rc = adjShadow(lownd);
				rc = subRectangle(rc, wrc);
				if (ValidRect(rc))
					if (GetParent(lownd) != wnd)
						PaintOverLap(lownd, rc);
			}
			lownd = NextWindow(lownd);
		}
	}
}

static int *Bsave = NULL;
static int Bht, Bwd;

static void SaveBorder(RECT rc)
{
	Bht = RectBottom(rc) - RectTop(rc) + 1;
	Bwd = RectRight(rc) - RectLeft(rc) + 1;
	if ((Bsave = realloc(Bsave, (Bht + Bwd) * 4)) != NULL)	{
		RECT lrc = rc;
		int i;
		int *cp;
		RectBottom(lrc) = RectTop(lrc);
		getvideo(lrc, Bsave);
		RectTop(lrc) = RectBottom(lrc) = RectBottom(rc);
		getvideo(lrc, Bsave + Bwd);
		cp = Bsave + Bwd * 2;
		for (i = 1; i < Bht-1; i++)	{
			*cp++ = GetVideoChar(RectLeft(rc),RectTop(rc)+i);
			*cp++ = GetVideoChar(RectRight(rc),RectTop(rc)+i);
		}
	}
}

static void RestoreBorder(RECT rc)
{
	if (Bsave != NULL)	{
		RECT lrc = rc;
		int i;
		int *cp;
		RectBottom(lrc) = RectTop(lrc);
		storevideo(lrc, Bsave);
		RectTop(lrc) = RectBottom(lrc) = RectBottom(rc);
		storevideo(lrc, Bsave + Bwd);
		cp = Bsave + Bwd * 2;
		for (i = 1; i < Bht-1; i++)	{
			PutVideoChar(RectLeft(rc),RectTop(rc)+i, *cp++);
			PutVideoChar(RectRight(rc),RectTop(rc)+i, *cp++);
		}
		free(Bsave);
		Bsave = NULL;
	}
}

static void RemoveWindow(WINDOW wnd, int Both)
{
	if (PrevWindow(wnd) != NULLWND)
		NextWindow(PrevWindow(wnd)) = NextWindow(wnd);
	if (NextWindow(wnd) != NULLWND)
		PrevWindow(NextWindow(wnd)) = PrevWindow(wnd);
	if (wnd == Focus.FirstWindow)
		Focus.FirstWindow = NextWindow(wnd);
	if (wnd == Focus.LastWindow)
		Focus.LastWindow = PrevWindow(wnd);
	if (Both)	{
		if (PrevWindowBuilt(wnd) != NULLWND)
			NextWindowBuilt(PrevWindowBuilt(wnd)) = NextWindowBuilt(wnd);
		if (NextWindowBuilt(wnd) != NULLWND)
			PrevWindowBuilt(NextWindowBuilt(wnd)) = PrevWindowBuilt(wnd);
		if (wnd == Built.FirstWindow)
			Built.FirstWindow = NextWindowBuilt(wnd);
		if (wnd == Built.LastWindow)
			Built.LastWindow = PrevWindowBuilt(wnd);
	}
}

static void AddWindow(WINDOW wnd, int Both)
{
	if (Focus.FirstWindow == NULLWND)
		Focus.FirstWindow = wnd;
	if (Focus.LastWindow != NULLWND)
		NextWindow(Focus.LastWindow) = wnd;
	PrevWindow(wnd) = Focus.LastWindow;
	NextWindow(wnd) = NULLWND;
	Focus.LastWindow = wnd;
	if (Both)	{
		if (Built.FirstWindow == NULLWND)
			Built.FirstWindow = wnd;
		if (Built.LastWindow != NULLWND)
			NextWindowBuilt(Built.LastWindow) = wnd;
		PrevWindowBuilt(wnd) = Built.LastWindow;
		NextWindowBuilt(wnd) = NULLWND;
		Built.LastWindow = wnd;
	}
}

WINDOW GetFirstChild(WINDOW wnd)
{
	NextWindow = Built.FirstWindow;
	while (NextWindow != NULLWND)	{
		if (GetParent(NextWindow) == wnd)
			break;
		NextWindow = NextWindowBuilt(NextWindow);
	}
	return NextWindow;
}

WINDOW GetNextChild(WINDOW wnd)
{
	do	{
		NextWindow = NextWindowBuilt(NextWindow);
		if (GetParent(NextWindow) == wnd)
			break;
	}	while (NextWindow != NULLWND);
	return NextWindow;
}

WINDOW GetLastChild(WINDOW wnd)
{
	NextWindow = Built.LastWindow;
	while (NextWindow != NULLWND)	{
		if (GetParent(NextWindow) == wnd)
			break;
		NextWindow = PrevWindowBuilt(NextWindow);
	}
	return NextWindow;
}

WINDOW GetPrevChild(WINDOW wnd)
{
	do	{
		NextWindow = PrevWindowBuilt(NextWindow);
		if (GetParent(NextWindow) == wnd)
			break;
	}	while (NextWindow != NULLWND);
	return NextWindow;
}

static int InsideWindow(WINDOW wnd, int x, int y)
{
	RECT rc = WindowRect(wnd);
	if (!TestAttribute(wnd, NOCLIP))	{
		WINDOW pwnd = GetParent(wnd);
		while (pwnd != NULL)	{
			rc = subRectangle(rc, ClientRect(pwnd));
			pwnd = GetParent(pwnd);
		}
	}
	return InsideRect(x, y, rc);
}

WINDOW inWindow(int x, int y)
{
	WINDOW wnd = Focus.LastWindow;
	while (wnd != NULLWND)	{
		if (SendMessage(wnd, INSIDE_WINDOW, x, y))
			break;
		wnd = PrevWindow(wnd);
	}
	return wnd;
}

int isWindow(WINDOW wnd)
{
	WINDOW ws = Focus.FirstWindow;
	while (ws != NULLWND)	{
		if (ws == wnd)
			break;
		ws = NextWindow(ws);
	}
	return ws != NULLWND;
}

int WndForeground(WINDOW wnd)
{
	CLASS class = FindClass(GetClass(wnd));
	if (classdefs[class].fg == NULL)
		class = FindClass(GetClass(GetParent(wnd)));
	return *classdefs[class].fg;
}

int WndBackground(WINDOW wnd)
{
	CLASS class = FindClass(GetClass(wnd));
	if (classdefs[class].bg == NULL)
		class = FindClass(GetClass(GetParent(wnd)));
	return *classdefs[class].bg;
}

int FrameForeground(WINDOW wnd)
{
	CLASS class = FindClass(GetClass(wnd));
	if (classdefs[class].fbg != NULL)
		return *classdefs[class].ffg;
	else
		return WndForeground(wnd);
}

int FrameBackground(WINDOW wnd)
{
	CLASS class = FindClass(GetClass(wnd));
	if (classdefs[class].fbg != NULL)
		return *classdefs[class].fbg;
	else
		return WndBackground(wnd);
}

int SelectForeground(WINDOW wnd)
{
	CLASS class = FindClass(GetClass(wnd));
	return *classdefs[class].sfg;
}

int SelectBackground(WINDOW wnd)
{
	int class = FindClass(GetClass(wnd));
	return *classdefs[class].sbg;
}

void SetStandardColor(WINDOW wnd)
{
	foreground = WndForeground(wnd);
	background = WndBackground(wnd);
}

void SetReverseColor(WINDOW wnd)
{
	foreground = SelectForeground(wnd);
	background = SelectBackground(wnd);
}

void SetClassColors(CLASS class)
{
	foreground = *classdefs[class].fg;
	background = *classdefs[class].bg;
}


