/* ------------- sysmenu.c ------------ */

#include <stdio.h>
#include "dflat.h"

extern MENU SystemMenu[];
extern MENU *ActiveMenu;
static MENU *holdmenu;

WINDOW SystemMenuWnd = NULL;

int SystemMenuProc(WINDOW wnd, MESSAGE msg, PARAM p1, PARAM p2)
{
	switch (msg)	{
		case CREATE_WINDOW:
			holdmenu = ActiveMenu;
			ActiveMenu = SystemMenu;
			SystemMenu[0].Selection = 0;
			break;
		case CLOSE_WINDOW:
			ActiveMenu = holdmenu;
			SystemMenuWnd = NULL;
			break;
		default:
			break;
	}
	return DefaultWndProc(wnd, msg, p1, p2);
}

void BuildSystemMenu(WINDOW wnd)
{
	int lf = GetLeft(wnd)+1;
	int tp = GetTop(wnd)+1;
	int ht = MenuHeight(SystemMenu[0].Selections);
	int wd = MenuWidth(SystemMenu[0].Selections);

	if (lf+wd > SCREENWIDTH-1)
		lf = SCREENWIDTH-1 - wd;
	if (tp+ht > 23)
		tp = 23 - ht;

	SystemMenuWnd = CreateWindow(POPDOWNMENU, NULL,
					lf,	tp,	ht,	wd,	NULL, wnd, SystemMenuProc, 0);

	if (wnd->condition == ISRESTORED)
		DeactivateCommand(ID_SYSRESTORE);
	else
		ActivateCommand(ID_SYSRESTORE);

	if (TestAttribute(wnd, MOVEABLE) && wnd->condition != ISMAXIMIZED)
		ActivateCommand(ID_SYSMOVE);
	else
		DeactivateCommand(ID_SYSMOVE);

	if (wnd->condition != ISRESTORED ||	TestAttribute(wnd, SIZEABLE) == FALSE)
		DeactivateCommand(ID_SYSSIZE);
	else
		ActivateCommand(ID_SYSSIZE);

	if (wnd->condition == ISMINIMIZED || TestAttribute(wnd, MINMAXBOX) == FALSE)
		DeactivateCommand(ID_SYSMINIMIZE);
	else
		ActivateCommand(ID_SYSMINIMIZE);

	if (wnd->condition != ISRESTORED ||	TestAttribute(wnd, MINMAXBOX) == FALSE)
		DeactivateCommand(ID_SYSMAXIMIZE);
	else
		ActivateCommand(ID_SYSMAXIMIZE);


	SendMessage(SystemMenuWnd, BUILD_SELECTIONS,
				(PARAM) SystemMenu, 0);
	SendMessage(SystemMenuWnd, SHOW_WINDOW, 0, 0);
}



