
;*--- file: DDJ.FNC-------------------------------------------------
;
; DspHq interface to Numerical Recipes in C
; BittWare Research Systems, Copyright 1990.
;
; souce code file:       ddj.c
; function spec file:    ddj.fnc
; parameter menu file:   ddj.mnu
; dsp files:             dsp_32s.32c, dsp_32c.32c
;
; parameter list:
;    parameter #    type      description
;    -----------    ----      -----------
;    1              hexword   buffer1, DSP board address
;    2              hexword   buffer2, DSP board address
;    3              float     Cosine Amplitude
;    4              float     Cosine DC-Offset
;    5              float     Cosine Frequency
;    6              float     Cosine Sample-Rate
;
; function    input-list      output-list parameter-list
; --------    ----------      ----------- --------------
; gencos_pc   {}              {output1}   {n/a,n/a,amp,dco,freq,samp}
; realft_pc   {}              {output1}   {}
; irealft_pc  {}              {output1}   {}
; logmag_pc   {input1}        {output1}   {}
; gencos_32c  {}              {output1}   {buffer-1,n/a,amp,dco,freq,samp}
; realft_32c  {input1}        {output1}   {buffer-1}
; irealft_32c {input1}        {output1}   {buffer-1}
; logmag_32c  {input1}        {output1}   {buffer-1, buffer-2}
; rfft_32s    {input1}        {output1}   {buffer-1}
; dl_float_32 {input1}        {}          {buffer-1}
; ul_float_32 {}              {output1}   {buffer-1}
;
; Refer to DspHq and Numerical Recipes in C for further details.
;------------------------------------------------------------------*/

author = "BittWare Research Systems"
comments = "Numerical Recipes Examples"

; arrays are all of type single, and length equal to blocksize
; input 1 is optional
; input 2 is optional
; output 1 is required
; output 2 is optional

Input 1 optional
Input 1 data = single
Input 1 Min = BlockSize

Input 2 optional
Input 2 data = single
Input 2 Min = BlockSize

Output 1 required
Output 1 data = single
Output 1 Min = BlockSize

Output 2 optional
Output 2 data = single
Output 2 Min = BlockSize

FuncNames = {
gencos_pc
realft_pc
irealft_pc
logmag_pc
gencos_32c
realft_32c
irealft_32c
logmag_32c
rfft_32s
dl_float_32
ul_float_32
}

