/******* FILE DDJ_32S.S, FOR USE ON DSP BOARD WITH AT&T ASSEMBLER ****/

#include <dspregs.h>

.global i1,o1,o2
.global funcnum, bs, stages
.global endofcode

/***********************************/

/* initialization */
       r5 = 0x0003
       pcw = r5
       ioc  = 0x30CC0

begin:
/* wait until funcnum != 0 */
       r5 = *funcnum
       nop
       if (eq) goto begin
       nop

/***********************************/

/* funcnum is set to function number */

/* func 1 */
     r5 = r5 - 1
     if (eq) goto do_dsp32

/* func 2 */
     r5 = r5 - 1
     if (eq) goto do_ieee32

/* func 3 */
     r5 = r5 - 1
     if (eq) goto rffta

/* func 4 */
     r5 = r5 - 1
     if (eq) goto do_mag
     nop

/* func 5 */
     r5 = r5 - 1
     if (eq) goto do_log10
     nop

/* illegal function number */
     goto finished
     nop

/***********************************/

rffta:
       r2e = *o1
       r1  = *bs
       r3  = *stages
       *fft_b = r2e
       *fft_n = r1e
       *fft_m = r3e

       call _rffta (r14)
       nop
fft_lv: int24    localV
fft_n:  int24    0
fft_m:  int24    0
fft_b:  int24    0
.align 4
       goto finished
       nop

/***********************************/

do_mag:
       r8 = *bs
       r10e = *i1
       r8 = r8 - 2
       r11e = *o1
       nop

       a0 = *r10++                 /* DC value */
       nop
       a2 = *r10++                 /* Nyquist  */
       *r11++ = a0 = a0*a0         /* save DC mag */

magloop:
       a0 = *r10++
       nop
       a1 = *r10++
       a0 = a0*a0
       nop
       a1 = a1*a1
       nop
       nop
       *r11++ = a1 = a0 + a1
       if (r8-->=0) goto magloop
       nop
       *r11++ = a0 = a2*a2         /* save Nyquist mag */
       goto finished
       nop

/***********************************/

do_log10:
       r12e = *i1
       r11e = *o1
       r13  = *bs
       r10e = in
       r9e  = out
       r13  = r13 - 2

logloop:
       *r10 = a3 = *r12++
       call _log10 (r14)
       nop
       int24     localV
       int24     in, out

.align 4
       *r11++ = a3 = *r9
       if (r13-->=0) goto logloop
       nop
       goto finished
       nop

/***********************************/

do_ieee32:
       r1e = *o1
       r2 = *bs
       *o1_ieee32 = r1e
       *bs_ieee32 = r2e

       call _ieee32 (r14)
       nop
            int24       localV
bs_ieee32:  int24       0
o1_ieee32:  int24       0

.align 4
       goto finished
       nop

/***********************************/

do_dsp32:
       r1e = *o1
       r2 = *bs
       *o1_dsp32 = r1e
       *bs_dsp32 = r2e

       call _dsp32 (r14)
       nop
bs_dsp32:  int24       0
o1_dsp32:  int24       0

.align 4
       goto finished
       nop
 
/***********************************/

finished:  /* finished, set funcnum=0 */
       r1=0
       goto begin
       *funcnum=r1

bs:         int 256
stages:     int 8
funcnum:    int 0

.align 4
i1: int24 0x2000
o1: int24 0x2000
o2: int24 0x3000

.align 4
localV:   2*float   0.0
in:       float     0.0
out:      float     0.0
max:      float     0.0
scalefac: float     0.0

#include <_rffta.asm>
#include <_log10.asm>
#include <_ieee32.asm>
#include <_dsp32.asm>

/* MARK END OF CODE */
endofcode: int 0xDEAD, 0xC0DE

