/* ------------- applicat.c ------------- */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <dos.h>
#include "dflat.h"

static WINDOW mnu = NULLWND;
static int ScreenHeight;

extern DBOX TabStops;
extern DBOX DisplayCGA;
extern DBOX DisplayEGA;
extern DBOX DisplayVGA;
extern DBOX Windows;
extern DBOX Log;

static DBOX *Display;

static void CreateMenu(WINDOW);
static void ChooseWindow(WINDOW, int);
static void CloseAll(WINDOW);
static void SelectColors(void);
static void SetScreenHeight(WINDOW, int);
#ifdef INCLUDE_MULTIDOCS
static void SelectTexture(void);
static void SelectBorder(WINDOW);
static void SelectTitle(WINDOW);
#endif
#ifdef INCLUDE_DIALOG_BOXES
static void SelectLines(WINDOW);
#endif

/* ----- compute the Y coordinate for the menu bar ---- */
#define MenuY(wnd)	((TestAttribute(wnd, HASBORDER) && 		\
					!TestAttribute(wnd, TITLEBAR)) ? -1 : 0)

int ApplicationProc(WINDOW wnd, MESSAGE msg, PARAM p1, PARAM p2)
{
	int rtn;

	switch (msg)	{
		case CREATE_WINDOW:
			ScreenHeight = SCREENHEIGHT;
			if (!LoadConfig())
				cfg.ScreenLines = ScreenHeight;

			if (isVGA())
				Display = &DisplayVGA;
			else if (isEGA())
				Display = &DisplayEGA;
			else 
				Display = &DisplayCGA;

			if (cfg.InsertMode)
				SetCommandToggle(MainMenu, ID_INSERT);
			if (cfg.WordWrap)
				SetCommandToggle(MainMenu, ID_WRAP);
#ifdef INCLUDE_DIALOG_BOXES
			if (cfg.Border)
				SetCheckBox(Display, ID_BORDER);
			if (cfg.Title)
				SetCheckBox(Display, ID_TITLE);
			if (cfg.Texture)
				SetCheckBox(Display, ID_TEXTURE);
			if (cfg.mono == 1)
				PushRadioButton(Display, ID_MONO);
			else if (cfg.mono == 2)
				PushRadioButton(Display, ID_REVERSE);
			else
				PushRadioButton(Display, ID_COLOR);
			if (cfg.ScreenLines == 25)
				PushRadioButton(Display, ID_25LINES);
			else if (cfg.ScreenLines == 43)
				PushRadioButton(Display, ID_43LINES);
			else if (cfg.ScreenLines == 50)
				PushRadioButton(Display, ID_50LINES);
#endif
			if (SCREENHEIGHT != cfg.ScreenLines)
				SetScreenHeight(wnd, cfg.ScreenLines);
			SelectColors();
#ifdef INCLUDE_MULTIDOCS
			SelectBorder(wnd);
			SelectTitle(wnd);
#endif
			rtn = BaseWndProc(APPLICATION, wnd, msg, p1, p2);
			if (wnd->extension != NULL)	{
				CreateMenu(wnd);
				SendMessage(wnd, SHOW_WINDOW, 0, 0);
			}
#ifdef INCLUDE_CLOCK
			if (TestAttribute(wnd, TITLEBAR))
				PostMessage(wnd, CAPTURE_CLOCK, 0, 0);
#endif
			return rtn;
		case SIZE:
			BaseWndProc(APPLICATION, wnd, msg, p1, p2);
			SendMessage(mnu, HIDE_WINDOW, 0, 0);
			SendMessage(mnu, SIZE, GetRight(wnd)-1, GetTop(wnd)+1);
			SendMessage(mnu, BUILDMENU, LPARAM(wnd->extension), 0);
			SendMessage(mnu, SHOW_WINDOW, 0, 0);
			return TRUE;
		case KEYBOARD:
#ifdef INCLUDE_SYSTEM_MENUS
			if (WindowSizing || WindowMoving)
				break;
#endif
			PostMessage(mnu, msg, p1, p2);
			return TRUE;
		case SETFOCUS:
			return FALSE;
		case PAINT:
			if (isVisible(wnd))
				ClearWindow(wnd, (RECT *)p1, cfg.Texture ?
					APPLCHAR : ' ');
			return TRUE;
		case COMMAND:
			switch ((int)p1)	{
#ifdef INCLUDE_LOGGING
				case ID_LOG:	{
					MessageLog(wnd);
					if (CheckBoxSetting(&Log, ID_LOGGING))
						SetCommandToggle(MainMenu, ID_LOG);
					else
						ClearCommandToggle(MainMenu, ID_LOG);
					break;
				}
#endif
				case ID_EXIT:
				case ID_SYSCLOSE:
					PostMessage(wnd, CLOSE_WINDOW, 0, 0);
					break;
#ifdef INCLUDE_DIALOG_BOXES
				case ID_DISPLAY:
					if (DialogBox(wnd, Display, NULL))	{
						SendMessage(wnd, HIDE_WINDOW, 0, 0);
						SelectColors();
						SelectLines(wnd);
#ifdef INCLUDE_MULTIDOCS
						SelectBorder(wnd);
						SelectTitle(wnd);
						SelectTexture();
#endif
						SendMessage(mnu, CLOSE_WINDOW, 0, 0);
						ClearAttribute(wnd, HASMENUBAR);
						CreateMenu(wnd);
#ifdef INCLUDE_CLOCK
						if (TestAttribute(wnd, TITLEBAR))
							SendMessage(wnd, CAPTURE_CLOCK, 0, 0);
						else
							SendMessage(NULLWND, RELEASE_CLOCK, 0, 0);
#endif
						PostMessage(wnd, SHOW_WINDOW, 0, 0);
					}
					break;
				case ID_TABS:
					switch (cfg.Tabs)	{
						case 2:
							PushRadioButton(&TabStops, ID_TAB2);
							break;
						case 4:
							PushRadioButton(&TabStops, ID_TAB4);
							break;
						case 6:
							PushRadioButton(&TabStops, ID_TAB6);
							break;
						case 8:
							PushRadioButton(&TabStops, ID_TAB8);
							break;
						default:
							break;
					}
					if (DialogBox(wnd, &TabStops, NULL))	{
						if (RadioButtonSetting(&TabStops, ID_TAB2))
							cfg.Tabs = 2;
						if (RadioButtonSetting(&TabStops, ID_TAB4))
							cfg.Tabs = 4;
						if (RadioButtonSetting(&TabStops, ID_TAB6))
							cfg.Tabs = 6;					
						if (RadioButtonSetting(&TabStops, ID_TAB8))
							cfg.Tabs = 8;
					}
					break;
#endif
				case ID_SAVEOPTIONS:
					SaveConfig();
					break;
				case ID_WINDOW:
					ChooseWindow(wnd, (int)p2-2);
					break;
				case ID_CLOSEALL:
					CloseAll(wnd);
					break;
				case ID_SYSRESTORE:
				case ID_SYSMOVE:
				case ID_SYSSIZE:
				case ID_SYSMINIMIZE:
				case ID_SYSMAXIMIZE:
					return BaseWndProc(APPLICATION, wnd, msg, p1, p2);
				default:
					if (inFocus != mnu)
						PostMessage(inFocus, msg, p1, p2);
					break;
			}
			return TRUE;
#ifdef INCLUDE_SYSTEM_MENUS
		case LEFT_BUTTON:	{
			WINDOW wnd1 = wnd;
			int mx, my;
			if (WindowSizing || WindowMoving)
				return FALSE;
			if (SendMessage(wnd, INSIDE_WINDOW, p1, p2))	{
				if (inFocus && inFocus != mnu)
					if (SendMessage(inFocus, INSIDE_WINDOW, p1, p2))
						wnd1 = inFocus;
				mx = (int) p1 - GetLeft(wnd1);
				my = (int) p2 - GetTop(wnd1);
				if (HitControlBox(wnd1, mx, my))	{
					BuildSystemMenu(wnd1);
					return TRUE;
				}
			}
			break;
		}
#endif
#ifdef INCLUDE_CLOCK
		case CLOCKTICK:	{
			WINDOW wnd1 = Focus.LastWindow;
			int x = GetLeft(wnd)+WindowWidth(wnd)-9;
			while (wnd1 != NULLWND && wnd1 != wnd)	{
				if (SendMessage(wnd1, INSIDE_WINDOW, x, GetTop(wnd)))
					return TRUE;
				if (SendMessage(wnd1, INSIDE_WINDOW, x+5, GetTop(wnd)))
					return TRUE;
				wnd1 = PrevWindow(wnd1);
			}
			foreground = cfg.clr.TitleFG;
			background = cfg.clr.TitleBG;
			wputs(wnd, (char *)p1, WindowWidth(wnd)-9, 0);
			return TRUE;
		}
#endif
		case CLOSE_WINDOW:
			CloseAll(wnd);
#ifdef INCLUDE_CLOCK
			SendMessage(NULLWND, RELEASE_CLOCK, 0, 0);
#endif
			PostMessage(NULLWND, STOP, 0, 0);
			rtn = BaseWndProc(APPLICATION, wnd, msg, p1, p2);
			if (ScreenHeight != SCREENHEIGHT)
				SetScreenHeight(wnd, ScreenHeight);
			return rtn;
		default:
			break;
	}
	return BaseWndProc(APPLICATION, wnd, msg, p1, p2);
}

static void CreateMenu(WINDOW wnd)
{
	mnu = CreateWindow(MENUBAR,
						NULL,
						GetClientLeft(wnd),
						GetClientTop(wnd)+MenuY(wnd),
						1,
						ClientWidth(wnd),
						NULL,
						wnd,
						NULL,
						0);
	AddAttribute(wnd, HASMENUBAR);
	SendMessage(mnu, BUILDMENU, LPARAM(wnd->extension), 0);
	SendMessage(mnu, SETFOCUS, TRUE, TRUE);
}

void PrepEditMenu(void *wnd, struct Menu *mnu)
{
	struct PopDown *pd = mnu->Selections;
	while (pd->SelectionTitle != NULL)	{
		if (*pd->SelectionTitle != LINE)	{
			switch (pd->ActionId)	{
				case ID_CUT:
				case ID_COPY:
				case ID_CLEAR:
				case ID_DELETETEXT:
					if (GetClass(inFocus) == EDITBOX &&
						isMultiLine(inFocus) &&
							BlockMarked(inFocus))
						pd->Attrib &= ~INACTIVE;
					else
						pd->Attrib |= INACTIVE;
					break;
				case ID_PARAGRAPH:
					if (GetClass(inFocus) == EDITBOX &&
							isMultiLine(inFocus))
						pd->Attrib &= ~INACTIVE;
					else
						pd->Attrib |= INACTIVE;
					break;
				case ID_PASTE:
					if (GetClass(inFocus) == EDITBOX &&
							isMultiLine(inFocus) &&
								!TestAttribute(inFocus, READONLY) &&
									Clipboard != NULL)
						pd->Attrib &= ~INACTIVE;
					else
						pd->Attrib |= INACTIVE;
					break;
				case ID_UNDO:
					if (GetClass(inFocus) == EDITBOX &&
							inFocus->DeletedText != NULL)
						pd->Attrib &= ~INACTIVE;
					else
						pd->Attrib |= INACTIVE;
					break;
				default:
					break;
			}
		}
		pd++;
	}
}

static char *Menus[9] = {
	"~1.                      ",
	"~2.                      ",
	"~3.                      ",
	"~4.                      ",
	"~5.                      ",
	"~6.                      ",
	"~7.                      ",
	"~8.                      ",
	"~9.                      "
};

#ifdef INCLUDE_MULTIDOCS

static WINDOW oldFocus;
static int WindowSel;

void PrepWindowMenu(void *wnd, struct Menu *mnu)
{
	struct PopDown *p0 = mnu->Selections;
	struct PopDown *pd = mnu->Selections + 2;
	struct PopDown *ca = mnu->Selections + 13;
	int MenuNo = 0;
	WINDOW wnd1 = Built.FirstWindow;
	mnu->Selection = 0;
	oldFocus = inFocus;
	while (wnd1 != NULLWND && MenuNo < 9)	{
		if (GetClass(wnd1) != MENUBAR && GetParent(wnd1) == wnd)	{
			strncpy(Menus[MenuNo]+4, GetTitle(wnd1), 20);
			pd->SelectionTitle = Menus[MenuNo];
			if (wnd1 == inFocus)	{
				pd->Attrib |= CHECKED;
				mnu->Selection = MenuNo+2;
			}
			else
				pd->Attrib &= ~CHECKED;
			pd++;
			MenuNo++;
		}
		wnd1 = NextWindowBuilt(wnd1);
	}
	if (MenuNo)
		p0->SelectionTitle = "~Close all";
	else
		p0->SelectionTitle = NULL;
	if (wnd1 != NULLWND)	{
		*pd++ = *ca;
		if (mnu->Selection == 0)
			mnu->Selection = 11;
	}
	pd->SelectionTitle = NULL;
}
#endif

#ifdef INCLUDE_DIALOG_BOXES
static int WindowPrep(WINDOW wnd, MESSAGE msg, PARAM p1, PARAM p2)
{
	switch (msg)	{
		case INITIATE_DIALOG:	{
			WINDOW wnd1 = Built.FirstWindow;
			WINDOW cwnd = ControlWindow(&Windows, ID_WINDOWLIST);
			int sel = 0;
			if (cwnd == NULLWND)
				return FALSE;
			while (wnd1 != NULLWND)	{
				if (GetClass(wnd1) != MENUBAR &&
						GetParent(wnd1) == GetParent(wnd) &&
							wnd1 != wnd)	{
					if (wnd1 == oldFocus)
						WindowSel = sel;
					SendMessage(cwnd, ADDTEXT, LPARAM(GetTitle(wnd1)), 0);
					sel++;
				}
				wnd1 = NextWindowBuilt(wnd1);
			}
			SendMessage(cwnd, LB_SETSELECTION, WindowSel, 0);
#ifdef INCLUDE_SCROLLBARS
			AddAttribute(cwnd, VSCROLLBAR);
#endif
			PostMessage(cwnd, SHOW_WINDOW, 0, 0);
			break;
		}
		case COMMAND:
			switch ((int) p1)	{
				case ID_OK:
					WindowSel = SendMessage(ControlWindow(&Windows,
										ID_WINDOWLIST),
											LB_CURRENTSELECTION, 0, 0);
					break;
				case ID_WINDOWLIST:
					if ((int) p2 == LB_CHOOSE)
						SendMessage(wnd, COMMAND, ID_OK, 0);
					break;
				default:
					break;
			}
			break;
		default:
			break;
	}
	return DefaultWndProc(wnd, msg, p1, p2);
}
#endif

static void ChooseWindow(WINDOW wnd, int WindowNo)
{
	WINDOW wnd1 = GetFirstChild(wnd);
	if (WindowNo == 9)	{
#ifdef INCLUDE_DIALOG_BOXES
		if (DialogBox(wnd, &Windows, WindowPrep))
			WindowNo = WindowSel;
		else
#endif
			return;
	}
	while (wnd1 != NULLWND)	{
		if (GetClass(wnd1) != MENUBAR)
			if (WindowNo-- == 0)
				break;
		wnd1 = GetNextChild(wnd);
	}
	SendMessage(wnd1, SETFOCUS, TRUE, 0);
	if (wnd1->condition == ISMINIMIZED)
		SendMessage(wnd1, RESTORE, 0, 0);
}


static void SelectColors(void)
{
#ifdef INCLUDE_DIALOG_BOXES
	if (RadioButtonSetting(Display, ID_MONO))
		cfg.mono = 1;
	else if (RadioButtonSetting(Display, ID_REVERSE))
		cfg.mono = 2;
	else
		cfg.mono = 0;
#endif
	if ((ismono() || video_mode == 2) && cfg.mono == 0)
		cfg.mono = 1;

	if (cfg.mono == 1)
		cfg.clr = bw;
	else if (cfg.mono == 2)
		cfg.clr = reverse;
	else
		cfg.clr = color;
}

#ifdef INCLUDE_DIALOG_BOXES
static void SelectLines(WINDOW wnd)
{
	cfg.ScreenLines = 25;
	if (isEGA() || isVGA())	{
		if (RadioButtonSetting(Display, ID_43LINES))
			cfg.ScreenLines = 43;
		else if (RadioButtonSetting(Display, ID_50LINES))
			cfg.ScreenLines = 50;
	}
	if (SCREENHEIGHT != cfg.ScreenLines)
		SetScreenHeight(wnd, cfg.ScreenLines);
}
#endif

static void SetScreenHeight(WINDOW wnd, int height)
{
	if (isEGA() || isVGA())	{
		int FullScreen = WindowHeight(wnd) == SCREENHEIGHT;
		SendMessage(NULLWND, SAVE_CURSOR, 0, 0);
		switch (height)	{
			case 25:
				Set25();
				break;
			case 43:
				Set43();
				break;
			case 50:
				Set50();
				break;
			default:
				break;
		}
		SendMessage(NULLWND, RESTORE_CURSOR, 0, 0);
		resetmouse();
		SendMessage(NULLWND, SHOW_MOUSE, 0, 0);
		if (FullScreen || SCREENHEIGHT-1 < GetBottom(wnd))
			PostMessage(wnd, SIZE, LPARAM(GetRight(wnd)),
				SCREENHEIGHT-1);
	}
}

#ifdef INCLUDE_MULTIDOCS


static void SelectTexture(void)
{
#ifdef INCLUDE_DIALOG_BOXES
	cfg.Texture = CheckBoxSetting(Display, ID_TEXTURE);
#endif
}

static void SelectBorder(WINDOW wnd)
{
#ifdef INCLUDE_DIALOG_BOXES
	cfg.Border = CheckBoxSetting(Display, ID_BORDER);
#endif
	if (cfg.Border)
		AddAttribute(wnd, HASBORDER);
	else
		ClearAttribute(wnd, HASBORDER);
}

static void SelectTitle(WINDOW wnd)
{
#ifdef INCLUDE_DIALOG_BOXES
	cfg.Title = CheckBoxSetting(Display, ID_TITLE);
#endif
	if (cfg.Title)
		AddAttribute(wnd, TITLEBAR);
	else
		ClearAttribute(wnd, TITLEBAR);
}
#endif

static void CloseAll(WINDOW wnd)
{
	int closing = TRUE;
	ClearAttribute(wnd, VISIBLE);
	while (closing)	{
		WINDOW wnd1 = GetLastChild(wnd);
		closing = FALSE;
		while (wnd1 != NULLWND)	{
			if (GetClass(wnd1) != MENUBAR && wnd1 == inFocus)	{
				SendMessage(wnd1, CLOSE_WINDOW, 0, 0);
				closing = TRUE;
				break;
			}
			wnd1 = GetPrevChild(wnd);
		}
	}
	AddAttribute(wnd, VISIBLE);
	SendMessage(wnd, PAINT, 0, 0);
}
