/* ---------------- classdef.c ---------------- */

#include <stdio.h>
#include "dflat.h"

/*
 * Add class definitions to this table.
 * Add the class symbol to the CLASS list in dflat.h
 */

CLASSDEFS classdefs[] = {
    {   /* ---------- NORMAL Window Class ----------- */
        NORMAL,
        -1,
        &cfg.clr.NormalFG, &cfg.clr.NormalBG,
        NULL, NULL,
        &cfg.clr.NormalFG, &cfg.clr.NormalBG,
        NormalProc
    },
    {   /* ---------- APPLICATION Window Class ----------- */
        APPLICATION,
        NORMAL,
        &cfg.clr.ApplicationFG, &cfg.clr.ApplicationBG,
        NULL, NULL,
        &cfg.clr.ApplicationFG, &cfg.clr.ApplicationBG,
        ApplicationProc,
        VISIBLE | SAVESELF | CONTROLBOX
    },
    {   /* ------------ TEXTBOX Window Class -------------- */
        TEXTBOX,
        NORMAL,
        &cfg.clr.TextBoxFG, &cfg.clr.TextBoxBG,
        &cfg.clr.TextBoxSelFG, &cfg.clr.TextBoxSelBG,
        &cfg.clr.TextBoxFrameFG, &cfg.clr.TextBoxFrameBG,
        TextBoxProc
    },
    {   /* ------------- LISTBOX Window class ------------- */
        LISTBOX,
        TEXTBOX,
        &cfg.clr.ListBoxFG, &cfg.clr.ListBoxBG,
        &cfg.clr.ListBoxSelFG, &cfg.clr.ListBoxSelBG,
        &cfg.clr.ListBoxFrameFG, &cfg.clr.ListBoxFrameBG,
        ListBoxProc
    },
    {   /* ------------- EDITBOX Window Class -------------- */
        EDITBOX,
        TEXTBOX,
        &cfg.clr.EditBoxFG, &cfg.clr.EditBoxBG,
        &cfg.clr.EditBoxSelFG, &cfg.clr.EditBoxSelBG,
        &cfg.clr.EditBoxFrameFG, &cfg.clr.EditBoxFrameBG,
        EditBoxProc
    },
    {   /* ------------- MENUBAR Window Class --------------- */
        MENUBAR,
        NORMAL,
        &cfg.clr.MenuBarFG, &cfg.clr.MenuBarBG,
        &cfg.clr.MenuBarSelFG, &cfg.clr.MenuBarSelBG,
        NULL, NULL,
        MenuBarProc,
        VISIBLE | NOCLIP
    },
    {   /* ------------- POPDOWNMENU Window Class ----------- */
        POPDOWNMENU,
        LISTBOX,
        &cfg.clr.PopDownFG, &cfg.clr.PopDownBG,
        &cfg.clr.PopDownSelFG, &cfg.clr.PopDownSelBG,
        NULL, NULL,
        PopDownProc,
        SAVESELF | NOCLIP | HASBORDER
    },
    {   /* ----------- BUTTON Window Class --------------- */
        BUTTON,
        TEXTBOX,
        &cfg.clr.ButtonFG, &cfg.clr.ButtonBG,
        &cfg.clr.ButtonSelFG, &cfg.clr.ButtonSelBG,
        NULL, NULL,
        ButtonProc,
        SHADOW | NOCLIP
    },
#ifdef INCLUDE_DIALOG_BOXES
    {   /* ------------- DIALOG Window Class -------------- */
        DIALOG,
        NORMAL,
        &cfg.clr.DialogFG, &cfg.clr.DialogBG,
        NULL, NULL,
        &cfg.clr.DialogFG, &cfg.clr.DialogBG,
        DialogProc,
        SHADOW | MOVEABLE | SAVESELF | CONTROLBOX | HASBORDER
    },
#endif
    {   /* ------------ ERRORBOX Window Class ----------- */
        ERRORBOX,
#ifdef INCLUDE_DIALOG_BOXES
        DIALOG,
#else
		TEXTBOX,
#endif
        &cfg.clr.ErrorBoxFG, &cfg.clr.ErrorBoxBG,
        NULL, NULL,
        &cfg.clr.ErrorBoxFG, &cfg.clr.ErrorBoxBG,
#ifdef INCLUDE_DIALOG_BOXES
        DialogProc,
#else
		NULL,
#endif
        SHADOW | HASBORDER
    },
    {   /* --------- MESSAGEBOX Window Class ------------- */
        MESSAGEBOX,
#ifdef INCLUDE_DIALOG_BOXES
        DIALOG,
#else
		TEXTBOX,
#endif
        &cfg.clr.MessageBoxFG, &cfg.clr.MessageBoxBG,
        NULL, NULL,
        &cfg.clr.MessageBoxFG, &cfg.clr.MessageBoxBG,
#ifdef INCLUDE_DIALOG_BOXES
        DialogProc,
#else
		NULL,
#endif
        SHADOW | HASBORDER
    },
    {   /* ----------- HELPBOX Window Class --------------- */
        HELPBOX,
#ifdef INCLUDE_DIALOG_BOXES
        DIALOG,
#else
		TEXTBOX,
#endif
        &cfg.clr.HelpBoxFG, &cfg.clr.HelpBoxBG,
        NULL, NULL,
        &cfg.clr.HelpBoxFG, &cfg.clr.HelpBoxBG,
#ifdef INCLUDE_DIALOG_BOXES
        DialogProc,
#else
		NULL,
#endif
        SHADOW | HASBORDER
    }
#ifdef INCLUDE_SYSTEM_MENUS
	,
    {   /* -------------- DUMMY Window Class ---------------- */
        DUMMY,
        -1,
        &cfg.clr.DummyFG, &cfg.clr.DummyBG,
        NULL, NULL,
        &cfg.clr.DummyFG, &cfg.clr.DummyBG,
        NULL,
        HASBORDER
    }
#endif
};

/* ------- return the offset of a class into the class
                 definition table ------ */
int FindClass(CLASS class)
{
    int i;
    for (i = 0; i < sizeof(classdefs) / sizeof(CLASSDEFS); i++)
        if (class == classdefs[i].class)
            return i;
    return 0;
}



