/* ------------- config.c ------------- */

#include <conio.h>
#include <string.h>
#include "dflat.h"

/* ----- default colors for color video system ----- */
struct colors color = {
    LIGHTGRAY, BLUE,  /* Application   */
    LIGHTGRAY, BLACK, /* Normal        */
    BLACK, CYAN,      /* Button        */
    WHITE, CYAN,      /* ButtonSel     */
    LIGHTGRAY, BLUE,  /* Dialog        */
    YELLOW, RED,      /* ErrorBox      */
    BLACK, LIGHTGRAY, /* MessageBox    */
    BLACK, LIGHTGRAY, /* HelpBox       */
    WHITE, CYAN,      /* InFocusTitle  */
    BLACK, CYAN,      /* Title         */
    GREEN, LIGHTGRAY, /* Dummy         */
    BLACK, LIGHTGRAY, /* TextBox       */
    LIGHTGRAY, BLACK, /* TextBoxSel    */
    LIGHTGRAY, BLUE,  /* TextBoxFrame  */
    BLACK, LIGHTGRAY, /* ListBox       */
    LIGHTGRAY, BLACK, /* ListBoxSel    */
    LIGHTGRAY, BLUE,  /* ListBoxFrame  */
    BLACK, LIGHTGRAY, /* EditBox       */
    LIGHTGRAY, BLACK, /* EditBoxSel    */
    LIGHTGRAY, BLUE,  /* EditBoxFrame  */
    BLACK, LIGHTGRAY, /* MenuBar       */
    BLACK, CYAN,      /* MenuBarSel    */
    BLACK, CYAN,      /* PopDown       */
    BLACK, LIGHTGRAY, /* PopDownSel    */
    DARKGRAY,         /* InactiveSelFG */
    RED               /* ShortCutFG    */
};

/* ----- default colors for mono video system ----- */
struct colors bw = {
    LIGHTGRAY, BLACK, /* Application   */
    LIGHTGRAY, BLACK, /* Normal        */
    BLACK, LIGHTGRAY, /* Button        */
    WHITE, LIGHTGRAY, /* ButtonSel     */
    LIGHTGRAY, BLACK, /* Dialog        */
    LIGHTGRAY, BLACK, /* ErrorBox      */
    LIGHTGRAY, BLACK, /* MessageBox    */
    BLACK, LIGHTGRAY, /* HelpBox       */
    BLACK, LIGHTGRAY, /* InFocusTitle  */
    BLACK, LIGHTGRAY, /* Title         */
    BLACK, LIGHTGRAY, /* Dummy         */
    LIGHTGRAY, BLACK, /* TextBox       */
    BLACK, LIGHTGRAY, /* TextBoxSel    */
    LIGHTGRAY, BLACK, /* TextBoxFrame  */
    LIGHTGRAY, BLACK, /* ListBox       */
    BLACK, LIGHTGRAY, /* ListBoxSel    */
    LIGHTGRAY, BLACK, /* ListBoxFrame  */
    LIGHTGRAY, BLACK, /* EditBox       */
    BLACK, LIGHTGRAY, /* EditBoxSel    */
    LIGHTGRAY, BLACK, /* EditBoxFrame  */
    LIGHTGRAY, BLACK, /* MenuBar       */
    BLACK, LIGHTGRAY, /* MenuBarSel    */
    BLACK, LIGHTGRAY, /* PopDown       */
    LIGHTGRAY, BLACK, /* PopDownSel    */
    DARKGRAY,         /* InactiveSelFG */
    WHITE             /* ShortCutFG    */
};

/* ----- default colors for reverse mono video ----- */
struct colors reverse = {
    BLACK, LIGHTGRAY, /* Application   */
    BLACK, LIGHTGRAY, /* Normal        */
    LIGHTGRAY, BLACK, /* Button        */
    WHITE, LIGHTGRAY, /* ButtonSel     */
    BLACK, LIGHTGRAY, /* Dialog        */
    BLACK, LIGHTGRAY, /* ErrorBox      */
    BLACK, LIGHTGRAY, /* MessageBox    */
    LIGHTGRAY, BLACK, /* HelpBox       */
    LIGHTGRAY, BLACK, /* InFocusTitle  */
    LIGHTGRAY, BLACK, /* Title         */
    LIGHTGRAY, BLACK, /* Dummy         */
    BLACK, LIGHTGRAY, /* TextBox       */
    LIGHTGRAY, BLACK, /* TextBoxSel    */
    BLACK, LIGHTGRAY, /* TextBoxFrame  */
    BLACK, LIGHTGRAY, /* ListBox       */
    LIGHTGRAY, BLACK, /* ListBoxSel    */
    BLACK, LIGHTGRAY, /* ListBoxFrame  */
    BLACK, LIGHTGRAY, /* EditBox       */
    LIGHTGRAY, BLACK, /* EditBoxSel    */
    BLACK, LIGHTGRAY, /* EditBoxFrame  */
    BLACK, LIGHTGRAY, /* MenuBar       */
    LIGHTGRAY, BLACK, /* MenuBarSel    */
    LIGHTGRAY, BLACK, /* PopDown       */
    BLACK, LIGHTGRAY, /* PopDownSel    */
    DARKGRAY,         /* InactiveSelFG */
    WHITE             /* ShortCutFG    */
};

#define SIGNATURE DFLAT_APPLICATION " " VERSION

/* ------ default configuration values ------- */
CONFIG cfg = {
    SIGNATURE,
    0,               /* Color                       */
    TRUE,            /* Editor Insert Mode          */
    4,               /* Editor tab stops            */
    TRUE,            /* Editor word wrap            */
    TRUE,            /* Application Border          */
    TRUE,            /* Application Title           */
    TRUE,            /* Textured application window */
    25               /* Number of screen lines      */
};

/* ------ load a configuration file from disk ------- */
int LoadConfig(void)
{
    FILE *fp = fopen(DFLAT_APPLICATION ".cfg", "rb");
    if (fp != NULL)    {
        fread(cfg.version, sizeof cfg.version+1, 1, fp);
        if (strcmp(cfg.version, SIGNATURE) == 0)    {
            fseek(fp, 0L, SEEK_SET);
            fread(&cfg, sizeof(CONFIG), 1, fp);
        }
        else
            strcpy(cfg.version, SIGNATURE);
        fclose(fp);
    }
    return fp != NULL;
}

/* ------ save a configuration file to disk ------- */
void SaveConfig(void)
{
    FILE *fp = fopen(DFLAT_APPLICATION ".cfg", "wb");
    if (fp != NULL)    {
        cfg.InsertMode = GetCommandToggle(MainMenu, ID_INSERT);
        cfg.WordWrap = GetCommandToggle(MainMenu, ID_WRAP);
        fwrite(&cfg, sizeof(CONFIG), 1, fp);
        fclose(fp);
    }
}
