/* ----------------- dialbox.h ---------------- */

#ifndef DIALOG_H
#define DIALOG_H

#include <stdio.h>

#define MAXCONTROLS 25

#define OFF NULL
#define ON ((void *)-1)

typedef struct  {
    char *title;    /* window title         */
    int x, y;       /* relative coordinates */
    int h, w;       /* size                 */
} DIALOGWINDOW;

typedef struct {
    DIALOGWINDOW dwnd;
    int class; 		/* LISTBOX, BUTTON, etc */
    char *itext;    /* initialized text     */
	char *vtext;	/* variable text		*/
	int command;	/* command code			*/
	void *wnd;		/* window handle		*/
} CTLWINDOW;

typedef struct {
    DIALOGWINDOW dwnd;
    CTLWINDOW ctl[MAXCONTROLS+1];
} DBOX;

#define DIALOGBOX(db) DBOX db={
#define DB_TITLE(ttl,x,y,h,w) {ttl,x,y,h,w},{
#define CONTROL(ty,tx,x,y,h,w,c) {{NULL,x,y,h,w},ty,tx,NULL,c},
#define ENDDB }};

#define Cancel  " Cancel "
#define Ok      "   OK   "
#define Yes     "  Yes   "
#define No      "   No   "

#endif
