/* ----------- classes.h ------------ */
/*
 *         Class definition source file
 *         Make class changes to this source file
 *         Other source files will adapt
 *
 *         You must add entries to the color tables in
 *         CONFIG.C for new classes.
 *
 *        Class Name  Base Class   Processor       Attribute    
 *       ------------  --------- ---------------  -----------
 */
ClassDef(  NORMAL,      -1,      NormalProc,      0 )
ClassDef(  APPLICATION, NORMAL,  ApplicationProc, VISIBLE   |
                                                  SAVESELF  |
                                                  CONTROLBOX )
ClassDef(  TEXTBOX,     NORMAL,  TextBoxProc,     0          )
ClassDef(  LISTBOX,     TEXTBOX, ListBoxProc,     0          )
ClassDef(  EDITBOX,     TEXTBOX, EditBoxProc,     0          )
ClassDef(  MENUBAR,     NORMAL,  MenuBarProc,     NOCLIP     )
ClassDef(  POPDOWNMENU, LISTBOX, PopDownProc,     SAVESELF  |
                                                  NOCLIP    |
                                                  HASBORDER  )
#ifdef INCLUDE_DIALOG_BOXES
ClassDef(  BUTTON,      TEXTBOX, ButtonProc,      SHADOW    |
                                                  NOCLIP     )
ClassDef(  DIALOG,      NORMAL,  DialogProc,      SHADOW    |
                                                  MOVEABLE  |
                                                  CONTROLBOX|
                                                  HASBORDER |
                                                  NOCLIP     )
ClassDef(  ERRORBOX,    DIALOG,  DialogProc,      SHADOW    |
                                                  HASBORDER  )
ClassDef(  MESSAGEBOX,  DIALOG,  DialogProc,      SHADOW    |
                                                  HASBORDER  )
#else
ClassDef(  ERRORBOX,    TEXTBOX, NULL,            SHADOW    |
                                                  HASBORDER  )
ClassDef(  MESSAGEBOX,  TEXTBOX, NULL,            SHADOW    |
                                                  HASBORDER  )
#endif

#ifdef INCLUDE_HELP
ClassDef(  HELPBOX,     DIALOG,  HelpBoxProc,     MOVEABLE  |
                                                  SAVESELF  |
                                                  HASBORDER |
                                                  NOCLIP    |
                                                  CONTROLBOX )
#endif

#ifdef INCLUDE_STATUSBAR
ClassDef(  STATUSBAR,   TEXTBOX, StatusBarProc,   NOCLIP     )
#endif

/*
 *  ========> Add new classes here <========
 */

/* ---------- pseudo classes to create enums, etc. ---------- */
ClassDef(  TITLEBAR,    -1,      NULL,            0          )
ClassDef(  DUMMY,       -1,      NULL,            HASBORDER  )
ClassDef(  TEXT,        -1,      NULL,            0          )
ClassDef(  RADIOBUTTON, -1,      NULL,            0          )
ClassDef(  CHECKBOX,    -1,      NULL,            0          )
