/******************************************************************
 *                                                                *
 * TIMING.C    -  simple non-rigorous benchmark for               *
 *                Phar Lap's 286 | DOS Extender                   *
 *                Intel 386 CodeBuilder                           *
 *                                                                *
 * Compile with:                                                  *
 * ICC timing.c graphics.lib                                      *
 * (386 protected mode)                                           *
 * OR:                                                            *
 * CL -AL -Lp -G2 -Ox timing.c graphp.obj llibpe.lib graphics.lib *
 * (286 protected mode)                                           *
 * OR:                                                            *
 * CL -AL -G2 -Ox timing.c graphics.lib                           *
 * (real mode)                                                    *
 *                                                                *
 ******************************************************************/
#include <stdio.h>
#include <graph.h>
#include <time.h>

#define time_mark time_it(0)
#define time_done time_it(1)

main()
  {
  printf("Timing graphics operations\n");
  time_mark;
  gtest();
  time_done;
  printf("Timing file operations\n");
  time_mark;
  ftest();
  time_done;
  exit(0);
  }

/* Function to mark times */
int time_it(int flag)
  {
  static clock_t sttime;
  unsigned s;
  if (!flag)
    {
    sttime=clock();
    }
  else
    {
    s=(clock()-sttime)/CLK_TCK;
    printf("Elapsed time: %d seconds\n",s);
    }
  return 0;
  }


/* Graphics test -- must have VGA */
int gtest()
  {
  int i,x,y;
  _setvideomode(_MRES256COLOR);
  for (i=1;i<11;i++)
    {
    _setcolor(i);
    for (y=0;y<199;y++)
      for (x=0;x<319;x++)
        _setpixel(x,y);
    }
  _setvideomode(_DEFAULTMODE);
  return 0;
  }


/* File test -- assumes 320K free on current drive */
char filedata[64000];

int ftest()
  {
  FILE *tfile;
  int i,j;
  for (j=0;j<10;j++)
    {
    tfile=fopen("~~TIMING.~@~","w");
    if (!tfile)
      {
      perror("TIMING");
      exit(1);
      }
    for (i=0;i<5;i++)
      fwrite(filedata,sizeof(filedata),1,tfile);
    if (fclose(tfile))
      {
      perror("TIMING");
      }
    unlink("~~TIMING.~@~");
    }
  return 0;
  }


