#-------------------------------------------------------------------
#                   D - F L A T   M A K E F I L E
#-------------------------------------------------------------------

all : test.exe

#-------------------------------------------------------------------
#  Set BORLAND_CPP = 1 to compile with Borland C++ 2.0
#  Set MSC = 1 to compile with Microsoft C
#  Set TURBOC = 1 to compile with Turbo C 2.0
#-------------------------------------------------------------------
BORLAND_CPP = 1
MSC = 0
TURBOC = 0
#------------------------------------------------
# NOTE: Set DRIVE to match where you installed your compiler
#------------------------------------------------
DRIVE = F:\COMPILER
#-------------------------------------------------------------------
#  Delete the TESTING macro to eliminate the D-Flat Log and the Reload
#  Help file selection on the Help menu
#-------------------------------------------------------------------
TESTING = TESTING_DFLAT
#-------------------------------------------------------------------

!if $(MSC) == 1

#------------------------------------------------
#  Microsoft C 6.0
#------------------------------------------------
MODEL = L
#------------------------------------------------
# NOTE: Delete the DEBUG and LINKDEBUG macros to 
# build without debugging information in the .EXE
#------------------------------------------------
DEBUG = /Zi
LINKDEBUG = /CO
COMPILE = cl $(DEBUG) /DMSC /D$(TESTING) /c /W4 /Gs /A$(MODEL)
LINK = link $(LINKDEBUG) /ST:8192
#------------------------------------------------

!endif

!if $(BORLAND_CPP) == 1

#------------------------------------------------
#  Borland C++ 2.0
#------------------------------------------------
MODEL = l
#------------------------------------------------
# NOTE: Delete the DEBUG and LINKDEBUG macros to 
# build without debugging information in the .EXE
#------------------------------------------------
DEBUG = -v
LINKDEBUG = /m /v
#------------------------------------------------
# NOTE: Temporary file space. Change to match
#       your computer. A RAM disk works best.
#------------------------------------------------
HEADERS=e:\temp\tcdef.sym
#------------------------------------------------
# NOTE: use bcc if you do not have extended memory
#------------------------------------------------
COMPILE = bccx $(DEBUG) -D$(TESTING) -DBCPP -c -d -m$(MODEL) -H=$(HEADERS)
LINK= tlink $(LINKDEBUG) $(DRIVE)\borlandc\lib\c0$(MODEL) 
LIBS= $(DRIVE)\borlandc\lib\c$(MODEL)
#------------------------------------------------
!endif

!if $(TURBOC) == 1

#------------------------------------------------
#  Turbo C 2.0
#------------------------------------------------
MODEL = l
#------------------------------------------------
# NOTE: Delete the DEBUG and LINKDEBUG macros to 
# build without debugging information in the .EXE
#------------------------------------------------
DEBUG = -v
LINKDEBUG = /m /v
COMPILE = tcc $(DEBUG) -DTURBOC -D$(TESTING) -c -d -m$(MODEL)
LINK= tlink $(LINKDEBUG) $(DRIVE)\tc\lib\c0$(MODEL) 
LIBS= $(DRIVE)\tc\lib\c$(MODEL)
#------------------------------------------------

!endif

.c.obj:
    $(COMPILE) $*.c

test.exe : test.obj window.obj video.obj message.obj             \
              mouse.obj console.obj textbox.obj listbox.obj            \
              normal.obj config.obj menu.obj menubar.obj popdown.obj   \
              rect.obj applicat.obj keys.obj sysmenu.obj menus.obj     \
              editbox.obj dialogs.obj dialbox.obj button.obj           \
              fileopen.obj msgbox.obj helpbox.obj log.obj lists.obj    \
              statbar.obj decomp.obj htree.obj combobox.obj            \
              pictbox.obj calendar.obj barchart.obj clipbord.obj       \
              search.obj
!if $(MSC)
    $(LINK) @test.lnk,$*,$*;
!else
    $(LINK) @test.lnk,$*.exe,$*,$(LIBS)
!endif

huffc.exe : huffc.obj htree.obj
!if $(MSC)
    $(LINK) huffc htree,$*,$*;
!else
    $(LINK) huffc htree,$*.exe,$*,$(LIBS)
!endif

