	.MODEL	SMALL

	INCLUDE	equates.inc
	INCLUDE	instance.inc
	INCLUDE	messages.inc
	INCLUDE	objects.inc

IF1
	INCLUDE	macros.mac
	INCLUDE	objects.mac
	INCLUDE	strings.mac
ENDIF

	EXTRN	Buffer:WORD

	.CODE

COMMENT	%
==============================================================================
Gets the current system time.

Passes:	ah - Hours
	al - Minutes
	dl - Seconds

=============================================================================%
getTime	PROC	NEAR
	mov		ah,2Ch			;Pass get time function code
	int		DosInt			;MS-DOS interrupt
	mov		ax,cx			;Pass hours/mins

	lea		di,Buffer+BufSize-10	;Get end of text buffer addr

	mov		cx,ax			;Get hours/mins
	mov		al,ch			;Get BCD hours
	call		convertDigits		;Convert hours
	mov		Wptr[di],ax		;Save ASCII hours
	mov		Bptr[di+2],':'		;Save colon

	mov		al,cl			;Get BCD minutes
	call		convertDigits		;Convert minutes
	mov		Wptr[di+3],ax		;Save ASCII minutes
	mov		Bptr[di+5],':'		;Save colon

	mov		al,dh			;Get BCD seconds
	call		convertDigits		;Convert seconds
	mov		Wptr[di+6],ax		;Save ASCII seconds
	mov		Wptr[di+8],00h		;Mark end of string
	ret
getTime	ENDP



	PUBLIC	convertDigits
COMMENT	%
==============================================================================
Converts the current system time into ASCII.

Passed:	al - BCD Time component

Passes:	ax - ASCII time component

=============================================================================%
convertDigits	PROC	NEAR
	push		cx
	xor		ah,ah			;Zero high reg
	moreThan	al,9,cvd1		;If > 9 - Divide by 10
	mov		cl,8			;Else get #bits to shift
	shl		ax,cl			;Shift left
	jmp		cvd2

cvd1:	mov		cl,10d			;Num to divide by
	div		cl			;al=quotient, ah=remainder

cvd2:	add		al,30h			;Convert lo-order to ASCII
	add		ah,30h			;Convert hi-order to ASCII
	pop		cx
	ret
convertDigits	ENDP



COMMENT	%
==============================================================================
Displays the ASCII representation of the current system time.

=============================================================================%
disTime	PROC	NEAR
	getInst		dh,Row1,Clock		;Get clock display row
	getInst		dl,Col1			;Get clock display column
	getInst		bl,Color		;Get color

	lea		si,Buffer+BufSize-10	;Get text addr
	disStrg		dh,dl,bl,si		;Display time
	ret
disTime	ENDP



	.DATA

defMsg	Clock,\
	Refresh,\
	<getTime,,disTime>

defObj	Clock,\
	<>,\
	<Row1,1,0,\
	Col1,1,70,\
	Row2,1,Nil,\
	Col2,1,Nil,\
	Color,1,31h>,\
	<Refresh>



	END
