	.MODEL	SMALL
	.STACK	40h

	INCLUDE	equates.inc
	INCLUDE	instance.inc
	INCLUDE	messages.inc
	INCLUDE	objects.inc

	ArgOffset	EQU	80h		;Offset in PSP of program args
	ErrMsgLength	EQU	34		;Length of error messages
	MaxErrCode	EQU	89		;Max value for error code + 1
	ReservedErrCode	EQU	13		;A Reserved error code
	UR		EQU	5		;Upper row
	LC		EQU	5		;Left column
	LR		EQU	11		;Lower row
	RC		EQU	46		;Right column
	MR		EQU	LR-(RowOffset+1)	;Mouse row
	MC		EQU	LC+ColOffset+1	;Mouse column

IF1
	INCLUDE	macros.mac
	INCLUDE	objects.mac
ENDIF

	EXTRN	initObject:NEAR
	EXTRN	readEvent:NEAR
	EXTRN	sendMsg:NEAR

	EXTRN	Dialog:WORD
	EXTRN	Dispatch:WORD
	EXTRN	DlgMenu:WORD
	EXTRN	Hardware:WORD
	EXTRN	Master:WORD
	EXTRN	Mouse:WORD
	EXTRN	Self:WORD
	EXTRN	Video:WORD

	.CODE

COMMENT	%
==============================================================================
The main procedure that gets everything started.

=============================================================================%
main	PROC	NEAR
	mov		si,ArgOffset		;Get argument offset
	mov		bx,Wptr[si+1]		;Get error code
	dec		bx			;Zero based
	mov		al,Bptr[si+3]		;Get mouse flag

	pushData	<ax,bx>
	setSegs		@data			;Make ds,es point to data
	call		initObjs		;Initialize objects
	send		Video,Init		;Initialize video
	popData		<bx,ax>

	setInst		?Mouse,al,Mouse		;Set mouse flag
	send		ErrDlg,Refresh,bx
	send		ErrDlg,Read
main	ENDP



COMMENT %
=============================================================================
Initializes objects so that they are usable in the OOP scheme.

=============================================================================%
initObjs	PROC	NEAR
	initObj		ErrDlg
	initObj		DlgMenu
	initObj		Dispatch
	initObj		Video
	initObj		Hardware
	ret
initObjs	ENDP



COMMENT	%
==============================================================================
Returns control to the operating ErrDlg.

=============================================================================%
getErrMsgTxt	PROC	NEAR
	getStackArgs	ax			;Get error code
	mov		cl,ErrMsgLength+1	;Get length
	mul		cl			;Calc text offset
	lea		bx,ErrMsgTbl		;Get addr of msg tbl
	add		bx,ax			;Point to error msg text
	setInst		TxtPtr,bx,Self		;Save ptr
	ret
getErrMsgTxt	ENDP



	PUBLIC	clrNextContext
COMMENT	%
==============================================================================
Resets the top level dispatcher object.

=============================================================================%
clrNextContext	PROC	NEAR
	lea		ax,ErrDlg		;Get top-level object
	setInst		NextContext,ax,Dispatch	;Set it as next context
	ret
clrNextContext	ENDP



COMMENT	%
==============================================================================
Returns control to the operating system.

=============================================================================%
returnToOS	PROC	NEAR
	exit					;Return to DOS
returnToOS	ENDP



COMMENT	%
==============================================================================
Selects the menu item based on mouse location.

=============================================================================%
clickOnItem	PROC	NEAR
	push		Self
	send		DlgMenu,Flash,0		;Flash 1st menu item
	pop		Self
	send		Self,Select		;Select menu item
	ret
clickOnItem	ENDP



	.DATA

defMenu		ErrDlg,<" Continue ">

defMenuTbl	ErrDlg,\
		<ErrDlg,Clear,ErrDlg,Reset>

defSlaveTbl	ErrDlg,<DlgMenu>

defDispTbl	ErrDlg,\
	<13,28,3,0,0,0,0,ErrDlg,Select>,\
	<0,Nil,1,MR,MC,MR+2,MC+12,ErrDlg,Click>,\
	<Nil,Nil,Nil,0,0,24,79,Hardware,Refresh>

defMsg	ErrDlg,\
	Refresh,\
	<getErrMsgTxt,,>

defMsg	ErrDlg,\
	Read,\
	<,,readEvent>

defMsg	ErrDlg,\
	Clear,\
	<,,clrNextContext>

defMsg	ErrDlg,\
	Click,\
	<,,clickOnItem>

defMsg	ErrDlg,\
	Reset,\
	<,,returnToOS>

defObj	ErrDlg,\
	<Dialog,Master>,\
	<Row1,1,UR,\
	Col1,1,LC,\
	Row2,1,LR,\
	Col2,1,RC,\
	Color,1,43h,\
	Unused,1,Nil,\
	TxtPtr,2,Nil,\
	InxPtr,2,0,\
	MasterObj,2,Nil,\
	DispTbl,2,ErrDlgDispTbl,\
	MenuPtr,2,ErrDlgMenu,\
	MenuTbl,2,ErrDlgMenuTbl,\
	SlaveTbl,2,ErrDlgSlaveTbl>,\
	<Refresh,Read,Select,Clear,Reset,Hilite,Click>

ErrMsgTbl	LABEL	WORD
		DB	"Invalid function number         01",0
		DB	"File not found                  02",0
		DB	"Path not found                  03",0
		DB	"Too many open files             04",0
		DB	"Access denied                   05",0
		DB	"Invalid handle                  06",0
		DB	"Memory control blocks destroyed 07",0
		DB	"Insufficient memory             08",0
		DB	"Invalid memory block address    09",0
		DB	"Invalid environment             10",0
		DB	"Invalid format                  11",0
		DB	"Invalid access code             12",0
		DB	"Invalid data                    13",0
		DB	"File function error             14",0
		DB	"Invalid disk drive              15",0
		DB	"Can't remove current directory  16",0
		DB	"Not same device                 17",0
		DB	"No more files                   18",0
		DB	"Disk write-protected            19",0
		DB	"Unknown disk unit               20",0
		DB	"Drive not ready                 21",0
		DB	"Unknown command                 22",0
		DB	"Data error (CRC)                23",0
		DB	"Bad request structure length    24",0
		DB	"Seek error                      25",0
		DB	"Unknown media type              26",0
		DB	"Sector not found                27",0
		DB	"Printer out of paper            28",0
		DB	"Write fault                     29",0
		DB	"Read fault                      30",0
		DB	"General failure                 31",0
		DB	"Sharing violation               32",0
		DB	"Lock violation                  33",0
		DB	"Invalid disk change             34",0
		DB	"FCB unavailable                 35",0
		DB	"Sharing buffer overflow         36",0
		DB	"File function error             37",0
		DB	"File function error             38",0
		DB	"File function error             39",0
		DB	"File function error             40",0
		DB	"File function error             41",0
		DB	"File function error             42",0
		DB	"File function error             43",0
		DB	"File function error             44",0
		DB	"File function error             45",0
		DB	"File function error             46",0
		DB	"File function error             47",0
		DB	"File function error             48",0
		DB	"File function error             49",0
		DB	"Network request not supported   50",0
		DB	"Remote computer not listening   51",0
		DB	"Duplicate name on network       52",0
		DB	"Network name not found          53",0
		DB	"Network busy                    54",0
		DB	"Network device no longer exists 55",0
		DB	"BIOS command limit exceeded     56",0
		DB	"Network adapter hardware error  57",0
		DB	"Incorrect response from network 58",0
		DB	"Unexpected network error        59",0
		DB	"Incompatible remote adapter     60",0
		DB	"Print queue full                61",0
		DB	"Print queue not full            62",0
		DB	"Print file deleted              63",0
		DB	"Network name deleted            64",0
		DB	"Access denied                   65",0
		DB	"Network device type incorrect   66",0
		DB	"Network name not found          67",0
		DB	"Network name limit exceeded     68",0
		DB	"BIOS session limit exceeded     69",0
		DB	"Temporarily paused              70",0
		DB	"Network request not accepted    71",0
		DB	"Print or disk redirection paused72",0
		DB	"File function error             73",0
		DB	"File function error             74",0
		DB	"File function error             75",0
		DB	"File function error             76",0
		DB	"File function error             77",0
		DB	"File function error             78",0
		DB	"File function error             79",0
		DB	"File already exists             80",0
		DB	"File function error             81",0
		DB	"Cannot make directory entry     82",0
		DB	"Failure on interrupt 24h        83",0
		DB	"Too many redirections           84",0
		DB	"Duplicate redirection           85",0
		DB	"Invalid password                86",0
		DB	"Invalid parameter               87",0
		DB	"Network device fault            88",0



	END	main
