	.MODEL	SMALL

	INCLUDE	equates.inc
	INCLUDE	instance.inc
	INCLUDE	messages.inc
	INCLUDE	objects.inc

	UR		EQU	1			;Upper row
	LC		EQU	70			;Left column
	LR		EQU	21			;Lower row
	RC		EQU	79			;Right column
	NumOfItems	EQU	10			;Number of menu items
	MenuColor	EQU	17h			;Menu color
	WinColor	EQU	31h			;Window color

IF1
	INCLUDE	macros.mac
	INCLUDE	objects.mac
ENDIF

	EXTRN	prtString:NEAR
	EXTRN	sendMsg:NEAR

	EXTRN	Hardware:WORD
	EXTRN	Menu:WORD
	EXTRN	Mouse:WORD
	EXTRN	Self:WORD
	EXTRN	System:WORD
	EXTRN	Window:WORD

	.CODE

IF Dbug
	PUBLIC	disHelpMenu
ENDIF
COMMENT	%
==============================================================================
Displays the help menu.

=============================================================================%
disHelpMenu	PROC	NEAR
	getInst		dh,Row1,Self		;Get upper row
	inc		dh			;Increment it
	getInst		dl,Col1			;Get left column
	getInst		bl,Color		;Get color
	getInst		di,MenuPtr		;Ptr to menu text
	mov		cx,NumOfItems		;Set loop counter

dhm1:	mov		Wptr[di],dx		;Save row/column
	mov		si,Wptr[di+2]		;Point to menu item text
	call		prtString		;Display it
	add		dh,2			;Increment row by two
	add		di,4			;Point to next menu item
	loop		dhm1			;Loop if more items
	ret
disHelpMenu	ENDP



IF Dbug
	PUBLIC	resetColor
ENDIF
COMMENT	%
==============================================================================
Resets the colors of the help menu.

=============================================================================%
resetColor	PROC	NEAR
	setInst		Color,MenuColor,Self,1	;Reset color
	ret
resetColor	ENDP



IF Dbug
	PUBLIC	setColor
ENDIF
COMMENT	%
==============================================================================
Sets the colors of the help menu.

=============================================================================%
setColor	PROC	NEAR
	setInst		Color,WinColor,Self,1	;Set window color
	ret
setColor	ENDP



IF Dbug
	PUBLIC	clickOnButton
ENDIF
COMMENT	%
==============================================================================
Selects the menu item based on mouse location.

=============================================================================%
clickOnButton	PROC	NEAR
	getInst		bl,Row1,Mouse		;Get mouse row
	getInst		si,MenuPtr,Self		;Get menu ptr
	xor		ax,ax			;Initialize item counter
						 
cob1:	mov		dl,Bptr[si+1]		;Get row for current item
	mov		dh,Bptr[si+1+MenuEntrySize]		;Get row for next item
	lessThan	bl,dl,cob4		;Exit if before item
	lessThan	bl,dh,cob3		;Done if before next item
	inc		ax			;Increment item count
	add		si,MenuEntrySize	;Point to next entry
	identity	Wptr[si],cob1,cob4	;Loop if more items
						;Else exit
 
cob3:	mov		cl,MenuEntrySize	;Get entry size
	mul		cl			;Calc entry offset
	send		Self,Flash,ax		;Flash hilite for menu item
	send		Self,DeHilite,ax	;Turn menu item off
	send		Self,Select		;Select menu item

cob4:	ret
clickOnButton	ENDP



	.DATA

defMenu	Help,\
	<" F1  Help ",\
	 " F2       ",\
	 " F3       ",\
	 " F4       ",\
	 " F5       ",\
	 " F6       ",\
	 " F7       ",\
	 " F8       ",\
	 " F9       ",\
	 " F10 Quit ">

defMenuTbl	Help,\
	<Hardware,Refresh>,\
	<Hardware,Refresh>,\
	<Hardware,Refresh>,\
	<Hardware,Refresh>,\
	<Hardware,Refresh>,\
	<Hardware,Refresh>,\
	<Hardware,Refresh>,\
	<Hardware,Refresh>,\
	<Hardware,Refresh>,\
	<System,Refresh,System,Read>

defMsg	Help,\
	Refresh,\
	<setColor,resetColor,disHelpMenu>

defMsg	Help,\
	Click,\
	<,,clickOnButton>

defObj	Help,\
	<Window,Menu>,\
	<Row1,1,UR,\
	Col1,1,LC,\
	Row2,1,LR,\
	Col2,1,RC,\
	Color,1,Nil,\
	UnUsed,1,Nil,\
	TxtPtr,2,Nil,\
	InxPtr,2,0,\
	MasterObj,2,Nil,\
	DispTbl,2,Nil,\
	MenuPtr,2,HelpMenu,\
	MenuTbl,2,HelpMenuTbl>,\
	<Refresh,Select,Flash,DeHilite,Click>



	END
