;---------------------------------------------------------------    
;Logequ.inc - equates for device driver logger                 |
;--------------------------------------------------------------|
;
MAX_ERR         EQU     15              ;errors returned by drivers 0-15
ERR_BIT         EQU     8000h
DONE_BIT        EQU     0100h
ERR_UNKNOWN     EQU     ERR_BIT OR DONE_BIT OR 03h  ;unknown command
ERR_GENFAIL     EQU     ERR_BIT OR DONE_BIT OR 0ch  ;general failure
CMD_INIT        EQU     0
CMD_BUILD_BPB   EQU     2
LPT1            EQU     0 
NULL            EQU     0
TRUE            EQU     -1
FALSE           EQU     NOT TRUE
MAX_CMDS        EQU     24              ;maximum commands supported
OK_STATUS       EQU     0100h           ;done and success
USER_INT        EQU     60h             ;one of the user interrupts
INT_OP_CODE     EQU     0cdh            ;opcode for int instruction
EXPECT_STRAT    EQU     1               ;expecting strategy routine 
EXPECT_INT      EQU     2               ;expecting interrupt routine 
EXPECT_USE_RET  EQU     3               ;expecting int from caller
DOS_PRINT_STRING EQU    9               
CR              EQU     13
LF              EQU     10
TAB             EQU     9
MAX_CMD_LINE    EQU     128             ;maximum command line size
NUM_PATCH_BYTES EQU     4               ;4 digits for 2 bytes of code
SWITCH_CHAR     EQU     '/'
PATCH_SWITCH    EQU     'P'
INPUT           EQU     1
OUTPUT          EQU     2
INPUT_OUTPUT    EQU     3
OUT_NULL        EQU     0               ;log to nothing
OUT_PRINTER     EQU     1               ;log to printer
OUT_SCREEN      EQU     2               ;log to screen  
OUT_MEM         EQU     3               ;log to memory 
TABLE_TERM      EQU     0ffh

;------end of logequ.inc










            
