;---------------------------------------------------------------    
;Logmain - main module for device driver monitor               |
;--------------------------------------------------------------|
;Copyright 1990, 1992 ASMicro Co.                              |
;--------------------------------------------------------------|
;                                                              |
; 4/15/90                      Rick Knoblaugh                  |
;--------------------------------------------------------------|
;include files                                                 |
;---------------------------------------------------------------    
                include logequ.inc
                include logstruc.inc

code            segment public  'CODE'
                assume cs:code, ds:code, es:code
;--------------------------------------------------------------
;EXTERNALS                                                    |
;--------------------------------------------------------------
                extrn   drv_init:near
                extrn   drv_open:near  
                extrn   drv_close:near 
                extrn   drv_ioctl_in:near
                extrn   drv_ioctl_out:near
                extrn   req_header:dword
                extrn   drv_non_supt:near
                extrn   old_stack_ptr:word  
                extrn   old_stack_seg:word  
                extrn   logr_stack:word
                extrn   logr_sp:word

;--------------------------------------------------------------
                org     0

header          dd      -1       ;ptr to next device 
                dw      0c000h   ;char device, supports IOCTL control strings
                dw      strat_routine
                dw      int_routine
                db      'DRVMONER'      ;8 char device name

;--------------------------------------------------------------
;Call table for processing device driver requests             |
;                                                             |
;Since the device driver logger is only in the form of a      |
;device driver to allow capturing of "config.sys" time calls  |
;(such as initialization) to other device drivers, this       |
;driver itself supports very few requests.                    |
;--------------------------------------------------------------

cmd_table       label   word
                dw      drv_init        ;initialization routine
                dw      drv_non_supt    ;media check              
                dw      drv_non_supt    ;get BPB                  
                dw      drv_ioctl_in    ;IOCTL input              
                dw      drv_non_supt    ;input                    
                dw      drv_non_supt    ;nondestructive input     
                dw      drv_non_supt    ;input status             
                dw      drv_non_supt    ;input flush              
                dw      drv_non_supt    ;output (write)           
                dw      drv_non_supt    ;output (write with verify)
                dw      drv_non_supt    ;output status            
                dw      drv_non_supt    ;output flush             
                dw      drv_ioctl_out   ;IOCTL output             
                dw      drv_open        ;device open              
                dw      drv_close       ;device close             
                dw      drv_non_supt    ;removable media          
                dw      drv_non_supt    ;reserved                 
                dw      drv_non_supt    ;reserved                 
                dw      drv_non_supt    ;reserved                 
                dw      drv_non_supt    ;generic IOCTL            
                dw      drv_non_supt    ;reserved                 
                dw      drv_non_supt    ;reserved                 
                dw      drv_non_supt    ;reserved                 
                dw      drv_non_supt    ;get logical device       
                dw      drv_non_supt    ;set logical device       

;--------------------------------------------------------------

strat_routine   proc    far 
                mov     word ptr cs:req_header, bx      ;save ptr to cmd block
                mov     word ptr cs:req_header + 2, es          
                ret
strat_routine   endp        


int_routine     proc    far
                cli
                mov     cs:old_stack_ptr, sp
                mov     cs:old_stack_seg, ss
                mov     sp, cs
                mov     ss, sp
                mov     sp, offset cs:logr_sp  
                sti


                cld
                push    ds  
                push    es  
                push    ax
                push    bx
                push    cx
                push    dx
                push    di
                push    si

                lds     di, cs:req_header       ;get ptr to cmd block
                sub     bh, bh
                mov     bl, [di].req_hdr_cmd    ;get command code
                cmp     bl, MAX_CMDS            ;compare with maximum commands
                jbe     int_r100                ;if within legal range, continue

                mov     ax, ERR_UNKNOWN         ;get unknown command status
                jmp     short int_r300          ;go return it

int_r100:
                shl     bx, 1                   ;index into table 
                push    cs
                pop     ds                      ;get ds = cs

                call    word ptr [bx + cmd_table] ;call processing routine


int_r300:
                lds     di, cs:req_header       ;get ptr to cmd block
                mov     [di].req_hdr_status, ax ;return status   

                pop     si
                pop     di
                pop     dx
                pop     cx
                pop     bx
                pop     ax
                pop     es
                pop     ds

                cli
                mov     sp, cs:old_stack_ptr
                mov     ss, cs:old_stack_seg
                sti
                ret
int_routine     endp       

code            ends
                end
