;---------------------------------------------------------------    
;Stlogdat.inc - data for standard device drivers               |
;--------------------------------------------------------------|
;
cmd0_desc       db      'Init', NULL
cmd1_desc       db      'Media Check', NULL
cmd2_desc       db      'Build BPB', NULL
cmd3_desc       db      'IOCTL Input', NULL
cmd4_desc       db      'Input Read', NULL
cmd5_desc       db      'Non-Destruc Input No Wait', NULL
cmd6_desc       db      'Input Status', NULL
cmd7_desc       db      'Input Flush', NULL
cmd8_desc       db      'Output Write', NULL
cmd9_desc       db      'Output Write with Verify', NULL
cmd10_desc      db      'Output Status', NULL
cmd11_desc      db      'Output Flush', NULL
cmd12_desc      db      'IOCTL Output', NULL
cmd13_desc      db      'Device Open', NULL
cmd14_desc      db      'Device CLOSE', NULL
cmd15_desc      db      'Removable Media', NULL
cmd16_desc      db      'Output Until Busy', NULL
cmd17_desc      db      'Reserved', NULL
cmd18_desc      db      'Reserved', NULL
cmd19_desc      db      'Generic IOCTL Request', NULL
cmd20_desc      db      'Reserved', NULL
cmd21_desc      db      'Reserved', NULL
cmd22_desc      db      'Reserved', NULL
cmd23_desc      db      'Get Drive Map', NULL
cmd24_desc      db      'Set Drive Map', NULL
cmduk_desc      db      'Unknown Command! - Define it in tables', NULL

sub_8_40_desc   db      'Set device parameters', NULL
sub_8_60_desc   db      'Get device parameters', NULL
sub_8_41_desc   db      'Write logical drive track', NULL
sub_8_61_desc   db      'Read logical drive track', NULL
sub_8_42_desc   db      'Format and verify logical drive track', NULL
sub_8_62_desc   db      'Verify logical drive track', NULL
subuk_desc      db      'Unknown Function! - Define it in tables', NULL



cmd_table       req_info        <  0, cmd0_desc,,,>
                req_info        <  1, cmd1_desc,,,>           
                req_info        <  2, cmd2_desc,,,>
                req_info        <  3, cmd3_desc,,,>
                req_info        <  4, cmd4_desc, cmd4_io,,>
                req_info        <  5, cmd5_desc,,,>
                req_info        <  6, cmd6_desc,,,>
                req_info        <  7, cmd7_desc,,,>     
                req_info        <  8, cmd8_desc, cmd8_io,,>
                req_info        <  9, cmd9_desc, cmd9_io,,>
                req_info        < 10, cmd10_desc,,,>
                req_info        < 11, cmd11_desc,,,>     
                req_info        < 12, cmd12_desc,,,>
                req_info        < 13, cmd13_desc,,,>     
                req_info        < 14, cmd14_desc,,,>
                req_info        < 15, cmd15_desc,,,>     
                req_info        < 16, cmd16_desc, cmd16_io,,>     
                req_info        < 17, cmd17_desc,,,>     
                req_info        < 18, cmd18_desc,,,>    
                req_info        < 19, cmd19_desc,, cmd_func_tbl,>
                req_info        < 20, cmd20_desc,,,>
                req_info        < 21, cmd21_desc,,,>
                req_info        < 22, cmd22_desc,,,>
                req_info        < 23, cmd23_desc,,,>     
                req_info        < 24, cmd24_desc,,,>     
                req_info        < TABLE_TERM, cmduk_desc,,,>
;
;The data in the following table follows the format defined in the        
;io_table structure.  Each group of data can have a variable length.  If the
;element at offset io_bs_indic is FALSE, then a variable number of additional
;elements as outlined in the structure io_bs_elements will appear.
;

io_cmd_table    label   word
cmd4_io         dw      14
                dw      18
                db      INPUT
                db      TRUE

cmd8_io         dw      14
                dw      18
                db      OUTPUT
                db      TRUE

cmd9_io         dw      14
                dw      18
                db      OUTPUT
                db      TRUE

cmd16_io        dw      14
                dw      18
                db      OUTPUT
                db      TRUE

cmd_19_8_41_io  dw      9
                dw      7
                db      OUTPUT
                db      TRUE

cmd_19_8_61_io  dw      9
                dw      7
                db      INPUT
                db      TRUE




cmd_func_tbl       func            <19, 13, 14, cmd_f_detail, TRUE >

cmd_f_detail    func_detail     <8, 40h, sub_8_40_desc, 33,,>
                func_detail     <8, 60h, sub_8_60_desc, 33,,>       
                func_detail     <8, 41h, sub_8_41_desc, 13, cmd_19_8_41_io,>
                func_detail     <8, 61h, sub_8_61_desc, 13, cmd_19_8_61_io,>
                func_detail     <8, 42h, sub_8_42_desc, 5,,>   
                func_detail     <8, 62h, sub_8_62_desc, 5,,>
                func_detail     <TABLE_TERM, 0, subuk_desc, 0,,>
;------end of stlogdat.inc


