//-------------------------------------------------------------------------
//			ActionMedia II Programmer's Toolkit
//	
//			Windows Motion Player Sample Program
//	
// Header Name:	avkcapt.h
//
// Description:	header file for avkcapt.exe
//	
//	Copyright Intel Corp. 1991, 1992
//	All Rights Reserved.
//				
//-------------------------------------------------------------------------

#ifndef AVKCAPT_H
#define	AVKCAPT_H	1

#include "avkapi.h"

//	File name for the RTV 2.0 VSH data file (from avkalg.h)

#define	VSHFILE_NAME	AVK_RTV_20_ENCODE_DATA_NAME

//	A couple of shorthand AVK #defines for convenience.

#define	OK			AVK_ERR_OK
#define	NOW			AVK_TIME_IMMEDIATE
#define	HNULL		((HAVK)0)

//	Menu option ID values.

#define	IDM_OPEN		100
#define	IDM_CLOSE		101
#define	IDM_ABOUT		102
#define	IDM_TIMER		103
#define	IDM_MONITOR		200
#define	IDM_CAPTURE		300
#define	IDM_SYNC		400
#define	IDM_EXIT		500

//	ID for the file name edit box.

#define	IDD_FNAME		100

// 	ID's for the Sync dialog box.

#define IDD_SYNC_NTSC	101
#define	IDD_SYNC_PAL	102

//	Values for EnableMenuItem() flags.

#define	MENUITEM_ON		MF_ENABLED
#define	MENUITEM_OFF	(MF_DISABLED | MF_GRAYED)

//	Values for capturing.

#define AUD_SAMPLE_RATE		(U32)33075
#define	FRAME_RATE			(U32)33367

//	Size and granularity of video Group Buffer and audio Group Buffer.  
//	The granularity is the amount of data in the buffer that will trigger
//	an AVK_CAPTURE_DATA_AVAILABLE message from AVK telling us to retrieve
//	some data.  Unlike in playback, we want to set the granularity low
//	when capturing so we have plenty of extra buffer space to capture into
//	while we are retrieving the data.

#define	VID_BUF_SIZE		(256L * 1024L)	
#define	VID_BUF_GRAN		( 64L * 1024L)		

#define	AUD_BUF_SIZE		(128L * 1024L)		
#define	AUD_BUF_GRAN		( 16L * 1024L)

//	Size of host buffers for reading captured frames from the Group Buffers.
//	These can be altered to tune capture performance.

#define	HOST_BUF_SIZE		32768U

//	Maximum number of iterations of the capture loop before we are forced
//	back to the main message loop.  This can be altered to tune capture
//	performance.

#define	CAPTURE_LOOPS		10

//	ID value for the capture Windows timer.

#define	TIMER_ID		1

//	Number of milliseconds between timer ticks.  This can be altered to
//	tune capture performance.

#define	TIMER_INTERVAL	500

//	ID value for the clipping timer.

#define CLIP_TIMER_ID		2

#define	CLIP_TIMER_INTERVAL	500

//	States for the capture engine.

#define	ST_UNINITIALIZED		0
#define	ST_INITIALIZED			1
#define	ST_MONITORING			2
#define	ST_CAPTURING			3

//	Control structure for the current view.

typedef struct tagVIEW {
	HAVK	hView;				// AVK View handle
	HAVK	hConnDigi2Strm;		// Digitizer -> Video Stream connector handle
	HAVK	hConnStrm2View;		// Video Stream -> View connector handle
	BOOL	bConnEnabled;		// TRUE if the connector is enabled
	WORD	DviMonitorSync;		// DviMonitorSync value from AVK.INI
	I16		cxView;				// View's x resolution
	I16		cyView;				// View's y resolution
	double	xDelta;				// used to convert screen x coords to view
	double	yDelta;				// used to convert screen y coords to view
	I16		cxScreen;			// physical screen's x resolution
	I16		cyScreen;			// physical screen's y resolution
	U16		VidType;			// View's video type
	U16		BmFmt;				// View's bitmap format
	BOOL	bIsKeyed;			// TRUE if the View is keyed
	BOX		SrcBox;				// connector's source rectangle
	BOX		DstBox;				// connector's destination rectangle
} VIEW;		


typedef struct tagCAPT {
	HAVK		hGrpBuf;			// group buffer handle
	HAVK		hStrm;				// stream handle
	char far   *pBufHead;			// host RAM I/O buffer
	char far   *pBufCurr;			// current position in host RAM I/O buffer
	U32			BufDataCnt;			// amount of data in host RAM I/O buffer
} CAPT;


//-------------------------------------------------------------------------
//	Structure for storing sync resolutions. The sync table will be an
//	array of VIDEO_SYNC structures called Syncs[].
//-------------------------------------------------------------------------

typedef struct tagVIDEO_SYNC {
	WORD	xResRTV;			// RTV capture x resolution
	WORD	xResVid;			// Video stream premonitor x resolution
	WORD	yResVid;			// Video stream premonitor y resolution
	WORD	FrameRate;
	WORD	PixelAspect;
} VIDEO_SYNC;

// These sync values are subscripts into a table of VIDEO_SYNC structures.
//	DO NOT CHANGE THEM!

#define	SYNC_NTSC	0
#define	SYNC_PAL	1


//	Macros to manipulate BOX structures. Note that SETBOX and INTERSECTBOX
//	use Windows RECT operations and work on BOX structures because their 
//	elements are equivalent.

#define	SETBOX(b, x1, y1, x2, y2)	SetRect((RECT *)b, x1, x2, y1, y2)
#define	COPYBOX(d, s)				memcpy(d, s, sizeof(BOX))
#define	INTERSECTBOX(d, s1, s2)		IntersectRect((RECT *)d, (RECT *)s1,\
										(RECT *)s2)

//-------------------------------------------------------------------------
//	External function prototypes.
//-------------------------------------------------------------------------

#ifndef ACMAIN_NOEXTERNS
extern VOID		UpdateMenus(WORD);
#endif

#ifndef ACAVK_NOEXTERNS
extern BOOL		ToggleMonitor(VOID);
extern BOOL		SetDstBox(HWND);
extern BOOL		SetCopyList(HWND *, WORD);
extern WORD		ToState(WORD);
extern BOOL		IsState(WORD);
extern WORD		GetState(VOID);
#endif

#ifndef ACRECT_NOEXTERNS
extern VOID		WinRect2AvkBox(RECT *, BOX *, VIEW *);
#endif

#ifndef ACCAPT_NOEXTERNS
extern BOOL		OpenAvioFile(char *);
extern BOOL		CloseAvioFile(VOID);
extern BOOL		ToggleCapture(VOID);
extern BOOL		CaptureAvioData(VOID);
#endif

#endif		// #ifndef AVKCAPT_H

