#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>
#include <conio.h>
#include <string.h>

#include "uc.h"
#include "doscalls.h"


// Define memory allocation functions.	If using DOS memory allocation
// functions, provided through DOSCALLS, then set the conditional compilation
// 'DOSALLOC' to true.  If using C compiler library function memory allocation
// set 'DOSALLOC' to zero.

#define DOSALLOC 0
// Redirect memory allocation to either DOS memory allocate functions located
// in DOSCALLS or to C library far memory allocation functions.
unsigned char far * far memalloc(long int siz)
{
	#if DOSALLOC
		return(fmalloc(siz));  // DOS far memory allocation functions
	#else
		return(farmalloc(siz)); // C's far memory allocation functions.
	#endif
}

void far memfree(char far *memory)
{
	#if DOSALLOC
		ffree(memory);
	#else
		farfree(memory);
	#endif
}

unsigned int ABXframe(char far *scratch,char far *dest,int frameno,int fhand,int far *freq);

void main(argc,argv)
int argc;
char **argv;
{
	long int siz;
	int compressed = 0,fhand,abxfhand;
	unsigned int len;
	unsigned char far *seg=0,far *nseg;
	int TotalFrames=0,FrameNo=0,freq=9000;	// Total number of frames.
	unsigned int bsize=65535;
	long int TotSiz;	// Total size of all frames, uncompressed.

	if ( argc != 2 )
	{
		writeln("Usage: UCOMP <filename>\n");
		writeln("Where <filename> is an ACOMP compressed sound file.\n");
		writeln("ACOMP compressed files end with the extension of .ABT.\n");
		writeln("or extended ACOMP files with the extention of .ABX.\n");
		writeln("UCOMP written by John W. Ratcliff, 1991\n");
		exit(1);
	}
	len = strlen(argv[1]);				 // Get the length of this string.
	if (len > 4)
	{
		strupr( argv[1] );
    if (strcmp( &argv[1][len-4], ".ABT") == 0 )
		{
			compressed = 2;
			seg = fload(argv[1], &siz);
		}
		if (strcmp( &argv[1][len-4], ".ABX") == 0 )
		{
			compressed = 3;
			abxfhand = mfopen(argv[1], &siz, OLD_FILE); // Open the sound file.
			if ( abxfhand )
			{
				mfread(&TotalFrames, 2L, abxfhand);  // Read in the total number of frames.
				mfread(&TotSiz, 4L, abxfhand); // Read in the total size of the original file.
				mfread(&bsize, 2L, abxfhand); // Find the buffer size, in bytes.
				mfread(&freq, 2L, abxfhand); // Find the playback frequency.
				seg = memalloc(bsize); // Allocate the memory for scratch buffer..
			}
		}
	}

	if ( !compressed )
	{
		writeln("File '");
		writeln(argv[1]);
		writeln("' is not a compressed file.\n");
		exit(1);
	}

	if ( !seg )
	{
		writeln("Unable to load file '");
		writeln(argv[1]);
		writeln("'.\n");
		exit(1);
	}

	nseg = memalloc(bsize);
	if (!nseg)
	{
		writeln("Couldn't allocate memory.\n");
		exit(1);
	}

	if ( compressed == 2 )
	{
		writeln("Decompressing ACOMP compressed sound sample.\n");
		siz = (long) UnCompressAudio( seg, nseg );
	}

	argv[1][len-3] = '8';
	argv[1][len-2] = 'S';
	argv[1][len-1] = 'N';

	writeln("Saving uncompressed sound file as '");
	writeln(argv[1]);
	writeln("'.\n");
	fhand = mfopen(argv[1], 0, NEW_FILE);
	if ( !fhand )
	{
		writeln("Failure to open output file.\n");
		exit(1);
	}
	if ( compressed == 1 || compressed == 2 )
	{
		mfwrite(nseg, siz, fhand);
	}
	else
	{
		FrameNo = 0;
		for ( FrameNo=0; FrameNo<TotalFrames; FrameNo++)
		{
			siz = ABXframe(seg,nseg,FrameNo,abxfhand,&freq);	//Load an ABX frame.
			mfwrite(nseg, siz, fhand); // Write it out to disk.
		}
		mfclose(abxfhand);
	}
	mfclose(fhand);

	memfree(seg); 	// Read buffer.
	memfree(nseg);	// Scratch decompress buffer.
}

// Reads a particular frame of ACOMP compressed data from an ABX file and
// decompresses it into the destination buffer.
unsigned int ABXframe(char far *scratch,char far *dest,int frameno,int fhand,int far *freq)
{
	long int seekloc;
	ABH ABHEAD;

	seekloc = frameno*sizeof(ABH)+10L;
	mfseek(fhand,seekloc);
	mfread(&ABHEAD, sizeof(ABH), fhand); // Read in an ABX header.
	mfseek(fhand,ABHEAD.fileaddress); // Seek to frame location.
	mfread(scratch, ABHEAD.fsize, fhand);  // Read compressed data frame.
	*freq = GetFreq(scratch);
	return( UnCompressAudio(scratch,dest) );
}

