/* ------- tsrtest.c -------- */

#include "dflat.h"

char DFlatApplication[] = "TSRTest";
char **Argv;
static void BeginTest(void);
static int TestProc(WINDOW wnd,MESSAGE msg,PARAM p1,PARAM p2);

#define ID_UNLOAD 300

/* ----- hot key = Alt-period ----- */
#define Keymask  8
#define Scancode 52

/* --------------------- the main menu --------------------- */
DEFMENU(MainMenu)
    /* --------------- the File popdown menu ----------------*/
    POPDOWN( "~File",  NULL, ""   )
        SELECTION( "E~xit",           ID_EXIT,       ALT_X,    0 )
		SELECTION( "Dos ~shell",      ID_DOS,		 0,		   0 )
        SELECTION( "~Unload",         ID_UNLOAD,     0,        0 )
    ENDPOPDOWN
ENDMENU

/* ------------- the System Menu --------------------- */
DEFMENU(SystemMenu)
    POPDOWN("System Menu", NULL, NULL)
        SELECTION("~Restore",  ID_SYSRESTORE,  0,         0 )
        SELECTION("~Move",     ID_SYSMOVE,     0,         0 )
        SELECTION("~Size",     ID_SYSSIZE,     0,         0 )
        SELECTION("Mi~nimize", ID_SYSMINIMIZE, 0,         0 )
        SELECTION("Ma~ximize", ID_SYSMAXIMIZE, 0,         0 )
        SEPARATOR
        SELECTION("~Close",    ID_SYSCLOSE,    CTRL_F4,   0 )
    ENDPOPDOWN
ENDMENU

void InitPopup(void)
{
	Argv = _argv;
	LoadHelpFile();
}

void LoadPopup(void)
{
	MainMenu.PullDown[0].Selections[1] = MainMenu.PullDown[0].Selections[2];
	puts("Loading TSRTest. Hot key is Alt+period");
	registertsr(Keymask, Scancode);
}

void CommandLinePopup(void)
{
	BeginTest();
}


void TSRPopup(void)
{
	BeginTest();
}

static void BeginTest(void)
{
	WINDOW awnd;
	/* ------- can't run under graphics video mode ------- */
	videomode();
	if (!ismono() && !istext())	{
		beep();
		return;
	}
	MainMenu.PullDown[0].Selections[2].SelectionTitle = NULL;

	init_messages();
	awnd = CreateWindow(APPLICATION,
						DFlatApplication,
						15, 5, 15, 50,
						&MainMenu,
						NULL,
						TestProc,
						MOVEABLE  |
						SIZEABLE  |
						HASBORDER |
						HASSTATUSBAR |
						MINMAXBOX | SHADOW
						);
	SendMessage(awnd, SETFOCUS, TRUE, 0);
	while (dispatch_message())
		;
}

/* ------- window processing module for the
						application window ----- */
static int TestProc(WINDOW wnd,MESSAGE msg,PARAM p1,PARAM p2)
{
	switch (msg)	{
		case COMMAND:
			switch ((int)p1)	{
				case ID_UNLOAD:
					if (YesNoBox("Unload TestProc?"))	{
						unload_tsrplus();
						PostMessage(wnd, CLOSE_WINDOW, 0, 0);
					}
					return TRUE;
				default:
					break;
			}
		default:
			break;
	}
	return DefaultWndProc(wnd, msg, p1, p2);
}


