;---------------------------------------------------------------    
;dbdat.inc - data for debugger                                 |
;--------------------------------------------------------------|
;

data            segment para public 'data16' use16
                public  get_out, edit_routine, cmd_buffer, config_attrib 
                public  config_attrib, wrk_vid_offset, user_page 
                public  debug_page, firstf, io_instrucf, io_bpdat  
                public  trace_count, get_out, num_io_bp, RW_LEN 
                public  bp_reg_dat, write_text, WRITE_LEN, rw_text 
                public  num_reg_type, buf_put, buf_get, save_curs_pos 
                public  spec_keys, SPEC_KEYS_LEN, key_buf 
                public  debug_page_off, prompt_char
                public  io_table, IO_TAB_ENTRIES
                public  display_loc, io_inst_port, io_inst_info
                public  DATA_BEG, DATA_END, int1_active
                public  gdtlim, idtlim, gdtl, idtl, gdtadrs, idtadrs
                public  num_int_bp, int_bpdat, num_reg_data, num_table
                public  tuser_ip, tuser_cs, trap_clear, video_seg    
DATA_BEG        EQU     $

spec_keys       sp_key_tab      <LEFT_ARROW, zcode:do_left>
                sp_key_tab      <RUB_OUT, zcode:do_rub_out>
                sp_key_tab      <RIGHT_ARROW, zcode:do_right>
                sp_key_tab      <INSERT, zcode:do_insert>
                sp_key_tab      <DELETE, zcode:do_delete>
SPEC_KEYS_LEN   EQU     ($ - spec_keys)/size sp_key_tab                

cmd_table       cmd_info        <trace, TRACE_LEN, zcode:do_trace>
                cmd_info        <go, GO_LEN, zcode:do_go>
                cmd_info        <reg, REG_LEN, zcode:do_reg>
                cmd_info        <dump, DUMP_LEN, zcode:do_dump>
                cmd_info        <edit, EDIT_LEN, zcode:do_edit_b>
                cmd_info        <quit, QUIT_LEN, zcode:do_quit>
                cmd_info        <xud, XUD_LEN, zcode:do_xud>
;
;Place all commands which start with the same letter together.  Order
;them by length in decreasing order (str_lookup routine depends on this)
;
                cmd_info        <brk_pint, BRK_PINT_LEN, zcode:do_bpint>
                cmd_info        <brk_pio, BRK_PIO_LEN, zcode:do_bpio>
                cmd_info        <brk_pb, BRK_PB_LEN, zcode:do_bp>
                cmd_info        <brk_pw, BRK_PW_LEN, zcode:do_bpw>
                cmd_info        <brk_pd, BRK_PD_LEN, zcode:do_bpd>
                cmd_info        <brk_px, BRK_PX_LEN, zcode:do_bpx>
                cmd_info        <brk_c, BRK_C_LEN, zcode:do_bc>
                cmd_info        <brk_l, BRK_L_LEN, zcode:do_bl>
                cmd_info        <brk_p, BRK_P_LEN, zcode:do_bp>
CMD_TABLE_LEN   EQU     ($ - cmd_table)/size cmd_info


trace           db      'T'
TRACE_LEN       EQU     $ - trace

go              db      'G'
GO_LEN          EQU     $ - go

reg             db      'R'
REG_LEN         EQU     $ - reg

dump            db      'D'
DUMP_LEN        EQU     $ - dump

edit            db      'E'
EDIT_LEN        EQU     $ - edit

quit            db      'Q'
QUIT_LEN        EQU     $ - quit

xud             db      'XUD'
XUD_LEN         EQU     $ - xud 

brk_c           db      'BC'
BRK_C_LEN       EQU     $ - brk_c 

brk_l           db      'BL'
BRK_L_LEN       EQU     $ - brk_l 

brk_p           db      'BP'
BRK_P_LEN       EQU     $ - brk_p 

brk_pb          db      'BPB'
BRK_PB_LEN      EQU     $ - brk_pb      

brk_pw          db      'BPW'
BRK_PW_LEN      EQU     $ - brk_pw      

brk_pd          db      'BPD'
BRK_PD_LEN      EQU     $ - brk_pd      

brk_px          db      'BPX'
BRK_PX_LEN      EQU     $ - brk_px        

brk_pio         db      'BPIO'
BRK_PIO_LEN     EQU     $ - brk_pio       

brk_pint        db      'BPINT'
BRK_PINT_LEN    EQU     $ - brk_pint      

read_text       db      'R'
READ_LEN        EQU     $ - read_text

write_text      db      'W'
WRITE_LEN       EQU     $ - write_text

rw_text         db      'RW'
RW_LEN          EQU     $ - rw_text

eq_text         db      'EQ'
EQ_LEN          EQU     $ - eq_text

eqsign_text     db      '='
EQSIGN_LEN      EQU     $ - eqsign_text

ne_text         db      'NE'
NE_LEN          EQU     $ - ne_text


al_text         db      'AL'
ah_text         db      'AH'

ax_text         db      'AX'
REGS16_TEXT_LEN EQU     $ - ax_text
cx_text         db      'CX'
dx_text         db      'DX'
bx_text         db      'BX'
sp_text         db      'SP'
bp_text         db      'BP'
si_text         db      'SI'
di_text         db      'DI'
ds_text         db      'DS'
es_text         db      'ES'
fs_text         db      'FS'
gs_text         db      'GS'
ss_text         db      'SS'
cs_text         db      'CS'
ip_text         db      'IP'
f_text          db      'F'



ov_text         db      'OV'
dn_text         db      'DN'
ei_text         db      'EI'
ng_text         db      'NG'
zr_text         db      'ZR'
ac_text         db      'AC'
pe_text         db      'PE'
cy_text         db      'CY'
SET_FLAGS_LEN   EQU     ($ - ov_text)
nv_text         db      'NV'
up_text         db      'UP'
fdi_text        db      'DI'
pl_text         db      'PL'
nz_text         db      'NZ'
na_text         db      'NA'
po_text         db      'PO'
nc_text         db      'NC'


flags_info_start label  word     
flags_info_ov   flags_tbl       <ov_text, 2, overf>
flags_info_dn   flags_tbl       <dn_text, 2, direc>
flags_info_ei   flags_tbl       <ei_text, 2, inter>
flags_info_ng   flags_tbl       <ng_text, 2, sign>
flags_info_zr   flags_tbl       <zr_text, 2, zero>
flags_info_ac   flags_tbl       <ac_text, 2, auxcarry>
flags_info_pe   flags_tbl       <pe_text, 2, parity>
flags_info_cy   flags_tbl       <cy_text, 2, carry>
FLAGS_ALL_BITS  EQU  ($ - flags_info_start)/size flags_tbl
flags_info_mid  EQU offset flags_info_nv     
flags_info_nv   flags_tbl       <nv_text, 2, overf>
flags_info_up   flags_tbl       <up_text, 2, direc>
flags_info_di   flags_tbl       <di_text, 2, inter>
flags_info_pl   flags_tbl       <pl_text, 2, sign>
flags_info_nz   flags_tbl       <nz_text, 2, zero>
flags_info_na   flags_tbl       <na_text, 2, auxcarry>
flags_info_po   flags_tbl       <po_text, 2, parity>
flags_info_nc   flags_tbl       <nc_text, 2, carry>
FLAGS_TABLE_ENTRIES EQU  ($ - flags_info_start)/size flags_tbl

regs_info_start label  word                   
regs_info_ax    regs_stab <ax_text, REGS16_TEXT_LEN, regs_ax>
regs_info_cx    regs_stab <cx_text, REGS16_TEXT_LEN, regs_cx>
regs_info_dx    regs_stab <dx_text, REGS16_TEXT_LEN, regs_dx>
regs_info_bx    regs_stab <bx_text, REGS16_TEXT_LEN, regs_bx>
regs_info_sp    regs_stab <sp_text, REGS16_TEXT_LEN, regs_sp>
regs_info_bp    regs_stab <bp_text, REGS16_TEXT_LEN, regs_bp>
regs_info_si    regs_stab <si_text, REGS16_TEXT_LEN, regs_si>
regs_info_di    regs_stab <di_text, REGS16_TEXT_LEN, regs_di>
regs_info_ip    regs_stab <ip_text, REGS16_TEXT_LEN, regs_ip>

REGS_GEN_ENTRIES EQU ($ - regs_info_start)/size regs_stab   

REGS_INFO_SEGS  EQU  offset regs_info_ds


regs_info_ds    regs_stab <ds_text, REGS16_TEXT_LEN, regs_ds>
regs_info_es    regs_stab <es_text, REGS16_TEXT_LEN, regs_es>
regs_info_fs    regs_stab <fs_text, REGS16_TEXT_LEN, regs_fs>
regs_info_gs    regs_stab <gs_text, REGS16_TEXT_LEN, regs_gs>
regs_info_ss    regs_stab <ss_text, REGS16_TEXT_LEN, regs_ss>
regs_info_cs    regs_stab <cs_text, REGS16_TEXT_LEN, regs_cs>
REGS_SEGS_ENTRIES EQU  ($ - regs_info_segs)/size regs_stab
regs_info_f     regs_stab <f_text, 1, regs_f>
REGS_TABLE_ENTRIES EQU  ($ - regs_info_start)/size regs_stab

;
;Holds index for entry in table of offsets.  These are in the order in which
;registers are displayed by the register command.

regs_indx       db       (regs_info_ax - regs_info_start)
                db       (regs_info_bx - regs_info_start)
                db       (regs_info_cx - regs_info_start)
                db       (regs_info_dx - regs_info_start)
                db       (regs_info_sp - regs_info_start)
                db       (regs_info_bp - regs_info_start)
                db       (regs_info_si - regs_info_start)
                db       (regs_info_di - regs_info_start)
NUM_REGS_1LINE  EQU     $ - regs_indx   ;number of registers on one line
                db       (regs_info_ds - regs_info_start)
                db       (regs_info_es - regs_info_start)
                db       (regs_info_ss - regs_info_start)
                db       (regs_info_cs - regs_info_start)
                db       (regs_info_ip - regs_info_start)
                db       (regs_info_f - regs_info_start)
NUM_REGS_DISP   EQU     $ - regs_indx   ;number of registers to display


dir_indic_r     off_len_code <read_text, READ_LEN, IO_TYPE_READ >
dir_indic_rw    off_len_code <rw_text, RW_LEN, DEB_TYPE_RW>
                off_len_code <write_text, WRITE_LEN, DEB_TYPE_WRITE>
RW_W_ENTRIES    EQU  ($ - dir_indic_rw)/size off_len_code
DIR_TABLE_ENTRIES EQU  ($ - dir_indic_r)/size off_len_code

operators       off_len_code <eq_text, EQ_LEN, EQ_CODE>
                off_len_code <eqsign_text, EQSIGN_LEN, EQ_CODE>
EQ_TABLE_ENTRIES EQU  ($ - operators)/size off_len_code
                off_len_code <ne_text, NE_LEN, NE_CODE>
OPER_TABLE_ENTRIES EQU  ($ - operators)/size off_len_code

tab_ax          off_len_code <al_text, REGS16_TEXT_LEN, INT_AL_COMP>
                off_len_code <ah_text, REGS16_TEXT_LEN, INT_AH_COMP>
                off_len_code <ax_text, REGS16_TEXT_LEN, INT_AX_COMP>
AX_TABLE_ENTRIES EQU  ($ - tab_ax)/size off_len_code

num_table       db      '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'

syntax_msg      db      'Syntax Error', STR_TERM
bad_reg_msg     db      'Invalid register specified', STR_TERM
bad_flags_msg   db      'Invalid flags specified', STR_TERM
bad_addrs_msg   db      'Invalid address specified', STR_TERM
bad_io_msg      db      'Invalid I/O port specified', STR_TERM
bad_range_msg   db      'Invalid range specified', STR_TERM
bad_trace_msg   db      'Invalid trace count specified', STR_TERM
bad_int_msg     db      'Invalid int specified', STR_TERM
max_bps_msg     db      'Maximum break points exceeded', STR_TERM
max_deb_msg     db      'Maximum debug register break points exceeded', STR_TERM
bad_bp_msg      db      'Only W or RW are valid', STR_TERM
bad_iodir_msg   db      'Only R, W or RW are valid', STR_TERM
bad_bc_msg1     db      'Must specify "*" or break point number', STR_TERM
bad_bc_msg2     db      'Exceeds number of break points', STR_TERM
prompt_char     db      '$'

BUF_START       equ     offset key_buf
key_buf         dw      KEY_BUF_MAX dup(0)
BUF_END         equ     offset buf_put         
buf_put         dw      offset key_buf
buf_get         dw      offset key_buf
save_curs_pos   dw      ?
config_attrib   db      DEFAULT_ATTRIB    
;
;may want to see which page is in use and change debug page appropriately.
;

debug_page      db      DEF_DB_PAGE             ;page debugger will use
debug_page_off  dw    (PAGE_SIZE * DEF_DB_PAGE) ;offset of that page
user_page       db      0                       ;find out first
wrk_vid_offset  dw      ?
cmd_buffer      db      CMD_MAX_LEN + 1 dup(' ')
get_out         dw      0                       ;get out of edit on key
edit_routine    dw      0                       ;offset of edit routine
int1_active     db      FALSE                   ;true when debugger is active

did_dump        db      FALSE                   ;no dump command yet
dump_address    dd      0                       ;seg:off for dumps
edit_address    dd      0                       ;seg:off for edits
edit_length     db      0                       ;length of edit data
edit_num        db      0                       ;number of items to edit
seg_found       db      FALSE                   ;TRUE if seg reg found        
trace_count     dw      0                       ;used for TRACE [n]
io_instrucf     db      FALSE                   ;TRUE is tracing thru I/O
io_inst_port    dw      0                       ;port used in I/O instruction
io_inst_info    db      0                       ;information about instruction
firstf          db      TRUE                    ;first time in debugger

max_goneto      db      0                       ;highest of the brk points
num_used        db      0                       ;number brk points active
num_reg_type    db      0                       ;number debug reg type breaks
num_reg_data    db      0                       ;number debug reg data type
num_int_bp      db      0                       ;number int type breaks
num_io_bp       db      0                       ;number I/O type breaks

tuser_ip        dw      0
tuser_cs        dw      0
trap_clear      db      FALSE                   ;TRUE if ISR should not clear
                                                ;the trap flag
brk_list        mast_list  MAX_BRK_POINTS dup(<AVAIL,>) ;master break point list
bp_reg_dat      info_bpreg MAX_DR_BRK_POINTS dup(<AVAIL,,,,,>) ;debug reg list
int_bpdat       info_int   MAX_BRK_POINTS dup(<AVAIL,,,>) ;int break point list
io_bpdat        info_io    MAX_BRK_POINTS dup(<AVAIL,,,,>) ;I/O break point list

io_table        io_struc        <0e4h, INPUT+CONSTANT+ABYTE>
                io_struc        <0e5h, INPUT+CONSTANT+AWORD>
                io_struc        <0e6h, OUTPUT+CONSTANT+ABYTE>
                io_struc        <0e7h, OUTPUT+CONSTANT+AWORD>
                io_struc        <0ech, INPUT+ABYTE>
                io_struc        <0edh, INPUT+AWORD>
                io_struc        <0eeh, OUTPUT+ABYTE>
                io_struc        <0efh, OUTPUT+AWORD>
                io_struc        <06ch, STRING+INPUT+ABYTE>
                io_struc        <06dh, STRING+INPUT+AWORD>
                io_struc        <06eh, SEG_OVER+STRING+OUTPUT+ABYTE>
                io_struc        <06fh, SEG_OVER+STRING+OUTPUT+AWORD>
IO_TAB_ENTRIES  EQU     ($ - io_table)/size io_struc     


gdtl            EQU     THIS FWORD
gdtlim          dw      ?
gdtadrs         dd      ?

idtl            EQU     THIS FWORD
idtlim          dw      ?
idtadrs         dd      ?

video_seg       dw      ?
display_loc     dw      0               ;offset into video page
DATA_END        EQU     $
data            ends                              

