;dbedit.asm 
;Debugger editing routines
;               
.386P
;---------------------------------------------------------------------------- 
;Copyright 1991, 1992 ASMicro Co. 
;7/6/91	   Rick Knoblaugh
;-----------------------------------------------------------------------------
                include dbequ.inc
                include dbmac.inc
                include dbstruc.inc

data            segment para public 'data16' use16
                extrn   get_out:word
                extrn   edit_routine:word
                extrn   cmd_buffer:byte
                extrn   config_attrib:byte
                extrn   spec_keys:byte
                extrn   SPEC_KEYS_LEN:abs
                extrn   key_buf:word      
                extrn   buf_put:word      
                extrn   buf_get:word      

BUF_START       equ     offset key_buf
BUF_END         equ     offset buf_put
data            ends

zcode    segment para public 'code16' use16
                extrn   set_cursor_pos:near

                public  editor, clear_buffer
                public  do_left, do_right, do_rub_out, do_insert, do_delete
	assume cs:zcode, ds:data, es:nothing


;----------------------------------------------------------------------
;editor - Accept input from keyboard.                                 |
;                                                                     |
;             Enter: es = video segment                               |
;                    di = offset into video buffer of first           |
;                         position for user input                     |
;                    ds = debugger data segment                       |
;                    si = offset of buffer in which to store data     |
;                    dl = max chars allowed                           |
;                    dh = max chars entered so far                    |
;                    bx = counter of chars being input                |
;               get_out = value for key that additionally (besides    |
;                         ESC and CR) causes an exit from edit        |
;                         (zero if none).                             |
;                                                                     |
;          edit_routine = offset of editing routine (zero if none).   |
;                         This routine should return with carry set   |
;                         if input is illegal.                        |
;                                                                     |
;                                                                     |
;              Exit: dh = maximum chars entered                       |
;                    ax = last key entered (will be either ESC, CR, or|
;                         get_out).                                   |
;                                                                     |
;  CX saved.                                                          |
;----------------------------------------------------------------------
editor          proc    near
                push    cx
editor_100:
                mov     ax, di
                shr     ax, 1 
                call    set_cursor_pos
                call    get_char
                call    check_spec_keys
                or      cx, cx                  ;key was found?      
                jnz     short editor_100        ;if not
                or      al, al                  ;extended key?
                jz      short editor_100        ;if so, don't want        

editor_150:
                cmp     al, CR                  ;enter key?
                je      short editor_999
                jb      short editor_100        ;if below, don't want        
                cmp     al, ESC_KEY             ;esc
                je      short editor_999
                cmp     ax, get_out             ;a "get out" key?
                je      short editor_999
                cmp     edit_routine, 0         ;editing specified?
                je      short editor_170        ;if not, continue
                call    word ptr edit_routine
                jc      short editor_100           ;if not allowable input        
editor_170:
                mov     [si + bx], al           ;store the char
                WRITE_CHAR                      ;display it
                inc     bl                      ;increment counter
                cmp     bl, dh                  ;char counter vs max entered
                jb      short editor_200   
                cmp     dh, dl                  ;char counter vs max allowed
                jb     short editor_180
editor_175:
                dec     bl
                jmp     short editor_100   

editor_180:                                             
                inc     dh                      ;advance max entered count
                cmp     dh, dl                  ;char counter vs max allowed
                je      short editor_175
editor_200:                                             
                inc     di
                inc     di                      ;advance cursor
                jmp     short editor_100   
editor_999:
                pop     cx
                ret
editor          endp

clear_buffer    proc    near
                push    ax
                push    cx
                push    di
                push    es

                push    ds
                pop     es

                mov     cx, CMD_MAX_LEN
                mov     di, offset cmd_buffer
                mov     al, ' '
                rep     stosb

                pop     es
                pop     di
                pop     cx
                pop     ax
                ret
clear_buffer    endp


;----------------------------------------------------------------------
;check_spec_keys - Look for editing keys and process edit if found.   |
;                                                                     |
;             Enter: si = offset of start of buffer being edited      |
;                    ax = scan code/char of key stroke                |
;                    bx = char counter                                |
;                    dx = max chars entered/max chars allowed         |
;                 es:di = seg:offset into video buffer                |
;                                                                     |
;             Exit:                                                   |
;                    cx = zero if key not found in table              |
;                    bx, di may be altered per arrow keys etc.        |
;                                                                     |
;           SI saved                                                  |
;----------------------------------------------------------------------
check_spec_keys proc    near                    
                push    si                      ;save start of buffer
                mov     cx, SPEC_KEYS_LEN
                mov     si, offset spec_keys
check_sp100:
                cmp     ax, [si].key_data
                jne     short check_sp200
                mov     cx, [si].key_routine
                pop     si                      ;restore start of buffer
                call    cx                      ;perform special key routine
                ret                      
check_sp200:
                add     si, size sp_key_tab                
                loop    check_sp100
check_sp300:
                pop     si        
check_sp900:
                ret
check_spec_keys endp


;----------------------------------------------------------------------
; do_rub_out - process the rub out key.                               |
;                                                                     |
;             Enter: si = offset of start of buffer being edited      |
;                    ax = scan code/char of key stroke                |
;                    bx = char counter                                |
;                    dx = max chars entered/max chars allowed         |
;                 es:di = seg:offset into video buffer                |
;                                                                     |
;              Exit: bx dh, and di updated if rub out processed.      |
;                                                                     |
;----------------------------------------------------------------------
do_rub_out      proc    near
                or      bx, bx                  ;already at far left?
                jz      short do_rub_999        ;if so, nothing to do
                mov     al,  dh                 ;get max entered
                sub     al, bl                  ;minus current offset
                cmp     al, 1                   ;at max allowable position?
                jne     short do_rub_500
                call    do_delete               ;if so, get rid of it
                jmp     short do_rub_999
do_rub_500:
                cmp     bl, dh                  ;see if at left of max
                jb      short do_rub_600        ;if so, don't subtract char
                dec     dh                      ;have 1 less char
do_rub_600:

                dec     bx
                mov     al, ' '
                mov     [si+ bx], al            ;space out what was there
                sub     di, 2                   ;move back in video buffer
                WRITE_CHAR                

do_rub_999:
                ret
do_rub_out      endp

;----------------------------------------------------------------------
; do_left - process left arrow key.                                   |
;                                                                     |
;             Enter: si = offset of start of buffer being edited      |
;                    ax = scan code/char of key stroke                |
;                    bx = char counter                                |
;                    dx = max chars entered/max chars allowed         |
;                 es:di = seg:offset into video buffer                |
;                                                                     |
;              Exit: bx decremented if left arrow processed.          |
;                                                                     |
;----------------------------------------------------------------------
do_left         proc    near
                or      bx, bx                  ;already at far left?
                jz      short do_left_999       ;if so, nothing to do
                dec     bx
                sub     di, 2
do_left_999:
                ret
do_left         endp

;----------------------------------------------------------------------
; do_right - process right arrow key.                                 |
;                                                                     |
;             Enter: si = offset of start of buffer being edited      |
;                    ax = scan code/char of key stroke                |
;                    bx = char counter                                |
;                    dx = max chars entered/max chars allowed         |
;                 es:di = seg:offset into video buffer                |
;                                                                     |
;              Exit: bx incrmented if right arrow processed.          |
;                                                                     |
;----------------------------------------------------------------------
do_right        proc    near
                or      dh, dh                  ;any chars entered?
                jz      short do_right_999
                mov     al, dl                  ;get max allowed
                dec     al
                cmp     bl, al                  ;already there?
                je      short do_right_999      ;if so, don't go
                cmp     bl, dh                  ;at max entered?
                je      short do_right_999
                inc     bx
                add     di, 2
do_right_999:
                ret
do_right        endp

do_insert       proc    near
;
;Put logic to handle insert key here.
;
                ret
do_insert       endp

;----------------------------------------------------------------------
; do_delete - process delete key.                                     |
;                                                                     |
;             Enter: si = offset of start of buffer being edited      |
;                    ax = scan code/char of key stroke                |
;                    bx = char counter                                |
;                    dx = max chars entered/max chars allowed         |
;                 es:di = seg:offset into video buffer                |
;                                                                     |
;              Exit: All chars moved left in buffer. dh decremented.  |
;                                                                     |
;----------------------------------------------------------------------
do_delete       proc    near
                or      dh, dh                  ;any chars entered
                jz      short do_del_999
                cmp     bl, dh                  ;past where entered
                jz      short do_del_999        ;if so, no delete        
                push    bx
                push    cx
                push    di
                
                xor     ch, ch
                mov     cl, dh                  ;get max entered
                sub     cl, bl                  ;minus offset where located
                dec     cx
                jcxz    do_del_800              ;if at last allowable char
                                                
do_del_100:
                mov     al, [si + bx][1]        ;get next char
                WRITE_POS                       ;write char and position cursor
                mov     [si + bx], al
                inc     bx
                loop    do_del_100
do_del_800:
                mov     al, ' '
                mov     [si + bx], al           ;space out last char
                WRITE_CHAR                      ;write char and position cursor
                dec     dh                      ;have one less char
                pop     di
                pop     cx
                pop     bx
do_del_999:
                ret
do_delete       endp

get_char        proc    near
                push    bx
get_c100:
                mov     ax, buf_put
                cmp     buf_get, ax             ;if no keys available
                je      short get_c100          ;wait for one
                mov     bx, buf_get
                mov     ax, [bx]                ;get char and scan code
                cmp     al, 0e0h                ;separate cursor pad             
                jne     short get_c150
                sub     al, al
get_c150:
                
                add     bx, 2
                cmp     bx, BUF_END             ;at end?      
                jne     short get_c200
                mov     bx, BUF_START           ;if so, wrap
get_c200:
                mov     buf_get, bx             ;next spot to get
                pop     bx
                ret
get_char        endp        

zcode           ends
        	end          

