;---------------------------------------------------------------    
;dbstruc.inc - structures for debugger                         |
;--------------------------------------------------------------|
;
intinfo 	struc
vect		dw	?
oldroutine      dd	?
offnew		dw	?
intinfo 	ends

sp_key_tab      struc   
key_data        dw      ?
key_routine     dw      ?
sp_key_tab      ends

cmd_info        struc
cmd_text        dw      ?               ;offset of cmd text
cmd_len         db      ?               ;length of command 
cmd_routine     dw      ?               ;offset of cmd processing routine
cmd_info        ends


user_stack1     struc
user1_bp         dw      ?
user1_ip         dw      ?
user1_cs         dw      ?
user1_flags      dw      ?
user_stack1     ends


regs_on_stack   struc
regs_sp         dw      ?
regs_ss         dw      ?
regs_gs         dw      ?
regs_fs         dw      ?
regs_es         dw      ?
regs_ds         dw      ?
regs_di         dw      ?
regs_si         dw      ?
regs_bp         dw      ?
regs_temp       dw      ?
regs_bx         dw      ?
regs_dx         dw      ?
regs_cx         dw      ?
regs_ax         dw      ?
regs_ip         dw      ?
regs_cs         dw      ? 
regs_f          dw      ?
regs_on_stack   ends

regs_stab       struc
regs_text_off   dw      ?
regs_text_len   db      ?
regs_stack_off  dw      ?                
regs_stab       ends

flags_tbl       struc
ftext_off       dw      ?
flen            db      ?
fbit            db      ?
flags_tbl       ends

off_len_code    struc
text_off        dw      ?
text_len        db      ?
text_code       db      ?
off_len_code    ends

info_bpreg      struc
info_bpstat     db      ?               ;indicate if bp enabled
info_bpoff      dw      ?               ;offset for break point
info_bpseg      dw      ?               ;segment for break point
info_bpsize     db      ?               ;(0=byte, 1=word and 3=dword)
info_bptype     db      ?               ;(0=exec, 1=write, 3=r/w)
info_bpcmd      dw      ?               ;offset in command table (used
info_bpreg      ends                    ;for retrieving cmd desriptions)

info_int        struc
int_stat        db      ?               ;indicate if bp enabled
int_num         db      ?               ;interrupt number
int_reg         db      ?               ;indicator of al, ah, or ax
int_val         dw      ?               ;value for comparisons
info_int        ends 

info_io         struc
io_stat         db      ?               ;indicate if bp enabled
io_port         dw      ?               ;port number
io_dir          db      ?               ;(1=write, 2=read, 3=read/write)
;
;Note:  These last two structure members are provided for the future
;       to add further conditional logic to I/O break points.
;       These are not currently utilized.
;
io_oper         db      ?               ;operator for conditions
io_val          dw      ?               ;value for conditions
info_io         ends

mast_list       struc
brk_type        db      ?               ;indication of type and if available
brk_off         dw      ?               ;offset into debug data structures
mast_list       ends

doub_word       struc   
d_offset        dw      ?
d_seg           dw      ?
doub_word       ends

flag_bits       record  fill0:14, vmbit:1, resumef:1, fill1:1, nest_taskf:1,\
                        iopl:2, overf:1, direc:1, inter:1, trapf:1, sign:1, \
                        zero:1, fill3:1, auxcarry:1, fill4:1, parity:1, \
                        fill5:1, carry:1

deb_cntrl       record  len3:2, rw3:2, len2:2, rw2:2,len1:2, rw1:2, \
                        len0:2, rw0:2, dcfill1:6, ge_bit:1, le_bit:1, \
                        g3:1, l3:1, g2:1, l2:1, g1:1, l1:1, g0:1, l0:1 

deb_dr6         record  deb_stat_bt:1, deb_stat_bs:1, deb_stat_bd:1, \
                        deb_stat_dk:9, deb_stat_b3:1, deb_stat_b2:1, \
                        deb_stat_b1:1, deb_stat_b0:1


idt             struc   
i_offset        dw      ?
i_selector      dw      ?
i_unused        db      0
i_dpl_id        db      PRESENT + (DPL0 shl 5) + INT_GATE
i_offset2       dw      0
idt             ends

seg_descrip     struc
seg_limit_low   dw      ?
seg_base_low    dw      ?
seg_base_mid    db      ?
seg_type_dpl    db      ?
seg_limit_gran  db      ?
seg_base_top    db      ?
seg_descrip     ends 

ex_mov_data     struc
ex_mdum         db      8 dup(?)
ex_mdat         db      8 dup(?)
ex_msource      db      8 dup(?)
ex_mdest        db      8 dup(?)
ex_mcs          db      8 dup(?)
ex_mss          db      8 dup(?)  
ex_mov_data     ends 


err_stack_area  struc                   ;stack with error code
e_pushed_int    dw      ?               ;int pushed by debugger
e_pushed_bp     dw      ?               ;bp pushed by debugger
e_errcode       dd      ?               ;error code
e_eip           dd      ?
e_cs            dw      ?
                dw      ?
e_eflags        dd      ?
e_esp           dd      ?
e_ss            dw      ?
                dw      ?
e_es            dw      ?
                dw      ?
e_ds            dw      ?
                dw      ?
e_fs            dw      ?
                dw      ?
e_gs            dw      ?
                dw      ?
err_stack_area  ends 

stack_area      struc                   ;stack without error code
s_pushed_int    dw      ?               ;int pushed by debugger
s_pushed_bp     dw      ?               ;bp pushed by debugger
s_eip           dd      ?
s_cs            dw      ?
                dw      ?
s_eflags        dd      ?
s_esp           dd      ?
s_ss            dw      ?
                dw      ?
s_es            dw      ?
                dw      ?
s_ds            dw      ?
                dw      ?
s_fs            dw      ?
                dw      ?
s_gs            dw      ?
                dw      ?
stack_area      ends 

user_stack      struc
user_ip         dw      ?
user_cs         dw      ?
user_flags      dw      ?
user_stack      ends


psp             struc
                db      80h dup(?)
arg_len         db      ?
arg_off         db      ?
psp             ends

io_struc        struc
io_opcode       db      ?
io_info         db      ?
io_struc        ends 


tss_dat         struc   
t_backlink      dw      ?
                dw      ?
t_esp0          dd      ?    
t_ess0          dw      ?
                dw      ?
t_esp1          dd      ?
t_ess1          dw      ?
                dw      ?
t_esp2          dd      ?
t_ess2          dw      ?
                dw      ?
t_cr3           dd      ?
t_eip           dd      ?
t_eflags        dd      ?
t_eax           dd      ?
t_ecx           dd      ?
t_edx           dd      ?
t_ebx           dd      ?
t_esp           dd      ?
t_ebp           dd      ?
t_esi           dd      ?
t_edi           dd      ?
t_es            dw      ?
                dw      ?
t_cs            dw      ?
                dw      ?
t_ss            dw      ?
                dw      ?
t_ds            dw      ?
                dw      ?
t_fs            dw      ?
                dw      ?
t_gs            dw      ?
                dw      ?
t_ldt           dw      ?
                dw      ?
t_tbit          dw      ?
t_iobase        dw      ?      
t_iomap         db      IO_MAP_SIZE     dup(?)
t_iopad         dw      0ffh            ;follow last map byte with 0ffh
tss_dat         ends



