//=================================
// Coroner, by Matt Pietrek, 1992
// File: CORONER.C
// from "Undocumented Windows"
// (Chapter 10)
//=================================

#include <windows.h>
#include <stdio.h>
#include <string.h>
#include "coroner.h"

char AppName[]      = "CORONER";

char LogFileName[MAX_PATH_LENGTH];
char ExceptionTaskName[14];

HANDLE HInstance;
HANDLE HCoronerWnd;
char ERROR_CAPTION[] = "Problem!!!";


long FAR PASCAL _export CoronerDialogProc(HWND hDlg, WORD message, 
	WORD wParam, DWORD lParam)
{
    char buffer[128];
    
    switch ( message )
    {
        case WM_COMMAND:
            if ( wParam == IDOK )
            {
                    CloseWindow(hDlg);
                    return TRUE;
            }
            break;

        case WM_CORONER_FILEOPEN_ERROR :
            MessageBox
            (
                hDlg,
                "CORONER could not open a .LOG file",
                ERROR_CAPTION,
                MB_OK
            );
            break;
                    
    
        case WM_CORONER_EXCEPTION :
            sprintf(buffer, "Exception %u in %s", wParam, ExceptionTaskName);
            MessageBox(hDlg, buffer, AppName, MB_OK);
            break;
                
        case WM_DESTROY:
            PostQuitMessage(0);
            return 0;
    }

    return DefWindowProc(hDlg, message, wParam, lParam);
}

void GetProgramVariables(void)
{
    char WindowsDirectory[MAX_PATH_LENGTH];
    int i;

    GetWindowsDirectory(WindowsDirectory, MAX_PATH_LENGTH);
    
    i = strlen(WindowsDirectory);
    
    if ( WindowsDirectory[i-1] != '\\' )
    {   // Tack on a '\' if there isn't one
        WindowsDirectory[i] = '\\';
        WindowsDirectory[i+1] = 0;
    }
    
    strcpy(LogFileName, WindowsDirectory);
    strcat(LogFileName, "CORONER.LOG"); 
}

int RegisterCoronerWindowClass(void)
{
    WNDCLASS wndclass;
    
    wndclass.style = CS_HREDRAW | CS_VREDRAW;
    (FARPROC)wndclass.lpfnWndProc = (FARPROC)CoronerDialogProc;
    wndclass.cbClsExtra = 0;
    wndclass.cbWndExtra = DLGWINDOWEXTRA;
    wndclass.hInstance = HInstance;
    wndclass.hIcon = LoadIcon(HInstance,"CORONERICON");
    wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
    wndclass.hbrBackground = GetStockObject(WHITE_BRUSH);
    wndclass.lpszMenuName = NULL;
    wndclass.lpszClassName = AppName;
    
    return RegisterClass(&wndclass);    
}

void CoronerError(char *msg)
{
    char buffer[128];
    
    sprintf(buffer, "CORONER %s", msg);
    
    MessageBox(NULL, buffer, ERROR_CAPTION, MB_OK);
}

#pragma argsused

int PASCAL WinMain( HANDLE hInstance,  HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)

{
    HWND hWnd;
    MSG msg;
    
    HInstance = hInstance;
    
    if ( hPrevInstance )
    {
        CoronerError("can only be run once");
        return 0;
    }

    if ( RegisterCoronerWindowClass() == 0)
    {
        CoronerError("can't create it's window class");
        return 0;
    }
    
    HCoronerWnd = hWnd = CreateDialog( HInstance, "CORONER", NULL, NULL);

    if ( hWnd == 0 )
    {
        CoronerError("can't create it's window");
        return 0;
    }
    
    ShowWindow(hWnd, SW_MINIMIZE);

    GetProgramVariables();

    if ( SetupInterruptHandler() == FALSE )
    {
        CoronerError("can't install a fault handler");
        return 0;
    }

    while ( GetMessage(&msg, NULL, 0, 0) )
    {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
    
    ShutdownInterruptHandler();

    return 0;
}
