
/*************************************************************************
* CLIENT.C
*    Front end (CLIENT.EXE) for demonstration client-server record manager.
*    by Michael Day
*    Copyright 1992, Michael Day. This work (and portions of it)
*    may be freely copied, altered, and distributed, either in source
*    or binary form, provided that it is not used for commercial purposes,
*    except as a teaching tool to demonstrate network programming.
*
*    This file require Borland C 3.0 (Large Memory Model)
*    Note:  WORD alignment must be turned OFF when compiling, otherwise
*    packets to and from the NLM will be misaligned by one byte.
*
**************************************************************************/

#include "client.h"

BYTE serverAddress[12];                   // network address of ENGINE
INFO info[NUMBER_OF_NODES];               // collect information about
                                          // advertising engines. 
extern unsigned _stklen = 0x6000;

/**************************************************************************
*  GetRecord
*
*  This function makes EditRecord, ReadRecord, and DeleteRecord
*  requests. Each of these requests requires we first issue a
*  FindRecordKey request to the engine and verify that the engine
*  actually found the record.
*
*  The EditRecord and DeleteRecord requests also require that we
*  modify the record returned to us by the engine and send that record
*  back to the engine with the appropriate op code (update or delete).
*
**************************************************************************/
int GetRecord(BYTE operation)
{
    /* This function servers three purposes: reading a record, */
    /* deleting a record, and updating a record. First, however, */
    /* we must issue a FindRecord request to the server. If the
    /*    server doesn't find the record, we exit with an error code.
    /* Otherwise we perform the requested operation and listen for a
    /* confirmation packet from the server. */

    IPX_ECB listenECB, sendECB;            // ECBs for sending and receiving
    IPX_HEADER listenHeader, sendHeader;   // IPX headers
    lPacket listenPacket, sendPacket;      // packet buffers

    int ccode, transportTime, index;
    char c, attr, inputBuf[129], *bufp;
    char *screenBuf;
    struct text_info textInfo;
    clock_t begin, end;                    // use to time-out listening ECBs
    WORD findResponseCode = 0x00fe;        // verify integrity of received
    WORD opResponseCode = 0x00fd;          // packets
    
    screenBuf = (BYTE *)malloc(0x1000);
    if (screenBuf == NULL)
        {
        printf("\nOut of memory allocating screen buffer");
        return(-1);
        }

   gettextinfo(&textInfo);
   gettext(5, 7, 75, 18, screenBuf);
   attr = (YELLOW + (BLUE << 4));
   win(5, 7, 75, 18, attr);

    gotoxy(1, 1);
    cputs(""
	  ""
	  ""
	  "Ŀ");

    for(index = 2; index <= 10; index++)
    {
        gotoxy(1, index);
  		cputs(""
		    "                       "
		    "                       "
		    "                       "
		    "");
    }
    gotoxy(1, 11);
    cputs(""
          ""
	  ""
	  "");

   gotoxy(27, 2);
   if (operation == EDIT_RECORD)
      cputs("Record to Edit");
   if (operation == READ_RECORD)
      cputs("Record to Read");

   /* Allow the user to input a record key, then make a FindRecordKey */
   /* request. */
   gotoxy(10, 12);
   cputs("Enter Record Key (press <Enter> when finished)");
   gotoxy(3, 4);
   cputs("Record Key:  ");
   textattr(WHITE + (GREEN << 4));
   cputs("                                                      ");
   gotoxy(17, 4);
   inputBuf[0] = 0x3f;
   bufp = cgets(inputBuf);
   strncpy(sendPacket.record.header.key, bufp, 0x3f);
   strcat(sendPacket.record.header.key, "\0");

   /* Now see if we can find the record. */
   /* Initialize ECBs, send header, and send packet for FindRecordKey op */
   sendPacket.responseCode = findResponseCode;
   sendPacket.operation = FIND_RECORD_KEY;

   listenECB.ESRAddress = sendECB.ESRAddress = NULL;
   listenECB.socket = sendECB.socket = ENGINE_SOCKET;
   listenECB.fragCount = sendECB.fragCount = 0x02;
   listenHeader.packetType = sendHeader.packetType = 0x04;

   /* Obtain the address of the nearest router which knows the */
   /* path to the engine. */

   ccode = IPXGetLocalTarget(serverAddress,
                             sendECB.immediateAddress,
                             &transportTime);

   /* IPXGetDataAddress constructs a FAR pointer to the first */
   /* operand and initializes the second operand with that */
   /* FAR pointer. */

   IPXGetDataAddress((BYTE *)&sendHeader,
                     (WORD *)&sendECB.fragList[0].fragAddress);
   sendECB.fragList[0].fragSize = sizeof(IPX_HEADER);
   IPXGetDataAddress((BYTE *)&sendPacket,
                     (WORD *)&sendECB.fragList[1].fragAddress);
   sendECB.fragList[1].fragSize = sizeof(sPacket);

   memcpy(&sendHeader.destNet, serverAddress, 10);
   sendHeader.destSocket = ENGINE_SOCKET;

   IPXGetDataAddress((BYTE *)&listenHeader,
                     (WORD *)&listenECB.fragList[0].fragAddress);
   listenECB.fragList[0].fragSize = sizeof(IPX_HEADER);
   IPXGetDataAddress((BYTE *)&listenPacket,
                     (WORD *)&listenECB.fragList[1].fragAddress);
   listenECB.fragList[1].fragSize = sizeof(lPacket);


   /* Post ECBs for receiving and sending. */
   IPXListenForPacket(&listenECB);
   IPXSendPacket(&sendECB);


   /* Wait five seconds for a response packet. Allow the user to retry. */
   while(listenECB.inUseFlag)
   {
      c = 0;
      gotoxy(10, 12);
      textattr(YELLOW + (BLUE << 4));
      clreol();
      begin = end = clock();
      while(listenECB.inUseFlag)
      {
         end = clock();
         if (end - begin > CLK_TCK * 5)
         {
            gotoxy(10, 12);
            cputs("Confirmation not received -- enter 'Y' to Retry");
            c = getch();
            break;
         }
      }
      if (c != 'y' && c != 'Y')
         break;
   }
   if (listenECB.inUseFlag ||
        listenPacket.responseCode != findResponseCode ||
        !listenPacket.record.header.status)
   {
      /* We didn't get a response packet. We can only assume */
      /* the engine didn't find the record we requested. */
      /* We can't read, edit, or delete a packet which the */
      /* engine didn't find, so we return with an error code. */

      if(listenECB.inUseFlag)
         IPXCancelEvent(&listenECB);
      gotoxy(10, 12);
      textattr(YELLOW + (BLUE << 4));
      clreol();
      gotoxy(10, 12);
      cputs("Record NOT found -- press any key to continue");
      c = getch();
      textattr(textInfo.attribute);
      puttext(5, 7, 75, 18, screenBuf);
        free(screenBuf);
      return(-1);
   }
   /* We found the record. If the operation is read record or edit */
   /* record, we display the record key and data on the screen. */
   if (operation != DELETE_RECORD)
   {
       textattr(YELLOW + (BLUE << 4));
       gotoxy(3, 6);
       cputs("Record Data: ");
       textattr(WHITE + (GREEN << 4));
        cputs("                                                      ");
       gotoxy(17, 6);
       printf("%s", listenPacket.record.data.data);
   }

   /* If the operation is read record, we skip the following code */
   /* and fall through to the return. Otherwise, we alter */
   /* the received record and send it back to the engine. */
   if (operation == EDIT_RECORD || operation == DELETE_RECORD)
   {
        if (operation == EDIT_RECORD)
        {
         /* If the operation is edit record, we allow the user to */
         /* alter the data field. */

          gotoxy(10, 12);
          textattr(YELLOW + (BLUE << 4));
          clreol();
          cputs("Enter new data field for this record and press <Enter>");
          gotoxy(3, 8);
          cputs("New Data: ");
          gotoxy(16, 8);
          textattr(WHITE + (GREEN << 4));
          cputs("                                                      ");
          gotoxy(17, 8);
          inputBuf[0] = 0x3f;
          bufp = cgets(inputBuf);
          strncpy(listenPacket.record.data.data, bufp, 0x3f);
          strcat(listenPacket.record.data.data, "\0");

          textattr(YELLOW + (BLUE << 4));
          gotoxy(10, 12);
          clreol();
          cputs("Enter 'Y' to accept, any other key to cancel");
          c = getch();
          if (c != 'y' && c != 'Y')
          {
                free(screenBuf);
                return(-1);
          }
      }

      /* If the operation is delete record, we mark the record */
      /* as deleted by changing its status to zero. */
      if (operation == DELETE_RECORD)
            listenPacket.record.header.status = 0;

      /* If the operation is edit record or delete record, */
      /* send the altered record packet back to the engine. */

      /* Now we can recycle the ECBs. This time we use the */
      /* re-constitued listen packet to send back to the server, */
      /* and we use the send packet to receive the confirmation. */

      listenPacket.responseCode = opResponseCode;
      listenPacket.operation = operation;

      IPXGetDataAddress((BYTE *)&listenPacket,
                        (WORD *)&sendECB.fragList[1].fragAddress);
      sendECB.fragList[1].fragSize = sizeof(lPacket);
      IPXGetDataAddress((BYTE *)&sendPacket,
                        (WORD *)&listenECB.fragList[1].fragAddress);
      listenECB.fragList[1].fragSize = sizeof(lPacket);

      IPXListenForPacket(&listenECB);
      IPXSendPacket(&sendECB);

      /* Wait five seconds for a confirmation packet from the engine. */
      /* allow the user to retry. */
      while(listenECB.inUseFlag)
      {
         c = 0;
         gotoxy(10, 12);
         textattr(YELLOW + (BLUE << 4));
         clreol();
         begin = end = clock();
         while(listenECB.inUseFlag)
         {
            end = clock();
            if (end - begin > CLK_TCK * 5)
            {
               gotoxy(10, 12);
               cputs("Confirmation not received -- enter 'Y' to Retry");
               c = getch();
               break;
            }
         }
         if (c != 'y' && c != 'Y')
            break;
      }
      if (listenECB.inUseFlag || listenPacket.responseCode != opResponseCode)
      {
         /* Either we DID NOT receive a confirmation packet, or */
         /* we received a confirmation packet with a bad response code. */
         /* We can only infer that the record was not updated. */

         if(listenECB.inUseFlag)
            IPXCancelEvent(&listenECB);
         gotoxy(10, 12);
          textattr(YELLOW + (BLUE << 4));
         clreol();
         gotoxy(10, 12);
         cputs("Record NOT updated -- press any key to return");
         c = getch();
         textattr(textInfo.attribute);
         puttext(5, 7, 75, 18, screenBuf);
            free(screenBuf);
         return(-1);
      }
   }
   /* We received a good confirmation packet from the engine. */
   /* indicate success and return. */
   gotoxy(10, 12);
   textattr(YELLOW + (BLUE << 4));
   clreol();
   gotoxy(10, 12);
   if (operation == EDIT_RECORD)
       cputs("Record updated -- press any key to continue");
   if (operation == DELETE_RECORD)
       cputs("Record deleted -- press any key to continue");
   if (operation == READ_RECORD)
       cputs("Press any key to continue");
   c = getch();
   textattr(textInfo.attribute);
   puttext(5, 7, 75, 18, screenBuf);
   free(screenBuf);
   return(0);
}

/**************************************************************************
*  AddRecord
*
*  This function allows the user to create a new record. It prompts for
*  input on the record key and record data fields. It then builds a packet
*  containing a filled-out record and sends that packet to the engine.
*
*  After sending the record packet to the engine, it listens for a response
*  packet from the engine. The response packet contains a record header,
*  from which AddRecord infers that the record was added or that the
*  record was not added because of a duplicate key. If no packet comes
*  in from the engine, or if a packet comes in which has a bad response
*  code, AddRecord infers that the record was NOT added.
*
**************************************************************************/
int AddRecord(void)
{
    IPX_ECB sendECB, listenECB;            // ECBs for sending and receiving
    IPX_HEADER sendHeader, listenHeader;   // IPX headers
    lPacket sendPacket, listenPacket;      // packet buffers
    int ccode, transportTime, index;
    char c, attr, inputBuf[129], *bufp;
    char objectName[49];                   // objectName, objectType, and
    WORD objectType;                       // loginTime are used when
    BYTE loginTime[7];                     // calling GetConnectionInformation
    char *screenBuf;
    struct text_info textInfo;
    clock_t begin, end;                    // used to time out response pkt.
    WORD responseCode = 0x00ff;            // verifies integrity of
                                          // received packets

    screenBuf = (BYTE *)malloc(0x1000);
    if (screenBuf == NULL)
    {
        printf("\nOut of memory allocating screen buffer");
        return(-1);
    }
    gettextinfo(&textInfo);
    gettext(5, 7, 75, 18, screenBuf);
    attr = (YELLOW + (BLUE << 4));
    win(5, 7, 75, 18, attr);
 
    gotoxy(1, 1);
    cputs(""
	""
	""
	""
	"Ŀ");

    for(index = 2; index <= 10; index++)
    {
         gotoxy(1, index);
          cputs( ""
	         "                       "
		 "                       "
                 "                       "
                 "");
     }
     gotoxy(1, 11);
     cputs(""
	""
	""
	""
	"");

    /* Obtain input from the user for this new record. */
    gotoxy(30, 1);
    cputs("Add Record");

    gotoxy(10, 12);
    cputs("Enter Record Key (press <Enter> when finished): ");
    gotoxy(3, 4);
    cputs("Record Key:  ");
    textattr(WHITE + (GREEN << 4));
    cputs("                                                      ");
    gotoxy(17, 4);
    inputBuf[0] = 0x3f;
    bufp = cgets(inputBuf);
    strncpy(sendPacket.record.header.key, bufp, 0x3f);
    strcat(sendPacket.record.header.key, "\0");
   
    textattr(YELLOW + (BLUE << 4));
    gotoxy(10, 12);
    cputs("Enter Record Data (press <Enter> when finished): ");
    gotoxy(3, 6);
    cputs("Record Data: ");
    textattr(WHITE + (GREEN << 4));
    cputs("                                                      ");
    gotoxy(17, 6);
    inputBuf[0] = 0x3f;
    bufp = cgets(inputBuf);
    strncpy(sendPacket.record.data.data, bufp, 0x3f);
    strcat(sendPacket.record.data.data, "\0");

    textattr(YELLOW + (BLUE << 4));
    gotoxy(10, 12);
    cputs("Enter 'Y' to accept this new record, any other key to cancel");
    c = getch();
    if (c != 'y' && c != 'Y')
    {
       textattr(textInfo.attribute);
       puttext(5, 7, 75, 18, screenBuf);
       return(-1);
    }
    /* Now get the rest of the information we need to supply for the record */

    /* GetConnectionInformation gives us our bindery object ID, which */
    /* we place in the objectID field of the new record. */
    ccode = GetConnectionInformation(GetConnectionNumber(),
                                    objectName,
                                    &objectType,
                                    &sendPacket.record.data.objectID,
                                    loginTime);

   /* IPXGetInternetworkAddress provides us with our node address, */
   /* which we place in the nodeAddress field of the new record. */

   IPXGetInternetworkAddress(sendPacket.record.data.nodeAddress);


   /* responseCode helps us verify the integrity of the response packet. */

   sendPacket.responseCode = responseCode;

   /* Insert op code for AddRecord into the send packet. */

   sendPacket.operation = ADD_RECORD;

   /* Set up our listen and send ECBs and post them */

   listenECB.ESRAddress = sendECB.ESRAddress = NULL;
   listenECB.socket = sendECB.socket = ENGINE_SOCKET;
   listenECB.fragCount = sendECB.fragCount = 0x02;
   sendHeader.packetType = 0x04;       // indicates an IPX packet

   /* Obtain the address of the nearest router which knows the */
   /* path to the engine. */
   ccode = IPXGetLocalTarget(serverAddress,
                             sendECB.immediateAddress,
                             &transportTime);

   /* IPXGetDataAddress constructs a FAR pointer to the first */
   /* operand and initializes the second operand with that */
   /* FAR pointer. */

   IPXGetDataAddress((BYTE *)&sendHeader,
                     (WORD *)&sendECB.fragList[0].fragAddress);
   sendECB.fragList[0].fragSize = sizeof(IPX_HEADER);
   IPXGetDataAddress((BYTE *)&sendPacket,
                     (WORD *)&sendECB.fragList[1].fragAddress);
   sendECB.fragList[1].fragSize = sizeof(lPacket);

   /* Initialize the destination address fields for the */
   /* IPX header used to send the packet. */

   memcpy(&sendHeader.destNet, serverAddress, 10);
   sendHeader.destSocket = ENGINE_SOCKET;


   IPXGetDataAddress((BYTE *)&listenHeader,
                     (WORD *)&listenECB.fragList[0].fragAddress);
   listenECB.fragList[0].fragSize = sizeof(IPX_HEADER);
   IPXGetDataAddress((BYTE *)&listenPacket,
                     (WORD *)&listenECB.fragList[1].fragAddress);
   listenECB.fragList[1].fragSize = sizeof(lPacket);

   /* Post the ECBs for receiving and sending */
   IPXListenForPacket(&listenECB);
   IPXSendPacket(&sendECB);

   /* Wait 5 seconds for a response packet from the engine. */
   /* Allow the user to retry. */
   while(listenECB.inUseFlag)
   {
       c = 0;
       gotoxy(10, 12);
       textattr(YELLOW + (BLUE << 4));
       clreol();
       begin = end = clock();
       while(listenECB.inUseFlag)
       {
          end = clock();
          if (end - begin > CLK_TCK * 5)
          {
            gotoxy(10, 12);
            cputs("Confirmation not received -- enter 'Y' to Retry");
            c = getch();
            break;
          }
       }
       if (c != 'y' && c != 'Y')
         break;
    }

    if (listenECB.inUseFlag)
    { 
       /* If we didn't get a response packet from the engine, */
       /* cancel the Receive ECB and return. Record probably */
       /* wasn't added */

        IPXCancelEvent(&listenECB);
        textattr(textInfo.attribute);
        puttext(5, 7, 75, 18, screenBuf);
        free(screenBuf);
       return(-1);
   }
   else
   {
      /* If we did get a response packet from the engine, check */
      /* its integrity and infer whether or not the record was added. */

      gotoxy(10, 10);
      textattr(YELLOW + (BLUE << 4));
      if (listenPacket.responseCode != responseCode)
            cputs("Bad response code in confirmation packet ");
      if (listenPacket.record.header.status == 0x03)
            cputs("Duplicate key -- record NOT added");
      else
            cputs("Record Added!");
    }
    gotoxy(10, 12);
    textattr(YELLOW + (BLUE << 4));
    clreol();
    cputs("Press any key to continue ...");
    c = getch();
    textattr(textInfo.attribute);
    puttext(5, 7, 75, 18, screenBuf);
    free(screenBuf);
    return(0);
}

/**************************************************************************
*  ScanForService
*
*  The ENGINE.NLM advertises itself using the Service Advertising
*  Protocol (SAP). This means we can scan the bindery for advertising
*  engines and read their network address. Once we obtain the network
*  address, we can start a session.
*
*  This routine finds up to four advertising engines. When it finds an
*  advertising engine, it fills out an info node, which the function
*  SelectEngine uses to allow the user to select a specific engine.
*
*  Note: Just because we discover an advertising engine by scanning
*        the bindery does NOT mean that the engine is alive. The engine
*        could have gone down very recently. The InitEngine function
*        verifies an engine is alive by sending a query packet to it
*        and listening for a response.
*
**************************************************************************/
int ScanForService()
{
   int ccode, index = 0;
   LONG objectID = -1;
   char objectName[49];
   WORD objectType;
   char objectHasProperties;
   char objectFlag;
   char objectSecurity;

   BYTE moreSegments;
   BYTE propertyFlags;

   /* Scan for objects of type 0x88. The engine advertises itself */
   /* as an object of type 0x88. */

    ccode = ScanBinderyObject("*",
                                 0x88,
                                 &objectID,
                                 objectName,
                                 &objectType,
                                 &objectHasProperties,
                                 &objectFlag,
                                 &objectSecurity);


   if (ccode)
      return(-1);

   while (!ccode)
   {
        while(index < NUMBER_OF_NODES)
            if (info[index].occupied)
               index++;
            else
               break;
        if (info[index].occupied)
            return(0);

        info[index].occupied = 1;
        strncpy(info[index].serverName, objectName, 49);
        info[index].serverType = objectType;

        /* Read the engine's network address from the bindery. */
        ccode = ReadPropertyValue(info[index].serverName,
                                info[index].serverType,
                                "NET_ADDRESS",
                                1,
                                info[index].engineAddress,
                                &moreSegments,
                                &propertyFlags);

        if (ccode)
             return(0x03);

        /* Continue scanning for more engines, up to four. */
        ccode = ScanBinderyObject("*",
                              0x88,   /* type of server we look for */
                              &objectID,
                              objectName,
                              &objectType,
                              &objectHasProperties,
                              &objectFlag,
                              &objectSecurity);
   }
   return(0);
}

/**************************************************************************
*  SelectEngine
*
*  This routine scans the info nodes for engines discovered by
*  ScanForService. It displays the names of discovered engines and
*  prompts the user to select one of them.
*
**************************************************************************/
int SelectEngine(void)
{
    struct text_info textInfo;
    int index, row, found = 0;
    char c;
    BYTE *screenBuf, attr;

    screenBuf = (BYTE *)malloc(0x1000);
    if (screenBuf == NULL)
    {
        printf("\nOut of memory allocating screen buffer");
        return(-1);
    }
    gettextinfo(&textInfo);
    gettext(5, 7, 75, 18, screenBuf);
    attr = (YELLOW + (BLUE << 4));
    win(5, 7, 75, 18, attr);
    gotoxy(1, 1);
    cputs(""
           ""
           ""
           "Ŀ");

    for(index = 2; index <= 10; index++)
    {
         gotoxy(1, index);
         cputs(""
               "                     "
               "                     "
               "                     "
               ""
     }
     gotoxy(1, 11);
     cputs(""
            ""
            ""
            "");
     gotoxy(25, 2);
     cputs("Advertising Engines");
     row = 4;
     for(index = 0; index < NUMBER_OF_NODES; index++)
     {
        if (info[index].occupied)
        {
            found++;
            gotoxy(3, row++);
            printf("%i. Engine Name: %s", index + 1,
                        info[index].serverName);
            ++row;
        }
    }
    if (!found)
    {
        free(screenBuf);
        return(0);
    }
    gotoxy(1, 12);
    cputs("Enter Engine Number:");
    c = getch();
    index = (c - 0x30);
    index--;
    textattr(textInfo.attribute);
    puttext(5, 7, 75, 18, screenBuf);

    /* If the user selected a valid engine, copy that engine's network */
    /* address into the global serverAddress variable. */

    if (index < NUMBER_OF_NODES && info[index].occupied)
    {
         memcpy(&serverAddress, &info[index].engineAddress, 12);
         free(screenBuf);
         return(index);
    }
    free(screenBuf);
    return(-1);
}

/**************************************************************************
*  InitEngine
*
*  This function sends a query packet to the engine indicated by the
*  index parameter. (index is an index into the array of info nodes.)
*
*  InitEngine then listens for a response packet from the engine.
*  This serves to verify that the engine is actually up and running.
*
**************************************************************************/
int InitEngine(int index)
{
    IPX_ECB sendECB, listenECB;                // send and receive ECBs
    IPX_HEADER sendHeader, listenHeader;       // IPX headers
    iPacket initPacket;                        // packet buffer
    int transportTime, ccode;
    clock_t begin, end;                        // used to time-out receive ECB

   /* Initialize the send a receive ECBs, and the send header and packet. */

    listenECB.ESRAddress = sendECB.ESRAddress = NULL;
    listenECB.socket = sendECB.socket = INIT_SOCKET;
    listenECB.fragCount = sendECB.fragCount = 0x02;
    sendHeader.packetType = listenHeader.packetType = 0x04; // IPX type
    sendHeader.destSocket = listenHeader.destSocket = INIT_SOCKET;

   /* Get the address of the nearest router which knows the path */
   /* to the engine. */

    ccode = IPXGetLocalTarget(info[index].engineAddress,
                                      sendECB.immediateAddress,
                                      &transportTime);

   /* IPXGetDataAddress constructs a FAR pointer to the first */
   /* operand and initializes the second operand with that */
   /* FAR pointer. */

    IPXGetDataAddress((BYTE *)&sendHeader,
                           (WORD    *)&sendECB.fragList[0].fragAddress);
    sendECB.fragList[0].fragSize = sizeof(IPX_HEADER);
    IPXGetDataAddress((BYTE *)&initPacket,
                            (WORD *)&sendECB.fragList[1].fragAddress);
    sendECB.fragList[1].fragSize = sizeof(iPacket);


    IPXGetDataAddress((BYTE *)&listenHeader,
                           (WORD    *)&listenECB.fragList[0].fragAddress);
    listenECB.fragList[0].fragSize = sizeof(IPX_HEADER);
    IPXGetDataAddress((BYTE *)&initPacket,
                            (WORD *)&listenECB.fragList[1].fragAddress);
    listenECB.fragList[1].fragSize = sizeof(iPacket);

   /* Initialize the destination address of the IPX send header */
    memcpy(&sendHeader.destNet, info[index].engineAddress, 10);

   /* Post for receiving and sending */
    IPXListenForPacket(&listenECB);
    IPXSendPacket(&sendECB);

   /* Wait five seconds for a response. */
    if(listenECB.inUseFlag)
    {
        begin = end = clock();
        while (listenECB.inUseFlag)
        {
            end = clock();
            if ((end - begin) > (0x5a))
            {
                cputs("\nNo response from ENGINE");
                break;
            }
        }
    }
    if (listenECB.inUseFlag)
        return(-1);
    return(0);
}

/**************************************************************************
*  menu
*
*  This function allows the user to add, read, edit, and delete records.
*
**************************************************************************/
void menu(void)
{
    int i;
    struct text_info textInfo;
    char c;
    BYTE *screenBuf, attr;
    screenBuf = (BYTE *)malloc(0x1000);
    if (screenBuf == NULL)
    {
        printf("\nOut of memory allocating screen buffer");
        return;
    }
    while(1)
    {
        gettextinfo(&textInfo);
        gettext(25, 5, 55, 15, screenBuf);
        attr = (YELLOW + (BLUE << 4));
        win(25, 5, 55, 15, attr);
        gotoxy(1, 1);
        cputs(""
               "Ŀ");
        for (i = 2; i <= 9; i++)
        {
            gotoxy(1, i);
              cputs("                             ");
        }
        gotoxy(1, 10);
        cputs(""
               "");
        gotoxy(6, 2);
        cputs("Engine Client Menu");
        gotoxy(3, 4);
        cputs("1. Add new record");
        gotoxy(3, 5);
        cputs("2. Edit existing record");
        gotoxy(3, 6);
        cputs("3. Read existing record");
        gotoxy(3, 7);
        cputs("4. Delete existing record");
        gotoxy(3, 8);
        cputs("5. Quit");
        gotoxy(1, 11);
        cputs(" Select a Menu Item by number");

        c = getch();
        switch(c)
        {
            case '1': { AddRecord(); break;}
            case '2': { GetRecord(EDIT_RECORD); break; }
            case '3': { GetRecord(READ_RECORD); break; }
            case '4': { GetRecord(DELETE_RECORD); break; }
            case '5':
            {
                textattr(textInfo.attribute);
                puttext(25, 5, 55, 15, screenBuf);
                free(screenBuf);
                return;
            }
            default: break;
        }
    }
}
/****************************************************************/
int main()
{

    struct text_info textInfo;
    char c;
    BYTE *screenBuf, attr;
    WORD engineSocket = ENGINE_SOCKET;
    WORD initSocket = INIT_SOCKET;
    int ccode;

   /* Ensure IPX is loaded and obtain the address of the IPX entry */
   /* point. The NetWare C Interface for DOS maintains a global */
   /* variable calls IPXLocation which is initialized by this call. */
    ccode = IPXInitialize();
    if (ccode)
        {
        printf("\nIPX not loaded--load IPX and try again");
        return(ccode);
        }

   /* Open our sockets. */
    ccode = IPXOpenSocket(&engineSocket, 0x00);
    ccode = IPXOpenSocket(&initSocket, 0x00);

    screenBuf = (BYTE *)malloc(0x1000);
    if (screenBuf == NULL)
    {
        printf("\nOut of memory allocating screen buffer");
        return(-1);
    }
    gettextinfo(&textInfo);
    gettext(1, 1, 80, 25, screenBuf);

    ccode = ScanForService();
    if (ccode)
    {
        printf("\n No Advertising Engines found");
        return(-1);
    }

    while(ccode = SelectEngine() == -1);

    ccode = InitEngine(ccode);
    if (ccode)
    {
         puttext(1, 1, 80, 25, screenBuf);
         free(screenBuf);
         return(-1);
     }
     menu();
     puttext(1, 1, 80, 25, screenBuf);
     free(screenBuf);
     return(0);
}

