/*****************************************************************
| 
|    CONFIG.H  -- this is the master configuration file
|
+-----------------------------------------------------------------
|
|    This contains #defines that configure the test harness code
|    for different environments and compilers (e.g. TURBO_C,
|    MSOFT_C7, LIGHTSPEED_C, etc).  See READ.ME for more info.
|
|    Some systems allow command-line #defines, others have IDEs
|    with PRJ files, others have flavors of Make utilities. This
|    file replaces all those mechanisms with a single text file.
|    A bit cumbersome, but more maintainable across platforms.
| 
|    The original version of this code ran on MAC, SUN, and PC platforms.
|    Recent small modifications to the code may require back-tweaking
|    to run on the Macintosh or Sun. The changes made since the 
|    original version have to do with portability, generality, 
|    clarity and configurability. Porting the code back to the 
|    Mac and Sun should be trivial,  an order of magnitude less effort 
|    than coming up with a recognizer and/or harness.
|
+*****************************************************************/

/****************************************************************
|
| PLATFORM-INDEPENDENT OPTIONS
|
| REDUCED_DATA_SET: For preliminary testing, will configure harness
|                   to process only part of the character set.
|
+****************************************************************/

#define REDUCED_DATA_SET


/****************************************************************
| COMPILER -- for now, #define either TURBO_C or MSOFT_C7.
|       The LightspeedC version is the original, but recent
|       modifications may require tweaking of this version.
|       All changes should be trivial.
|       The basic version has been run on MAC, SUN, and PC platforms.
+****************************************************************/

/*#define INTEL_C32*/
#define TURBO_C
/*#define MSOFT_C7*/
/*#define LIGHTSPEED_C*/

/****************************************************************
| PLATFORM -- for now, only MS_DOS has been tested with this
|       exact version of the code. See comments at the top of
|       this file. The original code ran on MAC and SUN.
|       A Windows version is in the works.
+****************************************************************/

#define MS_DOS
/*#define MACINTOSH*/
/*#define SUN */
/*#define WINDOWS */


/****************************************************************
| PLATFORM-DEPENDENT OPTIONS
|
| 1. Incremental I/O -- the Mac version did not use incremental IO, 
|    but instead read everything in one gulp. On the PC platform, 
|    unfortunately, we cannot do such large reads(), and have to
|    read things a byte or word at a time, using buffered i/o lib.
|
+**************************************************************/

/****************************************************************
| MACINTOSH --- subordinate #defines that depend on MACINTOSH
+****************************************************************/
#ifdef MACINTOSH
#undef USE_INCREMENTAL_IO
#endif

/****************************************************************
| MICROSOFT C -- subordinate #defines that depend on MSOFT_C7
+**************************************************************/
#ifdef MSOFT_C7
#define USE_INCREMENTAL_IO
#endif

/****************************************************************
| TURBO C -- subordinate #defines that depend on Borland's TURBO_C
+**************************************************************/

#ifdef TURBO_C
#define USE_INCREMENTAL_IO
#endif

/****************************************************************
| INTEL C -- subordinate #defines that depend on Intel's CodeBuilder
+**************************************************************/

#ifdef INTEL_C32
#define USE_INCREMENTAL_IO
#endif

/****************************************************END*********/

