#-------------------------------------------------------------------
# Makefile for DDJ RECOGNITION CONTEST TEST HARNESS
#
#    TURBO_C.MAK -- Turbo C++ for DOS V1.01 and V3.0
#
# ------------------------------------------------------------------
#    There is an accompanying file TURBO_C.LNK that has a hardwired
#    path name for the library directory. You should modify this
#    accordingly. See DDJ_HWX.DOC for more information.
#-------------------------------------------------------------------

all : harness.exe 

OBJ_FILES = h_main.obj recog.obj h_mem.obj 

#-------------------------------------------------------------------
#  DIRECTORY PATHNAME FOR COMPILER (you should modify this accordingly)
#  ***See also the hardwired names in file TURBO_C.LNK!!
#-------------------------------------------------------------------
DIRECTORY=F:\USERS\RVALDES\TC3_0
#DIRECTORY=K:\TC_DOS

#-------------------------------------------------------------------
#  Memory Model
#  If this is changed, make sure that the corresponding libraries
#  are changed in TURBO_C.LNK
#-------------------------------------------------------------------
MODEL = l

#-------------------------------------------------------------------
# DEFINES -- No defines here! Instead, they are in H_CONFIG.H
#-------------------------------------------------------------------
# DEFINES= -DTURBO_C -DDEBUG_TRACE

#------------------------------------------------
# DEBUG FLAGS
#    Note: Delete the DEBUG and LINKDEBUG macros to 
#    build without debugging information in the .EXE
#    Alternatively, use Borland's TDSTRIP utility to
#    remove symbols from EXE file.
#------------------------------------------------
DEBUG = -v
LINKDEBUG = /m /v

#------------------------------------------------
# COMPILE
#------------------------------------------------
COMPILE = $(DIRECTORY)\bin\tcc $(DEBUG) -c -d -m$(MODEL)
LINK= tlink $(LINKDEBUG) $(DIRECTORY)\lib\c0$(MODEL) 

#------------------------------------------------
# LIBRARIES -- are now in TURBO_C.LNK
#------------------------------------------------
#LIBDIR=$(DIRECTORY)\lib\
#LIBS= $(LIBDIR)c$(MODEL) $(LIBDIR)math$(MODEL) $(LIBDIR)emu

#------------------------------------------------

.c.obj:
    $(COMPILE) $*.c

harness.exe : h_config.h $(OBJ_FILES)
    $(LINK) @turbo_c.lnk
