/* -------------------- header file for detags.c ------------------------ */

#define GOOD 0                    /* Exit codes for success and failure.  */
#define BAD  1

#define	reg	register

#define TRUE  (1)
#define FALSE (0)

#define MAXCMD 100

#define iswhite(arg)  (_wht[arg])                   /* T if char is white */
#define begtoken(arg) (_btk[arg])            /* T if char can start token */
#define intoken(arg)  (_itk[arg])            /* T if char can be in token */
#define endtoken(arg) (_etk[arg])                /* T if char ends tokens */
#define isgood(arg)   (_gd[arg])            /* T if char can be after ')' */

#define max(a,b)  ((a) > (b) ? (a) : (b))

/*
 /  cause token checking for typedef, struct, union, and
 /  enum to distinguish keywords from identifier-prefixes
 /  (e.g. struct vs struct_tag).
 */

#define istoken(s, tok, len) (!strncmp(s,tok,len) && endtoken(*((s)+(len))))

typedef struct nd_st {                               /* sorting structure */
    char *name;                                  /* function or type name */
    char *file;                                              /* file name */
    char f;                                     /* use pattern or line no */
    int  lno;                                    /* line number tag is on */
    long cno;                          /* character number line starts on */
    char *pat;                                          /* search pattern */
    char been_warned;                               /* set if noticed dup */
    struct nd_st *left, *right;                    /* left and right sons */
} NODE;

int number;  /* tokens found so far on line starting with # (including #) */

char gotone;                              /* found a func already on line */

char _wht[0177],                             /* boolean "func" (see init) */
     _etk[0177],
     _itk[0177],
     _btk[0177],
     _gd[0177];

/*
 /  typedefs are recognized using a simple finite
 /  automata, tydef is its state variable.
 */

typedef enum    {
    none,
    begin,
    tag_ok,
    middle,
    end
} TYST;

TYST tydef = none;

char searchar = '/';                                /* use /.../ searches */
int  lineno;                               /* line number of current line */
long charno;                                  /* current character number */
long linecharno;                     /* character number of start of line */

char *curfile,                                 /* current input file name */
     *outfile = 0,                                         /* output file */
     *white = "\040\f\t\n\r",                         /* white characters */
                                                    /* token ending chars */
     *endtk = "\040\t\n\r\"'#()[]{}=-+%*/&|^~!<>;,.:?",
                                                  /* token starting chars */
     *begtk = "ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz",
                                                  /* valid in-token chars */
     *intk = "ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz0123456789",
     *notgd = ",;";                     /* non-valid after-function chars */

int file_num = 1;                                  /* current file number */
int aflag = 0;                                      /* -a: append to tags */
int tflag = 0;                            /* -t: create tags for typedefs */
int uflag = 0;                                         /* -u: update tags */
int wflag = 0;                                   /* -w: suppress warnings */
int vflag = 0;                    /* -v: create vgrind style index output */
int xflag = 0;                           /* -x: create cxref style output */
int eflag = 1;                                  /* -e: emacs style output */

char *progname;                                  /* Name of this program. */

FILE *inf,                                /* ioptr for current input file */
     *outf;                                        /* ioptr for tags file */

NODE *head;                       /* the head of the sorted binary tree   */

/*
 /  A `struct linebuffer' is a structure which holds a line of text.
 /  `readline' reads a line from a stream into a linebuffer and
 /  works regardless of the length of the line.
 */

typedef struct linebuffer {
    long  size;
    char *buffer;
} LB;

LB lb, lb1;

extern char **glob_filename(char *);

#ifdef __STDC__
# define PROTO(s) s
#else
# define PROTO(s) ()
#endif


/* etags.c */
void main PROTO((int argc , char **argv ));
void usage PROTO((void ));
void init PROTO((void ));
void find_entries PROTO((char *file ));
void pfnote PROTO((char *name , int f , char *linestart , int linelen , int lno , long cno ));
void free_tree PROTO((NODE *node ));
void add_node PROTO((NODE *node , NODE *cur_node ));
void put_entries PROTO((reg NODE *node ));
int total_size_of_entries PROTO((reg NODE *node ));
void C_entries PROTO((void ));
int consider_token PROTO((char **lpp , char *token , int *f , int level ));
void getline PROTO((long atchar ));
int PF_funcs PROTO((FILE *fi ));
int tail PROTO((char *cp ));
void takeprec PROTO((void ));
void getit PROTO((void ));
void L_funcs PROTO((FILE *fi ));
void L_getit PROTO((void ));
void Scheme_funcs PROTO((FILE *fi ));
int TEX_funcs PROTO((FILE *fi ));
int TEX_mode PROTO((FILE *f ));
struct TEX_tabent *TEX_decode_env PROTO((char *evarname , char *defenv ));
void TEX_getit PROTO((char *name , int len ));
int TEX_Token PROTO((char *cp ));
void initbuffer PROTO((LB *linebuffer ));
long readline PROTO((LB *linebuffer , reg FILE *stream ));
char *savestr PROTO((char *cp ));
char *savenstr PROTO((char *cp , int len ));
void fatal PROTO((char *s1 , char *s2 ));
void error PROTO((char *s1 , char *s2 ));
char *concat PROTO((char *s1 , char *s2 , char *s3 ));
int xmalloc PROTO((int size ));
int xrealloc PROTO((char *ptr , int size ));

#undef PROTO
