/*  mdump.c     -- dump a Minix file system */
/*  Copyright 1988,1991 Steven W. Harrold - All rights reserved. */
/*  $Header: MDUMP.C_V 1.6 91/03/22 07:53:57 SWH Exp $ */

#include    <stdio.h>
#include    <string.h>
#include    <ctype.h>
#include    <time.h>
#include    "mfs.h"
#include    "dev.h"

PRINT_HEX_BUF
READ_BLOCK
DEVINIT


/*==================================================================*/
main (argc, argv)
int     argc ;
char    *argv[] ;
{
    int     drive ;
    char    drid = 'A' ;
    char    *dp = DRIVES ;

    byte    buf[BLOCK_SIZE] ;
    int     blkno ;
    struct super_block  sblk ;
    int     i, j, k, n ;
    int     iblkcnt ;
    int     inode_blkno ;
    int     ifree, zfree ;
    char    c ;
    struct inode    iblk ;
    struct directory    dblk, *dptr ;
    int     nument ;
    struct devdata *ddata ;

    printf ("**** Displays structure of a Minix file system ****\n") ;
    printf ("\n") ;

/*  Does he want help?
 */
    if ((argc >= 2) && (argv[1][0] == '-') && (argv[1][1] == '?'))
    {
printf ("Copyright 1988,1991 Steven W. Harrold - All rights reserved\n") ;
        printf ("Version %s\n", VERSION) ;
        printf ("Usage:   %s  [drid]\n", argv[0]) ;
        printf ("'drid' is a letter from the set [a-z], default: 'a'\n") ;
        exit (0) ;
    }

/*  Fetch the drive identifier
 */
    if (argc >= 2)
    {
        drid = toupper(argv[1][0]) ;
        if ((drid < 'A') || (drid > 'Z'))
            drid = 'A' ;
    }
    drive = strchr (dp, drid) - dp ;
    ddata = devinit(drive,0) ;
    if (!ddata)
    {
        printf ("Cannot initialize device 0x%02X, Dstatus=%d\n",
                drive, Dstatus) ;
        exit (2) ;
    }

/*  The boot block
 */
    blkno = 0 ;
    read_block (buf, blkno, ddata) ;
    print_hex_buf (buf, blkno, "The boot block") ;

/*  The super block
 */
    blkno = 1 ;
    read_block (buf, blkno, ddata) ;
    print_hex_buf (buf, blkno, "The super block") ;

    memcpy (&sblk, buf, sizeof(sblk)) ;
    printf ("**** Super block (formatted) ****\n") ;
    printf ("Number of inodes.........%9d\n",    sblk.s_ninodes      ) ;
    printf ("Number of zones..........%9d\n",    sblk.s_nzones       ) ;
    printf ("Num inode bitmap blocks..%9d\n",    sblk.s_imap_blocks  ) ;
    printf ("Num zone bitmap blocks...%9d\n",    sblk.s_zmap_blocks  ) ;
    printf ("First data zone..........%9d\n",    sblk.s_firstdatazone) ;
    printf ("Log2 of zone/block sizes.%9d\n",    sblk.s_log_zone_size) ;
    printf ("Maximum file size.......%10ld\n",   sblk.s_max_size     ) ;
    printf ("Magic number.............   0x%04X\n", sblk.s_magic     ) ;

    if ((sblk.s_magic != SUPER_MAGIC)   ||
        (sblk.s_ninodes < 1)            ||
        (sblk.s_nzones < 1)             ||
        (sblk.s_imap_blocks < 1)        ||
        (sblk.s_zmap_blocks < 1)        )
    {
        printf ("++++++++++++++++++++++++++++++++++++++++++++++++\n") ;
        printf ("++++++++ THIS IS NOT A PROPER SUPER BLOCK ++++++\n") ;
        printf ("++++++++++++++++++++++++++++++++++++++++++++++++\n") ;
    }

    printf ("\n") ;

/*  The i-node bitmap blocks
 */
    ifree = 0 ;
    for (i=0; i<sblk.s_imap_blocks; i++)
    {
        blkno++ ;
        read_block (buf, blkno, ddata) ;
        print_hex_buf (buf, blkno, "An i-node bitmap block") ;

        for (j=0; j<BLOCK_SIZE; j++)
        {
            c = buf[j] ;
            if (!(c & 0x01)) ifree++ ;
            if (!(c & 0x02)) ifree++ ;
            if (!(c & 0x04)) ifree++ ;
            if (!(c & 0x08)) ifree++ ;
            if (!(c & 0x10)) ifree++ ;
            if (!(c & 0x20)) ifree++ ;
            if (!(c & 0x40)) ifree++ ;
            if (!(c & 0x80)) ifree++ ;
        }
    }

    printf ("**** I-node bitmap summary ****\n") ;
    printf ("Bitmap blocks    : %5d\n", sblk.s_imap_blocks) ;
    printf ("I-nodes available: %5d\n", ifree) ;
    printf ("Out of a possible: %5d\n", sblk.s_ninodes) ;
    printf ("\n") ;

/*  The zone bitmap blocks
 */
    zfree = 0 ;
    for (i=0; i<sblk.s_zmap_blocks; i++)
    {
        blkno++ ;
        read_block (buf, blkno, ddata) ;
        print_hex_buf (buf, blkno, "A zone bitmap block") ;

        for (j=0; j<BLOCK_SIZE; j++)
        {
            c = buf[j] ;
            if (!(c & 0x01)) zfree++ ;
            if (!(c & 0x02)) zfree++ ;
            if (!(c & 0x04)) zfree++ ;
            if (!(c & 0x08)) zfree++ ;
            if (!(c & 0x10)) zfree++ ;
            if (!(c & 0x20)) zfree++ ;
            if (!(c & 0x40)) zfree++ ;
            if (!(c & 0x80)) zfree++ ;
        }
    }

    printf ("**** Zone bitmap summary ****\n") ;
    printf ("Bitmap blocks    : %5d\n", sblk.s_zmap_blocks) ;
    printf ("Zones available  : %5d\n", zfree) ;
    printf ("Out of a possible: %5d\n", sblk.s_nzones) ;
    printf ("\n") ;

/*  The i-node blocks
 */
    inode_blkno = blkno + 1 ;
    iblkcnt = sblk.s_ninodes * sizeof(struct inode) + (BLOCK_SIZE-1) ;
    iblkcnt /= BLOCK_SIZE ;
    for (i=0; i<iblkcnt; i++)
    {
        blkno++ ;
        read_block (buf, blkno, ddata) ;
        print_hex_buf (buf, blkno, "An i-node block") ;
    }

    printf ("**** I-node summary ****\n") ;
    printf ("I-node blocks: %5d\n", iblkcnt) ;
    printf ("\n") ;

/*  The root directory
 */
    blkno = inode_blkno ;
    read_block (buf, blkno, ddata) ;

    memcpy (&iblk, buf, sizeof(iblk)) ;
    printf ("**** Root directory inode data (formatted) ***\n") ;
    printf ("Mode...........%06o\n",  iblk.i_mode   ) ;
    printf ("Owner code.....%6d\n",   iblk.i_uid    ) ;
    printf ("File size...%9ld\n",     iblk.i_size   ) ;
    printf ("Last modified..%s",      ctime((long *)&iblk.i_modtime));
    printf ("Group code.....%6d\n",   iblk.i_gid    ) ;
    printf ("Links..........%6d\n",   iblk.i_nlinks ) ;
    for( i = 0; i < ZONE_SIZE; i++ )
        printf( "Zone %1d pointer.%6d\n", i, iblk.i_zone[i] );
    printf ("Indirect zone..%6d\n",   iblk.i_ind    ) ;
    printf ("Double indirect%6d\n",   iblk.i_dbl_ind) ;
    printf ("\n") ;

    for (i=0; i < ZONE_SIZE; i++)
    {
        if ((blkno = iblk.i_zone[i])) /*assignok*/
        {
            read_block (buf, blkno, ddata) ;
            print_hex_buf (buf, blkno, "A root directory block") ;

            printf ("**** Root directory and inode data (formatted) ****\n") ;
            nument = iblk.i_size / sizeof(dblk) ;
            dptr = (struct directory *)buf ;
            for (i=0; i<nument; i++)
            {
                if (n = dptr[i].d_inum) /*assignok*/
                {
                    printf ("inode=%5d  fname=", n) ;
                    for (j=0; (j<NAME_SIZE) && (c=dptr[i].d_name[j]);
                              j++)              /*assignok*/
                        printf ("%c", c) ;
                    printf ("\n") ;
                }
            }
            printf ("\n") ;
        }
    }

} /* main() */


/*---eof---*/
