/*  mshent.c    -- show an entry from a Minix file directory */
/*  Copyright 1988,1991 Steven W. Harrold - All rights reserved. */
/*  $Header: MSHENT.C_V 1.3 91/03/19 13:23:33 SWH Exp $ */

#include    <stdio.h>
#include    <string.h>
#include    <time.h>
#include    "mfs.h"


/*==================================================================*/
void show_ent (iarea, dp)
struct inode        *iarea ;
struct directory    *dp ;
{
    int         i, j, k, n ;
    struct inode    *ip ;
    char        c, decode[11] ;
    ushort      mode ;
    struct tm   *tp ;

    strcpy (decode, "----------") ;

    if (!(n = dp->d_inum)) /*assignok*/
        return ;
    ip = &iarea[n] ;

/*  Decode the first character of permissions string
 */
    if (!(ip->i_mode & I_REGULAR))
    {
        mode = ip->i_mode & I_TYPE ;
        if (mode == I_BLOCK_SPECIAL)
            decode[0] = 'b' ;
        else if (mode == I_DIRECTORY)
            decode[0] = 'd' ;
        else if (mode == I_CHAR_SPECIAL)
            decode[0] = 'c' ;
        else
            decode[0] = '?' ;
    }

/*  Decode the rwx permissions
 */
    mode = ip->i_mode & RWX_MODES ;

    for (i=2; i>=0; i--, mode>>3)
    {
        if (mode & R_BIT)
            decode[3*i+1] = 'r' ;
        if (mode & W_BIT)
            decode[3*i+2] = 'w' ;
        if (mode & X_BIT)
            decode[3*i+3] = 'x' ;
    }

    if (ip->i_mode & I_SET_UID_BIT)
    {
        if (decode[3] == 'x')
            decode[3] = 's' ;
        else
            decode[3] = 'S' ;
    }

    if (ip->i_mode & I_SET_GID_BIT)
    {
        if (decode[6] == 'x')
            decode[6] = 's' ;
        else
            decode[6] = 'S' ;
    }

    printf ("%s ", decode) ;

/*  Supply numerical info from the inode
 */
    printf ("%3uL %5dI %3uU %3uG %9lu ", (ushort)ip->i_nlinks, n,
                                         ip->i_uid, ip->i_gid,
                                         ip->i_size ) ;

/*  Display timestamp of last modification
 */
    tp = localtime (&(ip->i_modtime)) ;
    printf ("%02d/%02d/%02d %02d:%02d:%02d  ", tp->tm_year,
                                               tp->tm_mon+1,
                                               tp->tm_mday,
                                               tp->tm_hour,
                                               tp->tm_min,
                                               tp->tm_sec );

/*  Display the unadorned filename
 */
    for (i=0; (i<NAME_SIZE) && (c=dp->d_name[i]); i++) /*assignok*/
        printf ("%c", c) ;
    printf ("\n") ;

} /* show_ent() */


/*---eof---*/
