;       TIMEPRK7.ASM	Version 3.70 *** 11 JUN 90 *** T.D. Cobb
;------------------------------------------------------------------------------
PAGE 60,132
;
;       Assembles Under Tubro Asm Ver 1.0 
;
;       This TSR uses 73% Less Resident Memory (364% more efficient)
;       (176 bytes verses 640) Than Mr. Zelkovitz's Vers 1.1
;	Uses 32 bytes more if equated to save stack space (This should not
;	be needed.)
;
; ******************************************************************************
; * Assembled Vers 3.7 HAS to be Converted to a binary file with EXE2BIN.EXE   *
; * Before it can be load from CONFIG.SYS. (TIMEPARK.SYS already is)           *
; *           TIMEPARK.SYS HAS LOADED as a Device Driver                       *
; *                  DEVICE=TIMEPARK.SYS /Tn /S                                *
; * /Tn is Optional. Where "n" is 1 to 9 minutes & will reduce Display Message *   
; * /S is Optional.  This will totally suppress all of the Display Message.    *
; ******************************************************************************
;
;       Version 3 Should not lockup the keyboard on none XT class
;       Machines Like My Pervious Vers 2 or Mr. Zelkovitz's Vers 1.
;
;	Version 3.4 User can chose between Seek or Verify. It looks
;	like some Cache's Do Not Seek if the track is already in cache.
;	I would set "SEEK equ TRUE" if not using a Cache.
;
;	Version 3.6 fixed floppy drive hang problem.
;
;	Version 3.7 Put TSR in Device Drivers Clothing.
;
;       Use and Enjoy and pass this on.
;
;                                               Tom Cobb
;                                               130 Janice Dr.
;                                               Athens, Ga 30606
;                                               (404)543-8017
;
;The ARCHED distribution contains the following files:
;
;    1) TIMPARK1.ASM     The assembly source
;    2) TIMEPARK.COM     The load module
;    3) TIMEPARK.DOC     Original miserable manual
;    4) TIMEPRK7.ASM     this Assemble source
;    5) TIMEPRK7.SYS     this Assembled source load module
;
;This software is placed in the PUBLIC DOMAIN to be used for NON-COMMERCIAL
;purposes only. You may  freely copy  and  use  it  without  any charge.
;       
;This program  must not be sold for profit. An adaequate fee may be
;requested for  copying, shipping  and handling when redistributing
;this program.
;
;Also, all five files MUST be passed on.
;
;The software is supplied AS IS and absolutely NO guarantees are given or
;implied about its suitability.
;
;
;  Parts of this source code where written and placed in PUBLIC DOMAIN by
;
;                       ALPHA COMPUTER SERVICE
;                      ( Sanford J. Zelkovitz )
;                            714-894-6808
;
;			Christoph H. Hochsttter
;			Carl-Strehl-Strasse 20
;			D-3550 Marburg
;			West-Germany
;
;
; Vers 2.06
;       Worked on XT class machines. Used 208 Bytes Resident Memory
;
; Vers 3.00
;       Changed verifys to seeks when parking drives
;       Now parks on park cyl if roll over from lower 8 bits of Seek cyl
;       Now enables interrupt Controller Chip so no keyboard lockup
;       Changed TSR org Address so Code is on even memory boundary
;
; Vers 3.40
;       Changed Int 1C so as not to Reenter it's self and
;       Keep Better System Time
;	Setup equate to chose between Seeks and Verifies
;	Removed redundant park code
;
; Vers 3.50
;	Moved test for already parked to front of TST code
;
; Vers 3.60
;	Trap park code out while in Int 13
;
; Vers 3.70
;	Placed TSR routine in Device driver form
;	Setup equate to Save Caller Registers while parking drives
;
;------------------------------------------------------------------------------
;
;       *************************
;       these are general equates
;       *************************
FALSE   EQU     0                       ; define logical values
TRUE    EQU     NOT FALSE

	;*************************
SEEKS	EQU	FALSE   	;*		; Set false for some Caches 
	;*************************		; SET True when No Cache in use
						; by System

sav_stack	EQU	false			; If true uses 32 bytes more
	;  bytes of memory and takes some work off the stack while parking 
	;  drives. This is something to try if you are sure this TSR is
	;  hanging system. 
	;  
						

default_time	EQU	'3'			; Number of minutes delay to 
						;  before parking if
						;  no "/Tn" Option used.
;
;       ------------- Program Output Messages -------------
;
;       Some non-display ASCII character values
CR      EQU     0DH             ; ASCII Carriage Return
LF      EQU     0AH             ; Line Feed
BEL     EQU     07H
;       Graphics characters for borders on the displays
V_BAR   EQU     0BAH
H_BAR   EQU     0CDH
U_LEFT  EQU     0C9H
U_RIGHT EQU     0BBH
L_LEFT  EQU     0C8H
L_RIGHT EQU     0BCH
TOP_T   EQU     0CBH
BOT_T   EQU     0CAH
;

; ------------  Our Flag Equates

parked_flag	 	        equ     0
;not_parked_flag 		equ     not parked_flag
;out_of_our_code_flag		equ	0
in_our_code_flag  		equ     1
in_int13_flag			equ	80h

Cseg            segment word public 'derice_dvr'
                assume  cs:Cseg, ds:Cseg, es:nothing, ss:nothing

;==============================================================================

		org	0

;------------------------------------------------------------------------------
resident_park   proc    far

		dd        -1				; No other device drivers
		dw        1000000000000000b		; Character-Device
stra		dw        strategy			; Strategy-Routine
entr		dw        entry				; Interrupt-Routine
		db        '&TPARK37'			; Dummy-Name

error		proc      far
		mov       word ptr es:[bx+3],8103h            ; Return ERROR status 
		retf                                          ; if called twice 
error		endp					      ; by this Dummy-Device

;------------------------------------------------------------------------------
;	if	sav_stack
	even							; make next address even
;	endif
count           dw      0                    		; time delay counter

;==============================================================================

Ourint1c	proc    far
	if	sav_stack
		mov	word ptr cs:ax_sav,ax
	else
		push	ax
	endif
		xor	al,al

	        cmp	al,0ffh				
parked		equ	$-1			; parked when set to zero
                jz      by_pass                 ; jmp if all ready parked

                dec     word ptr cs:count	; decrement time counter
                jns     by_pass                 ; now jmp if time left on counter

	        cmp     al,0
busy		equ	$-1
                jnz     by_pass                 ; JMP so as not to
                                                ; reenter our code and 
						; don't park while int13 busy

;       park both Hard drives

	if 	sav_stack
                or	byte ptr cs:busy,in_our_code_flag  		
					        ; Set to not Zero when
						; in our park code
	sti
		mov	word ptr cs:ds_sav,ds	; save regs to local area
;		mov	word ptr cs:ax_sav,ax
		mov	ax,cs
		mov	ds,ax
		mov	word ptr cx_sav,cx
		mov	word ptr bx_sav,bx
		mov	word ptr dx_sav,dx
		mov	word ptr si_sav,si
else
                push    ds			; save caller DS reg
	sti
		push	cs
		pop	ds			;ds = this seg

                or	byte ptr busy,in_our_code_flag  		
					        ; Set to not Zero when
						; in our park code
                push    cx
                push    bx                      ; save regs
                push    dx
		push	si

	endif

	cli
                mov     al,20h                  ; Enable interrupt
		out     20h,al                  ; Controller chip
	sti
		mov	si,80h			; first hard disk 

parkloop:       mov     ah,08
                mov     dx,si
                int     13h                     ; get max cyl of hard disk

                mov     dx,si
                inc     ch
                jnc     less_512_cys_0
                add     cl,40h                  ; adjust upper 2 bits of cyl
                                                ;  in bits 6-7
less_512_cys_0:
	if	seeks
		mov     ax,0c01h		; go Verify sec on max cyl +1	
	else
                mov     ax,0401h		; go seek to max cyl + 1
        endif
	        int     13h                     ; (park cyl)

		inc	si
		cmp	si,82h			; (84h would park 4 drives) 			
		jb	parkloop                ; park both C & D drives                              


	if	sav_stack			; Use Local space to store
		mov	cx,0			;  user regs while parking
cx_sav		equ	$-2
		mov	bx,0
bx_sav		equ	$-2
		mov	dx,0
dx_sav		equ	$-2
		mov	si,0
si_sav		equ	$-2

                xor     al,al
                mov     byte ptr parked,al               ; mark as parked
                mov     byte ptr busy,al	         ; mark as out of Our park code

		mov	ax,0
ds_sav		equ	$-2
		mov	ds,ax
by_pass:                                         ; goto real int1C
		mov	ax,0
ax_sav		equ	$-2
	else	
		pop	si			; restore user regs after parking
                pop     dx			;  drives
                pop     bx
                pop     cx

                xor     al,al
                mov     byte ptr parked,al               ; mark as parked
                mov     byte ptr busy,al	         ; mark as out of Our park code

		pop     ds
by_pass:                                         ; goto real int1C
		pop	ax
	endif
	cli	
;	        jmp     OldInt1c
		db	0EAh		; far jmp
OldInt1COff     dw	0
OldInt1CSeg     dw	0
Ourint1c	endp

even							; make next address even

Ourint13	proc    far
		assume ds:nothing, es:nothing, ss:nothing

	sti
                test    dl,80h          ; Msb set if Hard
                jz      floppy

                push    ax
                mov     ax,07fffh
value		equ	$-2		; time delay value for reload	
                mov     word ptr count,ax

                mov     byte ptr parked,ah	; mark not parked (none zero)
                pop     ax
floppy:

	; MARK when in Int13 calls so we know when it's safe to park drives
 
		or	byte ptr busy,in_int13_flag	;(none zero)

		pushf			; setup to fake int13
	cli				; enable interrupts

;               call     OldInt13		 ;goto real int13
		db	09Ah		; Far Call 
OldInt13Off     dw	0
OldInt13Seg     dw	0

		and	byte ptr busy,not in_int13_flag
		ret	2
Ourint13	endp

resident_park   endp

tsr_end         equ     $

;=======================================================================
TsrCurtain      equ     $
;=======================================================================

savreq		label     dword                               
savreq_o	dw        ?		;...Save the ...
savreq_s	dw        ?             ;...Request Headers

strategy	proc      far                   ;Strategy-Routine
		mov       cs:[savreq_o],bx	; BX saved
		mov       cs:[savreq_s],es      ; ES saved
		ret                                           
strategy	endp

entry		proc      far		; Entry to Device Driver Routines 
		assume    cs:cseg

		push      ax		; All Register and Flags saved
		push      cx
		push      dx
		push      di
		push      si
		push      ds
		push      es
		push      bx
		pushf
		les       bx,cs:[savreq] ; load Request-Header pointer
		mov       al,es:[bx+2]  ; Get command code from header
		cmp       al,0          ; Is it Init command code (0)
		jnz       unkwn_com     ; No, then return with Error
		jmp       short init	; Go do (TSR) Code Initialization
entry		endp

rout		proc      far
exit1:		mov       ax,100h	; (Done) status
jmp		short exgem
unkwn_com:	mov       ax,8103h	; (ERROR DONE UNKNOWN-COMMAND) status
exgem:		mov       es:[bx+3],ax	; Place status word in request header	
		popf			; All Register Restored
		pop       bx
		pop       es
		pop       ds
		pop       si
		pop       di
		pop       dx
		pop       cx
		pop       ax
		ret
rout		endp			; return to device caller

Get_next_char	proc	near
Dumpit:		lodsb
		cmp	al,0Dh		; cr or lf?
		jbe	ajust_stack	; yes
		cmp	al,20h		; less than space?
		jbe	Dumpit		; yes, ignore
		ret
		
ajust_stack:	pop	ds		; clear return address
		jmp	Line_end	; end of command line
Get_next_char	endp

Init            proc    near
                assume  cs:Cseg, ds:Cseg

		xor	cx,cx		; used to save config.sys options
	
		push	ds		; save our ds pointer
		lds	si,es:[bx+dword ptr 12h] ;get ds:si=ptr config.sys options

Scanname:	lodsb			; scan to end of name
		cmp	al,0Dh		; end of line?
		je	Line_end	; yes, no options, use default
		cmp	al,20h		; end of driver name?
		ja	Scanname	; no

parc		proc	near
		call	Get_next_char
		cmp	al,'/'
		jne	parc

		call	Get_next_char
		and	al,0dfh		; Make upper case
		cmp	al,'S'		
		jne	test_4_T	; /S
		not	ch		; Mark to surpress output Message
		jmp	parc

test_4_T:	cmp	al,'T'
		jne	parc		; /T
		call	Get_next_char
		cmp	al,'1'		
		jb	parc		; Greater than /T0
		cmp	al,'9'
		ja	parc		; Less than /T:
		mov	cl,al
		jmp	parc
parc		endp

Line_end:
		mov	al,default_time
		or	cl,cl		; zero if not valid park time
		jz	default		; if zero use default
		mov	al,cl		; use valid time
default:	

good_time:	pop	ds		; restore our seg to DS
		cmp     al,'1'		
                je      nochangemsg

                mov     timemsg,al	; fix message if not 1 minute
                mov     smsg,'s'

nochangemsg:
                and     ax,0fh		; change ansi to bin
                mov     dx,1091		; 1 second of ticks
                mul     dx
                mov     word ptr value,ax ; save for loading 
                mov     count,ax	; load count down counter

; ------------  DISLAY MSG ABOUT HOW WELL THIS IS ALL RUNNING
		
		or	ch,ch			; test for display suppression
		jnz	no_mesg
		
                mov     dx,offset BannerMsg	; display banner
                mov     ah,9
                int     21h 

		or	cl,cl
		jnz	no_default_mesg

                mov     dx,offset DefaultMsg	; Using default message
                mov     ah,9
                int     21h

no_default_mesg:
                mov     dx,offset ParkMsg	; display park message
                mov     ah,9
                int     21h 
no_mesg:
;-------------
	; setup return ofAddress of first free memory above driver

		mov	word ptr es:[bx+16],cs			
		mov	word ptr es:[bx+14],offset tsr_end	

	; This will dummy the device driver to return  error if called.
	;  (Our TSR is never Called)  							

		mov	word ptr [stra],offset error		
		mov	word ptr [entr],offset error		

; ------------  SAVE VECTORS FOR OUR MONITOR INTERRUPTS

		push	es			;save our es

	; Setup to work on Interrupt vectors (SEG 0000) 
	; Can't use Int21h calls above 0Ch (except 30) in device drivers

		xor	ax,ax
		mov	es,ax			

		lds	ax,es:[13h*4]           ;BIOS Disk Sevice
                mov     cs:[OldInt13Off],ax
                mov     cs:[OldInt13Seg],ds

		lds	ax,es:[1ch*4]           ;BIOS User ticker
                mov     cs:[OldInt1COff],ax
                mov     cs:[OldInt1CSeg],ds

; ------------  load VECTORS FOR OUR MONITOR INTERRUPTS

	; to set our INT13h handler

                mov     word ptr es:[13h*4],offset Ourint13                
                mov     es:[13h*4+2],cs

	;to set our INT1Ch handler

        cli
                mov     word ptr es:[1ch*4],offset Ourint1c                
                mov     es:[1ch*4+2],cs
	sti
		pop	es		; point ES back to header 
		jmp	exit1

Init            endp
;
;==============================================================================
;==============================================================================
; NON-RESIDENT MESSAGES FOR INIT
;==============================================================================

BannerMsg	label   byte
db      cr,lf
;                 1                2         3         4         5         6
;        1234567890       123456789012345678901234567890123456789012345678901234567890
db      '        ',U_LEFT, 59 DUP (H_BAR), U_RIGHT,cr,lf
db      '        ',V_BAR,'                                                           ', V_BAR, cr,lf
db      '        ',V_BAR,'         <<<<<<<  Timed Hard Disk Parker   >>>>>>>         ', V_BAR, cr,lf
db      '$'

DefaultMsg	 label   byte
db      '        ',V_BAR,'                                                           ', V_BAR, cr,lf
db      '        ',V_BAR,'         Version 3.70'

if (not seeks and not sav_stack)
	db	'  '	
endif
if (seeks and not sav_stack)
	db	's '
endif
if (not seeks and sav_stack)
	db	't '
endif
if (seeks and sav_stack)
	db	'ts'
endif

db	' *** 11 MAY 90 ** T.D. COBB         ', V_BAR, cr,lf
db      '        ',V_BAR,'    Parts of this Code placed in the PUBLIC DOMAIN by      ', V_BAR, cr,lf
db      '        ',V_BAR,'           C. Hochsttter, Sanford J. Zelkovitz            ', V_BAR, cr,lf
db      '        ',V_BAR,'                                                           ', V_BAR, cr,lf

;b      '        ',V_BAR,'      The Default Setting of 1 Minute is in effect.        ', V_BAR, cr,lf
;b      '        ',V_BAR,'      The Default Setting of X Minutes is in effect.       ', V_BAR, cr,lf

db      '        ',V_BAR,'      The Default Setting of ',default_time,' '
if	(default_time EQ '1')
db	'Minute is in effect.        ', V_BAR, cr,lf
else
db	'Minutes is in effect.       ', V_BAR, cr,lf
endif

db      '        ',V_BAR,'                                                           ', V_BAR, cr,lf
db      '        ',V_BAR,'             Use: DEVICE=TIMEPARK.SYS [/Tn /S]             ', V_BAR, cr,lf
db      '        ',V_BAR,'                                                           ', V_BAR, cr,lf
db      '        ',V_BAR,'       Where "n" is 1 to 9 minutes and will cause          ', V_BAR, cr,lf
db      '        ',V_BAR,'        Part Suppression of this Display Message.          ', V_BAR, cr,lf
db      '        ',V_BAR,'                                                           ', V_BAR, cr,lf
db      '        ',V_BAR,'   Where "/S" will Suppress all Display Message Output.    ', V_BAR, cr,lf
db      '        ',V_BAR,'                                                           ', V_BAR, cr,lf
DB      '$'

ParkMsg        label   byte
db      '        ',V_BAR,'          This Routine has been made Resident and          ',V_BAR, cr,lf
db      '        ',V_BAR,'        Will Park both drive C: and D:, if present.        ',V_BAR, cr,lf
db      '        ',V_BAR,'     Drives will be Parked '

timemsg label   byte
db      '1'
db      ' minute'
Smsg    label   byte
db      ' '
db      ' after last Access.    ',V_BAR,cr,lf

memsize=((((Tsr_end - Resident_park) +15) SHR 4) *16)
db      '        ',V_BAR,'               '
db      (memsize/100)+30h
db      ((memsize-((memsize/100)*100))/10)+30h
db      (memsize-(((memsize/100)*100)+(((memsize-((memsize/100)*100))/10)*10)))+30h
db      ' Bytes of Memory Consumed                ', V_BAR, cr,lf

db      '        ',V_BAR,'                                                           ', V_BAR, cr,lf
db      '        ',L_LEFT, 59 DUP (H_BAR), L_RIGHT
db      cr,lf,'$'
Cseg            ends
                end
